/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.IOUtils;
import fig.basic.StrUtils;
import fig.basic.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Mandate
implements Serializable {
    private static final int serialVersionUID = 42;
    private static final String tmpTag = "#<TMP>#";
    private boolean cleanup;
    private List<String> commands;
    private List<FileBundle> files;
    private List<Mandate> mandates;
    public static final Mandate empty = new Mandate(true);

    public List<FileBundle> getFiles() {
        return this.files;
    }

    public Mandate(boolean cleanup) {
        this.cleanup = cleanup;
        this.commands = new ArrayList<String>();
        this.files = new ArrayList<FileBundle>();
        this.mandates = new ArrayList<Mandate>();
    }

    public String tempifyFileName(String name) {
        if (name == null) {
            return tmpTag;
        }
        return "#<TMP>#/" + name;
    }

    public void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    public void addCommand(String cmd) {
        this.commands.add(cmd);
    }

    public void addFile(FileBundle file) {
        this.files.add(file);
    }

    public void addMandate(Mandate mandate) {
        this.mandates.add(mandate);
    }

    public void execute(String baseTempDir) {
        if (this.commands.size() > 0) {
            File tempDir = new File(baseTempDir, "tmp." + new Random().nextInt(10000000));
            tempDir.mkdir();
            for (FileBundle file : this.files) {
                file.writeContents(tempDir);
            }
            for (String cmd : this.commands) {
                Utils.systemHard(cmd.replaceAll(tmpTag, tempDir.toString()));
            }
            if (this.cleanup) {
                for (FileBundle file : this.files) {
                    file.delete(tempDir);
                }
                tempDir.delete();
            }
        }
        for (Mandate child : this.mandates) {
            child.execute(baseTempDir);
        }
    }

    public static class FileBundle
    implements Serializable {
        private static final int serialVersionUID = 42;
        public final String path;
        public final String charContents;
        public final byte[] byteContents;
        public final boolean containsFileRef;

        public FileBundle(String path, String charContents, boolean containsFileRef) {
            this.path = path;
            this.charContents = charContents;
            this.byteContents = null;
            this.containsFileRef = containsFileRef;
        }

        public FileBundle(String path, byte[] byteContents) {
            this.path = path;
            this.charContents = null;
            this.byteContents = byteContents;
            this.containsFileRef = false;
        }

        public FileBundle(String path, File byteSource) {
            this.path = path;
            try {
                FileInputStream in = new FileInputStream(byteSource);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy(in, out);
                this.charContents = null;
                this.byteContents = out.toByteArray();
                this.containsFileRef = false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FileBundle(String path, List charContentsList, boolean containsFileRef) {
            this.path = path;
            this.charContents = StrUtils.join(charContentsList, "\n") + (charContentsList.size() > 0 ? "\n" : "");
            this.byteContents = null;
            this.containsFileRef = containsFileRef;
        }

        public String getActualPath(File tempDir) {
            return this.path.replaceAll(Mandate.tmpTag, tempDir.toString());
        }

        private String getActualCharContents(File tempDir) {
            if (this.containsFileRef) {
                return this.charContents.replaceAll(Mandate.tmpTag, tempDir.toString());
            }
            return this.charContents;
        }

        public void writeContents(File tempDir) {
            String path = this.getActualPath(tempDir);
            if (this.charContents != null) {
                PrintWriter out = IOUtils.openOutHard(path);
                out.print(this.getActualCharContents(tempDir));
                out.close();
            } else if (this.byteContents != null) {
                try {
                    FileOutputStream out = new FileOutputStream(path);
                    ((OutputStream)out).write(this.byteContents);
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to write to " + path);
                }
            } else {
                throw new RuntimeException("Both byte and char contents can't be emptpy");
            }
        }

        public void delete(File tempDir) {
            new File(this.getActualPath(tempDir)).delete();
        }
    }
}

