/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import fig.basic.IOUtils;
import goblin.CognateId;
import goblin.DerivationTree;
import goblin.ObservationsTracker;
import goblin.Taxon;
import goblin.TreeSamplers;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ma.MultiAlignment;
import nuts.io.Extensions;
import nuts.io.IO;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import pepper.editmodel.Utils;

public class CognateSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<CognateId, Cognate> cognates = CollUtils.map();
    private final Set<Taxon> allNodeIds = new HashSet<Taxon>();

    public void addCognate(CognateId id, Arbre<DerivationTree.DerivationNode> tree, ObservationsTracker obs) {
        if (id == null || tree == null || obs == null) {
            throw new RuntimeException("Trying to add a malformed cognate");
        }
        CognateSet.checkUniqueNodeIds(tree);
        TreeSamplers.checkObservationsConsistent(tree, obs);
        this.cognates.put(id, new Cognate(tree, obs));
        for (Arbre<DerivationTree.DerivationNode> node : tree.nodes()) {
            this.allNodeIds.add(node.getContents().getLanguage());
        }
    }

    public static void checkUniqueNodeIds(Arbre<DerivationTree.DerivationNode> arbre) {
        HashSet<Taxon> seenIds = new HashSet<Taxon>();
        for (Arbre<DerivationTree.DerivationNode> node : arbre.nodes()) {
            Taxon current = node.getContents().getLanguage();
            if (seenIds.contains(current)) {
                throw new RuntimeException("Non unique ids");
            }
            seenIds.add(current);
        }
    }

    public List<String> allWords(Taxon lang) {
        ArrayList<String> result = new ArrayList<String>();
        for (CognateId id : this.getCognateIds()) {
            if (!this.hasWord(id, lang)) continue;
            result.add(this.getWord(id, lang));
        }
        return result;
    }

    public List<String> allWords() {
        ArrayList<String> result = new ArrayList<String>();
        for (Taxon lang : this.getLanguages()) {
            for (CognateId id : this.getCognateIds()) {
                if (!this.hasWord(id, lang)) continue;
                result.add(this.getWord(id, lang));
            }
        }
        return result;
    }

    public List<String> allWords(CognateId id) {
        ArrayList<String> result = new ArrayList<String>();
        for (Taxon lang : this.getLanguages()) {
            if (!this.hasWord(id, lang)) continue;
            result.add(this.getWord(id, lang));
        }
        return result;
    }

    public List<String> allObservedWords() {
        ArrayList<String> obsWords = new ArrayList<String>();
        for (CognateId id : this.getCognateIds()) {
            for (Taxon lang : this.getObs(id).observedLanguages()) {
                obsWords.add(this.getWord(id, lang));
            }
        }
        return obsWords;
    }

    public CognateSet copy() {
        CognateSet result = new CognateSet();
        for (CognateId id : this.cognates.keySet()) {
            Cognate cog = this.getCognate(id);
            result.addCognate(id, cog.tree, cog.obs);
        }
        return result;
    }

    private Cognate getCognate(CognateId id) {
        Cognate result = this.cognates.get(id);
        if (result == null) {
            throw new RuntimeException("id " + id + " not found. Possible keys: " + this.getCognateIds());
        }
        return result;
    }

    public int size() {
        return this.cognates.size();
    }

    public boolean isRoot(CognateId id, Taxon lang) {
        return this.getCognate(id).isRoot(lang);
    }

    public String getWord(CognateId id, Taxon lang) {
        Cognate cognate = this.getCognate(id);
        return DerivationTree.findNodeByLangName(cognate.tree, lang).getContents().getWord();
    }

    public boolean hasWord(CognateId id, Taxon lang) {
        Cognate cognate = this.getCognate(id);
        return DerivationTree.hasNodeWithLangName(cognate.tree, lang);
    }

    public Set<CognateId> getCognateIds() {
        return Collections.unmodifiableSet(this.cognates.keySet());
    }

    public Set<Taxon> getLanguages(CognateId id) {
        return this.getCognate(id).getLanguages();
    }

    public Set<Taxon> getLanguages() {
        return Collections.unmodifiableSet(this.allNodeIds);
    }

    public Arbre<DerivationTree.DerivationNode> getTree(CognateId id) {
        return this.getCognate(id).tree;
    }

    public void updateTree(CognateId id, Arbre<DerivationTree.DerivationNode> newTree) {
        Cognate cognate = this.getCognate(id);
        newTree = newTree.root();
        CognateSet.consistencyCheck(cognate.tree, newTree, cognate.obs);
        this.getCognate(id).tree = newTree;
    }

    public int nObserved(CognateId id) {
        ObservationsTracker obs = this.getObs(id);
        Arbre<DerivationTree.DerivationNode> arbre = this.getTree(id);
        int result = 0;
        for (Arbre<DerivationTree.DerivationNode> subtree : arbre.nodes()) {
            if (!obs.isObserved(subtree.getContents().getLanguage())) continue;
            ++result;
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (CognateId id : this.cognates.keySet()) {
            builder.append(this.toString(id) + "\n----\n");
        }
        return builder.toString();
    }

    public String toString(CognateId id) {
        StringBuilder builder = new StringBuilder();
        builder.append("Id: " + id + "\n");
        Cognate cog = this.cognates.get(id);
        builder.append("Observed languages: " + cog.obs + "; ");
        builder.append(CognateSet.treeAndAlignToString(cog.tree));
        return builder.toString();
    }

    public static String treeAndAlignToString(Arbre<DerivationTree.DerivationNode> tree) {
        StringBuilder builder = new StringBuilder();
        builder.append("Tree:\n" + tree.deepToString() + "\n");
        try {
            builder.append("Alignments:\n" + MultiAlignment.inducedMultiAlignment(tree, ObservationsTracker.allObservationsTracker(tree)));
        }
        catch (Exception e) {
            builder.append("Alignments not defined");
        }
        return builder.toString();
    }

    private static void consistencyCheck(Arbre<DerivationTree.DerivationNode> oldTree, Arbre<DerivationTree.DerivationNode> newTree, ObservationsTracker obs) {
        Taxon lang = oldTree.getContents().getLanguage();
        if (!lang.equals(newTree.getContents().getLanguage())) {
            throw new RuntimeException("Lang label problem old:" + lang + ", new: " + newTree.getContents().getLanguage());
        }
        if (obs.isObserved(lang) && !oldTree.getContents().getWord().equals(newTree.getContents().getWord())) {
            throw new RuntimeException("Trying to set an observed language. Old:\n" + oldTree.deepToString() + "\nNew:\n" + newTree.deepToString());
        }
        int nChildren = oldTree.getChildren().size();
        if (nChildren != newTree.getChildren().size()) {
            throw new RuntimeException("Topologies don't match");
        }
        ArrayList<Arbre<DerivationTree.DerivationNode>> sorted1 = new ArrayList<Arbre<DerivationTree.DerivationNode>>();
        ArrayList<Arbre<DerivationTree.DerivationNode>> sorted2 = new ArrayList<Arbre<DerivationTree.DerivationNode>>();
        sorted1.addAll(oldTree.getChildren());
        sorted2.addAll(newTree.getChildren());
        Comparator<Arbre<DerivationTree.DerivationNode>> comp = new Comparator<Arbre<DerivationTree.DerivationNode>>(){

            @Override
            public int compare(Arbre<DerivationTree.DerivationNode> arg0, Arbre<DerivationTree.DerivationNode> arg1) {
                return arg0.getContents().getLanguage().toString().compareTo(arg1.getContents().getLanguage().toString());
            }
        };
        Collections.sort(sorted1, comp);
        Collections.sort(sorted2, comp);
        for (int c = 0; c < nChildren; ++c) {
            CognateSet.consistencyCheck((Arbre)sorted1.get(c), (Arbre)sorted2.get(c), obs);
        }
    }

    public ObservationsTracker getObs(CognateId id) {
        return this.getCognate(id).obs;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        if (args.length != 1) {
            System.err.println("1 arg: path to the CognateSet to display");
            return;
        }
        String path = args[0];
        CognateSet cs = CognateSet.restoreCognateSet(path);
        IO.so(cs.toString());
        IO.so(CognateSet.gapLengthDistribution(cs));
    }

    private static String gapLengthDistribution(CognateSet cs) {
        return "";
    }

    public static void saveCognateSetInExec(CognateSet params, String prefix) {
        CognateSet.saveCognateSetInExec(params, prefix, null);
    }

    public static void saveCognateSetInExec(CognateSet cs, String prefix, Integer iteration) {
        String fileName = prefix + (iteration == null ? "" : Extensions.extension2String(iteration)) + ".CognateSet";
        try {
            CognateSet.saveCognateSet(cs, Utils.safeGetExecFilePath(fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveCognateSet(CognateSet cognateSet, String filePath) throws IOException {
        ObjectOutputStream oos = IOUtils.openBinOut(filePath);
        oos.writeObject(cognateSet);
        oos.close();
    }

    public static CognateSet restoreCognateSet(String filePath) throws IOException, ClassNotFoundException {
        return CognateSet.restoreCognateSet(new File(filePath));
    }

    public static CognateSet restoreCognateSet(File filePath) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = IOUtils.openBinIn(filePath);
        return (CognateSet)ois.readObject();
    }

    public static class Cognate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Arbre<DerivationTree.DerivationNode> tree;
        private final ObservationsTracker obs;

        public Cognate(Arbre<DerivationTree.DerivationNode> tree, ObservationsTracker obs) {
            this.tree = tree.root().copy();
            this.obs = obs;
        }

        public Set<Taxon> getLanguages() {
            HashSet<Taxon> result = new HashSet<Taxon>();
            for (Arbre<DerivationTree.DerivationNode> node : this.tree.nodes()) {
                result.add(node.getContents().getLanguage());
            }
            return result;
        }

        public boolean isRoot(Taxon lang) {
            return this.tree.getContents().getLanguage().equals(lang);
        }
    }
}

