/*
 * Decompiled with CFR 0.152.
 */
package nuts.maxent;

import java.util.HashMap;
import nuts.maxent.FeatureExtractor;
import nuts.maxent.FeatureVectorsInterface;
import nuts.maxent.LabeledInstance;
import nuts.maxent.SparseVector;
import nuts.util.Counter;

public class HashedFeatureVectors<I, L, F>
implements FeatureVectorsInterface<I, L> {
    private final FeatureExtractor<LabeledInstance<I, L>, F> extractor;
    private final int m;
    private final int n;

    private HashedFeatureVectors(FeatureExtractor<LabeledInstance<I, L>, F> extractor) {
        this.extractor = extractor;
        this.m = 1400000;
        this.n = 0;
    }

    public static <I, L, F> HashedFeatureVectors<I, L, F> createFeatureVectors(FeatureExtractor<LabeledInstance<I, L>, F> extractor) {
        HashedFeatureVectors<I, L, F> result = new HashedFeatureVectors<I, L, F>(extractor);
        return result;
    }

    @Override
    public double[] createInitialWeight() {
        return this.createInitialWeight(new Counter());
    }

    @Override
    public double[] createInitialWeight(Counter init) {
        double[] result = new double[this.dim()];
        for (Object feature : init.keySet()) {
            int index = (Integer)feature;
            result[index] = init.getCount(feature);
        }
        return result;
    }

    @Override
    public int dim() {
        return this.m;
    }

    @Override
    public SparseVector getFeatureVector(LabeledInstance<I, L> labeledInstance, boolean cache) {
        Counter<F> counter = this.extractor.extractFeatures(labeledInstance);
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (F feature : counter) {
            String feature1 = feature.toString() + "_h1";
            Integer key1 = new Integer(Math.abs(feature1.hashCode()) % this.dim());
            double existingValue = 0.0;
            if (map.containsKey(key1)) {
                existingValue = map.remove(key1);
            }
            Double val1 = new Double(existingValue + counter.getCount(feature));
            map.put(key1, val1);
            String feature2 = "h2_" + feature.toString();
            Integer key2 = new Integer(Math.abs(feature2.hashCode()) % this.dim());
            existingValue = 0.0;
            if (map.containsKey(key2)) {
                existingValue = map.remove(key2);
            }
            Double val2 = new Double(existingValue + counter.getCount(feature));
            map.put(key2, val2);
        }
        SparseVector sparseVector = new SparseVector(map, this.dim());
        return sparseVector;
    }

    @Override
    public double getRegularizationFactor(int index) {
        return 1.0;
    }

    @Override
    public Counter namedCounter(double[] weights) {
        assert (weights.length == this.dim());
        Counter<Integer> counter = new Counter<Integer>();
        for (int i = 0; i < this.dim(); ++i) {
            counter.setCount(new Integer(i), weights[i]);
        }
        return counter;
    }

    public int size() {
        return this.n;
    }

    private double xi(F feature) {
        return 1.0;
    }
}

