/*
 * Decompiled with CFR 0.152.
 */
package nuts.tools;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import fig.basic.Parallelizer;
import fig.exec.Execution;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.Counter;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class ContestGrader
implements Runnable {
    @Option
    public int nTrials = 10;
    @Option
    public int nThreads = 1;
    @Option
    public int timeOut = 180000;
    @Option
    public String pythonPath = "";
    @Option
    public boolean ignoreWarning = false;
    @Option
    public String projectPath = ".";

    public static void main(String[] args) {
        Execution.monitor = true;
        Execution.makeThunk = false;
        Execution.create = true;
        Execution.useStandardExecPoolDirStrategy = true;
        Execution.run(args, new ContestGrader());
    }

    private static double parse(String cur) {
        try {
            return new Double(StringUtils.selectFirstRegex("Pacman.*Score[:]\\s(.*)", cur));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static int call(String cmdAndArgs, String inputStreamContents, final StrProcessor stdoutProcessor, long maxDelay, File workingDir) {
        try {
            String[] split = cmdAndArgs.split("\\s+");
            ProcessBuilder pb = new ProcessBuilder(Arrays.asList(split));
            if (workingDir != null) {
                pb.directory(workingDir);
            }
            pb.redirectErrorStream(true);
            final Process proc = pb.start();
            Timer timer = new Timer();
            if (maxDelay != Long.MAX_VALUE) {
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        stdoutProcessor.process("Command timed out");
                        proc.destroy();
                    }
                }, maxDelay);
            }
            InputStream stdout = proc.getInputStream();
            InputStreamReader stdoutReader = new InputStreamReader(stdout);
            BufferedReader stdoutBufferedReader = new BufferedReader(stdoutReader);
            String line = null;
            if (inputStreamContents != null) {
                OutputStream stdin = proc.getOutputStream();
                PrintWriter pw = new PrintWriter(stdin);
                pw.append(inputStreamContents);
                pw.close();
            }
            while ((line = stdoutBufferedReader.readLine()) != null) {
                stdoutProcessor.process(line + "\n");
            }
            int resultCode = proc.waitFor();
            timer.cancel();
            return resultCode;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void run() {
        String v;
        if (this.pythonPath.equals("")) {
            this.pythonPath = IO.call("/usr/bin/which python");
        }
        if (!(v = IO.call(this.pythonPath + " -V")).contains("2.6")) {
            if (this.ignoreWarning) {
                LogInfo.warning("Not using 2.6:" + v);
            } else {
                throw new RuntimeException("You should use python 2.6! Using:" + v);
            }
        }
        List<File> directories = IO.ls(new File(this.projectPath));
        final Map allOutput = Collections.synchronizedMap(new HashMap());
        Parallelizer<File> parallelizer = new Parallelizer<File>(this.nThreads);
        parallelizer.setPrimaryThread();
        parallelizer.process(directories, new Parallelizer.Processor<File>(){

            @Override
            public void process(File f, int _i, int _n, boolean log) {
                LogInfo.logs("Processing " + f);
                for (int i = 0; i < ContestGrader.this.nTrials; ++i) {
                    final StringBuilder output = new StringBuilder();
                    ContestGrader.call(ContestGrader.this.pythonPath + " pacman.py -l contestClassic -p ContestAgent -g DirectionalGhost -q", null, new StrProcessor(){

                        @Override
                        public void process(String line) {
                            output.append(line + "\n");
                        }
                    }, ContestGrader.this.timeOut, f);
                    allOutput.put(Pair.makePair(f.getName(), i), output.toString());
                }
            }
        });
        Counter<String> scores = new Counter<String>();
        for (File f : directories) {
            SummaryStatistics stats = new SummaryStatistics();
            LogInfo.track((Object)("" + f), true);
            for (int i = 0; i < this.nTrials; ++i) {
                LogInfo.track((Object)("Execution " + i), true);
                String cur = (String)allOutput.get(Pair.makePair(f.getName(), i));
                LogInfo.logs(cur);
                double score = ContestGrader.parse(cur);
                stats.addValue(score);
                LogInfo.logs("Extracted score: " + score);
                LogInfo.end_track();
            }
            double trimmedMean = this.trimmedMean(stats);
            LogInfo.logs("Trimmed mean score: " + trimmedMean);
            scores.setCount(f.getName(), trimmedMean);
            LogInfo.end_track();
        }
        LogInfo.track((Object)"Final scores", true);
        for (String key : scores) {
            LogInfo.logs("" + key + "\t" + scores.getCount(key));
        }
        LogInfo.end_track();
    }

    private double trimmedMean(SummaryStatistics stats) {
        return (stats.getSum() - stats.getMin() - stats.getMax()) / (double)(stats.getN() - 2L);
    }

    public static interface StrProcessor {
        public void process(String var1);
    }
}

