/*
 * Decompiled with CFR 0.152.
 */
package nuts.xml;

import fig.basic.IOUtils;
import java.io.IOException;
import java.io.PrintWriter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PrintHandler
extends DefaultHandler {
    public PrintWriter writer;

    public PrintHandler(PrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < length; ++i) {
            this.writer.append(ch[start + i]);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.writer.append("</");
        if (!localName.equals("")) {
            this.writer.append(localName);
        } else {
            this.writer.append(qName);
        }
        this.writer.append(">");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.writer.append("<");
        if (!localName.equals("")) {
            this.writer.append(localName);
        } else {
            this.writer.append(qName);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            this.writer.append(" ");
            if (!atts.getLocalName(i).equals("")) {
                this.writer.append(atts.getLocalName(i));
            } else {
                this.writer.append(atts.getQName(i));
            }
            this.writer.append("=\"");
            this.writer.append(atts.getValue(i));
            this.writer.append("\"");
        }
        this.writer.append(">");
    }

    @Override
    public void endDocument() throws SAXException {
        this.writer.flush();
    }

    protected void print(String s) {
        this.writer.append(s);
    }

    public static void main(String[] args) throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler(new PrintHandler(IOUtils.openOut("testCases/temp/xmlOut")));
        xmlReader.parse(new InputSource(IOUtils.openIn("testCases/xmlIn")));
    }
}

