/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import java.util.List;

class WordList {
    private String[] words;
    private boolean[] isObserved;
    private String[] heldOut;
    private String[] initialization;
    private int heldOutSize;
    private int numberOfWordsKnown;

    public WordList(WordList model) {
        this.words = (String[])model.words.clone();
        this.isObserved = (boolean[])model.isObserved.clone();
        this.heldOut = (String[])model.heldOut.clone();
        this.initialization = (String[])model.initialization.clone();
        this.heldOutSize = model.heldOutSize;
        this.numberOfWordsKnown = model.numberOfWordsKnown;
    }

    public int size() {
        return this.words.length;
    }

    public String getWord(int i) {
        return this.words[i];
    }

    public void setWord(int i, String word) {
        if (this.isObserved[i]) {
            throw new RuntimeException("Illegal attempt to set observed word.");
        }
        this.words[i] = word;
    }

    public boolean isObserved(int i) {
        return this.isObserved[i];
    }

    public boolean isHeldOut(int i) {
        return this.heldOut[i] != null;
    }

    public String getHeldOut(int i) {
        return this.heldOut[i];
    }

    public String getInitialization(int i) {
        return this.initialization[i];
    }

    public void setInitialization(int i, String init) {
        if (this.initialization[i] != null) {
            throw new RuntimeException("Illegal op.");
        }
        this.initialization[i] = init;
    }

    public int getHeldOutSize() {
        return this.heldOutSize;
    }

    public int getNumberOfWordsKnown() {
        return this.numberOfWordsKnown;
    }

    public WordList(List<String> inWords, double heldoutprop) {
        this.words = new String[inWords.size()];
        this.initialization = new String[inWords.size()];
        this.isObserved = new boolean[inWords.size()];
        this.heldOut = new String[inWords.size()];
        for (String word : inWords) {
            if (word == null) continue;
            ++this.numberOfWordsKnown;
        }
        this.heldOutSize = (int)(heldoutprop * (double)this.numberOfWordsKnown);
        int heldOutSoFar = 0;
        for (int i = 0; i < inWords.size(); ++i) {
            String word = inWords.get(i);
            if (word == null) {
                this.words[i] = null;
                this.isObserved[i] = false;
                this.heldOut[i] = null;
                continue;
            }
            if (heldOutSoFar < this.heldOutSize) {
                this.words[i] = null;
                this.isObserved[i] = false;
                this.heldOut[i] = word;
                ++heldOutSoFar;
                continue;
            }
            this.words[i] = word;
            this.isObserved[i] = true;
            this.heldOut[i] = null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("# Word \t isObserved? \t initialization \t heldOut\n");
        for (int i = 0; i < this.words.length; ++i) {
            builder.append(this.words[i] + "\t" + this.isObserved[i] + "\t" + this.initialization[i] + "\t" + this.heldOut[i] + "\t\n");
        }
        return builder.toString();
    }
}

