/*
 * Decompiled with CFR 0.152.
 */
package pty.cons;

import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import nuts.util.Counter;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.eval.SymmetricDiff;

public class CladeConsensus {
    public static Arbre<Taxon> consensusTopology(Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> counter, double threshold) {
        if (threshold < 0.5) {
            throw new RuntimeException();
        }
        HashSet rootedClades = CollUtils.set();
        UnorderedPair<Set<Taxon>, Set<Taxon>> aBipart = CollUtils.pick(counter.keySet());
        Taxon aTaxon = (Taxon)CollUtils.pick((Collection)aBipart.getFirst());
        for (UnorderedPair<Set<Taxon>, Set<Taxon>> key : counter.keySet()) {
            if (!(counter.getCount(key) >= threshold)) continue;
            rootedClades.add(CladeConsensus.rootClade(key, aTaxon));
        }
        for (Taxon t : aBipart.getFirst()) {
            rootedClades.add(Collections.singleton(t));
        }
        for (Taxon t : aBipart.getSecond()) {
            rootedClades.add(Collections.singleton(t));
        }
        rootedClades.add(CollUtils.union(aBipart.getFirst(), aBipart.getSecond()));
        Arbre a = SymmetricDiff.clades2arbre(rootedClades);
        return a.preOrderMap(new Arbre.ArbreMap<Taxon, Taxon>(){
            private int n = 0;

            @Override
            public Taxon map(Arbre<Taxon> currentDomainNode) {
                if (currentDomainNode.getContents() == null) {
                    return new Taxon("internal_" + this.n++);
                }
                return currentDomainNode.getContents();
            }
        });
    }

    public static UnrootedTree consensusUnrootedTree(Counter<UnorderedPair<Set<Taxon>, Set<Taxon>>> counter, double threshold) {
        if (threshold < 0.5 || threshold > 1.0) {
            throw new RuntimeException();
        }
        Arbre<Taxon> topology = CladeConsensus.consensusTopology(counter, threshold);
        Map<Arbre<Taxon>, Set<Taxon>> leaves = Arbre.leavesMap(topology);
        Set<Taxon> allTaxa = leaves.get(topology);
        HashMap<Taxon, Double> bls = CollUtils.map();
        for (Arbre<Taxon> subt : topology.nodes()) {
            if (subt.isRoot()) continue;
            Set<Taxon> set1 = leaves.get(subt);
            HashSet<Taxon> complement = CollUtils.set(allTaxa);
            complement.removeAll(set1);
            UnorderedPair<Set<Taxon>, HashSet<Taxon>> key = new UnorderedPair<Set<Taxon>, HashSet<Taxon>>(set1, complement);
            double currentBL = counter.getCount(key);
            bls.put(subt.getContents(), currentBL);
        }
        RootedTree.Util.RootedTreeImpl rt = new RootedTree.Util.RootedTreeImpl(topology, bls);
        return UnrootedTree.fromRooted(rt);
    }

    private static Set<Taxon> rootClade(UnorderedPair<Set<Taxon>, Set<Taxon>> bipartition, Taxon out) {
        if (bipartition.getFirst().contains(out)) {
            return bipartition.getSecond();
        }
        if (bipartition.getSecond().contains(out)) {
            return bipartition.getFirst();
        }
        throw new RuntimeException();
    }
}

