/*
 * Decompiled with CFR 0.152.
 */
package pty.mcmc;

import fig.basic.Option;
import fig.basic.Pair;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import pty.UnrootedTree;

public interface ProposalDistribution {
    public Pair<UnrootedTree, Double> propose(UnrootedTree var1, Random var2);

    public String description();

    public static class StochasticNearestNeighborInterchangeProposal
    implements ProposalDistribution {
        private final boolean resampleNbrEdges;
        private final double a;
        private UnorderedPair<Taxon, Taxon> lastEdge = null;

        public StochasticNearestNeighborInterchangeProposal() {
            this.resampleNbrEdges = false;
            this.a = -1.0;
        }

        public StochasticNearestNeighborInterchangeProposal(boolean resampleNbrEdges, double a) {
            this.resampleNbrEdges = resampleNbrEdges;
            this.a = a;
        }

        public UnorderedPair<Taxon, Taxon> getLastEdgePicked() {
            return this.lastEdge;
        }

        @Override
        public Pair<UnrootedTree, Double> propose(UnrootedTree current, Random rand) {
            UnorderedPair<Taxon, Taxon> edge = current.randomNonTerminalEdge(rand);
            if (edge == null) {
                return null;
            }
            this.lastEdge = edge;
            int picked = rand.nextInt(2);
            UnrootedTree proposedTree = current.topologicalNeighbors(edge).get(picked);
            double sum = 0.0;
            if (this.resampleNbrEdges) {
                for (UnorderedPair<Taxon, Taxon> nbrEdge : proposedTree.nbrEdges(edge)) {
                    double m = Sampling.nextDouble(rand, 1.0 / this.a, this.a);
                    Pair<UnrootedTree, Double> p = MultiplicativeBranchProposal.propose(proposedTree, rand, nbrEdge, m);
                    proposedTree = p.getFirst();
                    sum += p.getSecond().doubleValue();
                }
            }
            return Pair.makePair(proposedTree, sum);
        }

        @Override
        public String description() {
            return "sNNI" + (this.resampleNbrEdges ? "+MB(" + this.a + ")" : "");
        }
    }

    public static class MultiplicativeBranchProposal
    implements ProposalDistribution {
        private final double a;
        private final boolean global;

        public MultiplicativeBranchProposal(double a, boolean global) {
            if (a <= 1.0) {
                throw new RuntimeException();
            }
            this.global = global;
            this.a = a;
        }

        @Override
        public Pair<UnrootedTree, Double> propose(UnrootedTree current, Random rand) {
            double m = Sampling.nextDouble(rand, 1.0 / this.a, this.a);
            if (this.global) {
                double sum = 0.0;
                UnrootedTree proposedTree = current;
                for (UnorderedPair<Taxon, Taxon> edge : current.edges()) {
                    Pair<UnrootedTree, Double> p = MultiplicativeBranchProposal.propose(proposedTree, rand, edge, m);
                    proposedTree = p.getFirst();
                    sum += p.getSecond().doubleValue();
                }
                return Pair.makePair(proposedTree, sum);
            }
            return MultiplicativeBranchProposal.propose(current, rand, current.randomEdge(rand), m);
        }

        public static Pair<UnrootedTree, Double> propose(UnrootedTree current, Random rand, UnorderedPair<Taxon, Taxon> edge, double m) {
            double newBL = m * current.branchLength(edge);
            UnrootedTree proposedTree = current.branchLengthNeighbor(edge, newBL);
            return Pair.makePair(proposedTree, Math.log(m));
        }

        @Override
        public String description() {
            return (this.global ? "g" : "") + "MB(" + this.a + ")";
        }
    }

    public static class IndepBranchProposal
    implements ProposalDistribution {
        @Override
        public String description() {
            return "indepBL";
        }

        @Override
        public Pair<UnrootedTree, Double> propose(UnrootedTree current, Random rand) {
            UnorderedPair<Taxon, Taxon> edge = current.randomEdge(rand);
            double oldVal = current.branchLength(edge);
            double newVal = Sampling.sampleExponential(rand, 1.0);
            double logRatio = Sampling.exponentialLogDensity(1.0, oldVal) - Sampling.exponentialLogDensity(1.0, newVal);
            UnrootedTree proposedTree = current.branchLengthNeighbor(edge, newVal);
            return Pair.makePair(proposedTree, logRatio);
        }
    }

    public static class Util {
        public static final Options _defaultProposalDistributionOptions = new Options();

        public static List<ProposalDistribution> proposalList(Options options, UnrootedTree nct, Random rand) {
            ArrayList<ProposalDistribution> result = new ArrayList<ProposalDistribution>();
            if (options.useMultiplicativeBranchProposal) {
                result.add(new MultiplicativeBranchProposal(options.multiplicativeBranchProposalScaling, false));
            }
            if (options.useGlobalMultiplicativeBranchProposal) {
                result.add(new MultiplicativeBranchProposal(options.multiplicativeBranchProposalScaling, true));
            }
            if (options.useStochasticNearestNeighborInterchangeProposal) {
                result.add(new StochasticNearestNeighborInterchangeProposal());
            }
            if (options.useStochasticNearestNeighborInterchangeProposalWithNbrsResampling) {
                result.add(new StochasticNearestNeighborInterchangeProposal(true, options.multiplicativeBranchProposalScaling));
            }
            if (options.useIndepBranchProp) {
                result.add(new IndepBranchProposal());
            }
            Collections.shuffle(result, rand);
            return result;
        }
    }

    public static class Options {
        @Option
        public double multiplicativeBranchProposalScaling = 2.0;
        @Option
        public boolean useMultiplicativeBranchProposal = true;
        @Option
        public boolean useGlobalMultiplicativeBranchProposal = true;
        @Option
        public boolean useStochasticNearestNeighborInterchangeProposal = true;
        @Option
        public boolean useStochasticNearestNeighborInterchangeProposalWithNbrsResampling = true;
        @Option
        public boolean useIndepBranchProp = false;
    }
}

