/*
 * Decompiled with CFR 0.152.
 */
package pty.smc;

import goblin.Taxon;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import nuts.util.CollUtils;

public class MapLeaves {
    private final Map<Taxon, Taxon> languageGeneMap;
    private final Map<Taxon, Taxon> geneLanguageMap;

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Taxon key : this.languageGeneMap.keySet()) {
            result.append("" + key + "\t" + this.languageGeneMap.get(key) + "\n");
        }
        return result.toString();
    }

    public Set<Taxon> mapItemsNotInData(Set<Taxon> ... data) {
        HashSet<Taxon> _data = new HashSet<Taxon>();
        for (Set<Taxon> cur : data) {
            _data.addAll(cur);
        }
        _data.removeAll(this.languageGeneMap.keySet());
        _data.removeAll(this.geneLanguageMap.keySet());
        return _data;
    }

    public Set<Taxon> dataNotInMapItems(Set<Taxon> ... data) {
        Set<Taxon> keys = CollUtils.union(this.languageGeneMap.keySet(), this.geneLanguageMap.keySet());
        for (Set<Taxon> cur : data) {
            keys.removeAll(cur);
        }
        return keys;
    }

    public static MapLeaves parse(String filename) {
        HashMap<Taxon, Taxon> languageGeneMap = new HashMap<Taxon, Taxon>();
        HashMap<Taxon, Taxon> geneLanguageMap = new HashMap<Taxon, Taxon>();
        try {
            String s;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            int linenum = 0;
            while ((s = br.readLine()) != null) {
                StringTokenizer tok = new StringTokenizer(s, " ");
                String[] tmp = new String[2];
                int i = 0;
                while (tok.hasMoreTokens() && i < 2) {
                    tmp[i++] = tok.nextToken();
                }
                languageGeneMap.put(new Taxon(tmp[0]), new Taxon(tmp[1]));
                geneLanguageMap.put(new Taxon(tmp[1]), new Taxon(tmp[0]));
                ++linenum;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new MapLeaves(languageGeneMap, geneLanguageMap);
    }

    public MapLeaves(Map<Taxon, Taxon> languageGeneMap, Map<Taxon, Taxon> geneLanguageMap) {
        this.languageGeneMap = CollUtils.archive(languageGeneMap);
        this.geneLanguageMap = CollUtils.archive(geneLanguageMap);
    }

    public static <S, T> Set<T> mapSet(Set<S> s, Map<S, T> map) {
        HashSet<T> translatedLanguages = new HashSet<T>();
        for (S l : s) {
            T value = map.get(l);
            if (value == null) continue;
            translatedLanguages.add(value);
        }
        return translatedLanguages;
    }

    public Taxon translate(Taxon l) {
        Taxon t1 = this.languageGeneMap.get(l);
        Taxon t2 = this.geneLanguageMap.get(l);
        if (t1 != null && t2 != null) {
            throw new RuntimeException();
        }
        if (t1 != null) {
            return t1;
        }
        if (t2 != null) {
            return t2;
        }
        return null;
    }

    public Set<Taxon> translate(Set<Taxon> s) {
        Set<Taxon> s1 = MapLeaves.mapSet(s, this.geneLanguageMap);
        Set<Taxon> s2 = MapLeaves.mapSet(s, this.languageGeneMap);
        return MapLeaves.atMostOneEmptySet(s1, s2);
    }

    private static <S> Set<S> atMostOneEmptySet(Set<S> s1, Set<S> s2) {
        if (!s1.isEmpty() && !s2.isEmpty()) {
            throw new RuntimeException();
        }
        if (!s1.isEmpty()) {
            return s1;
        }
        if (!s2.isEmpty()) {
            return s2;
        }
        return s1;
    }

    public Set<Taxon> restrict(Set<Taxon> s) {
        HashSet<Taxon> s1 = new HashSet<Taxon>(s);
        HashSet<Taxon> s2 = new HashSet<Taxon>(s);
        s1.retainAll(this.geneLanguageMap.keySet());
        s2.retainAll(this.languageGeneMap.keySet());
        return MapLeaves.atMostOneEmptySet(s1, s2);
    }

    public Set<Set<Taxon>> mapClades(Set<Set<Taxon>> clades) {
        HashSet<Set<Taxon>> result = new HashSet<Set<Taxon>>();
        for (Set<Taxon> clade : clades) {
            Set<Taxon> currentMapped = this.translate(clade);
            if (currentMapped.isEmpty()) continue;
            result.add(currentMapped);
        }
        return result;
    }

    public Set<Set<Taxon>> filterClades(Set<Set<Taxon>> clades) {
        HashSet<Set<Taxon>> result = new HashSet<Set<Taxon>>();
        for (Set<Taxon> clade : clades) {
            Set<Taxon> currentFiltered = this.restrict(clade);
            if (currentFiltered.isEmpty()) continue;
            result.add(currentFiltered);
        }
        return result;
    }

    public Map<Taxon, Taxon> getLanguageGeneMap() {
        return this.languageGeneMap;
    }

    public Map<Taxon, Taxon> getGeneLanguageMap() {
        return this.geneLanguageMap;
    }
}

