/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.test;

import ev.ex.TreeGenerators;
import ev.poi.processors.TreeDistancesProcessor;
import ev.to.NJ;
import fig.basic.Option;
import fig.exec.Execution;
import gep.util.OutputManager;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import nuts.io.IO;
import nuts.util.CollUtils;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.io.Dataset;
import pty.io.HGDPDataset;
import pty.mcmc.ParallelTemperingChain;
import pty.mcmc.PhyloSampler;
import pty.mcmc.UnrootedTreeState;
import pty.smc.ConstrainedKernel;
import pty.smc.NCPriorPriorKernel;
import pty.smc.PartialCoalescentState;
import pty.smc.models.BrownianModel;
import pty.smc.models.BrownianModelCalculator;
import pty.smc.test.TestBrownianModel;

public class NewHGDPExperiment
implements Runnable {
    @Option
    public HGDPExperimentType type = HGDPExperimentType.SMC_NONCLOCK;
    @Option
    public Random inferenceRand = new Random(1L);
    @Option
    public int nIterations = 1000;
    @Option
    public int parallelism = 1;
    @Option
    public int trivialParallelism = 1;
    @Option
    public boolean resampleRoot = false;
    private OutputManager om = new OutputManager();
    private TreeDistancesProcessor processor;
    private Dataset data;
    private BrownianModel bm;

    public static void main(String[] args) {
        IO.run(args, new NewHGDPExperiment(), "hgdp", HGDPDataset.class, "kernel", ConstrainedKernel.class, "filter", TestBrownianModel.pf, "bm", BrownianModelCalculator.class, "pcs", PartialCoalescentState.class, "nc", NCPriorPriorKernel.class, "nj", NJ.class);
    }

    @Override
    public void run() {
    }

    private void outputTree(UnrootedTree inferred, String suffix, long delta) {
        IO.writeToDisk(new File(Execution.getFile("inferred" + suffix + ".newick")), inferred.toNewick());
        UnrootedTreeState ncs = UnrootedTreeState.fromBrownianMotion(inferred, this.data, this.bm);
        this.om.printWrite("likelihood" + suffix, "time", delta, "likelihood" + suffix, ncs.logLikelihood());
    }

    public static enum HGDPExperimentType {
        MCMC_NONCLOCK{

            @Override
            public void doIt(NewHGDPExperiment xp) {
                PartialCoalescentState state = PartialCoalescentState.initState(xp.data, xp.bm, false);
                ArrayList<Taxon> leaves = CollUtils.list(state.getObservations().observations().keySet());
                RootedTree initTree = TreeGenerators.sampleExpNonclock(xp.inferenceRand, leaves, NCPriorPriorKernel.deltaProposalRate);
                UnrootedTreeState ncts = UnrootedTreeState.fromBrownianMotion(UnrootedTree.fromRooted(initTree), xp.data, xp.bm);
                PhyloSampler sampler = new PhyloSampler();
                sampler.init(ncts);
                PhyloSampler.PhyloProcessorAdaptor tdpa = new PhyloSampler.PhyloProcessorAdaptor(xp.processor);
                sampler.setProcessors(Arrays.asList(tdpa));
                ParallelTemperingChain temperingChain = new ParallelTemperingChain();
                temperingChain.init(sampler);
                temperingChain.sample();
            }
        }
        ,
        SMC_NONCLOCK{

            @Override
            public void doIt(NewHGDPExperiment xp) {
                PartialCoalescentState state = PartialCoalescentState.initState(xp.data, xp.bm, xp.resampleRoot);
                NCPriorPriorKernel ppk = new NCPriorPriorKernel(state);
                TestBrownianModel.pf.sample(ppk, xp.processor);
            }
        };


        public abstract void doIt(NewHGDPExperiment var1);
    }
}

