/*
 * Decompiled with CFR 0.152.
 */
package ru;

import goblin.CognateId;
import goblin.CognateSet;
import goblin.DerivationTree;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import ma.MultiAlignment;
import nuts.math.GMFct;
import nuts.math.Graph;
import nuts.math.HashGraph;
import nuts.math.TreeSumProd;
import nuts.util.Arbre;

public class GMCreator {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        int N = 10;
        String path = "data/large-austro.CognateSet";
        CognateSet cs = CognateSet.restoreCognateSet(path);
        long time = 0L;
        int i = 0;
        for (CognateId id : cs.getCognateIds()) {
            Arbre<DerivationTree.DerivationNode> a = cs.getTree(id);
            MultiAlignment msa = MultiAlignment.fullInducedMultiAlignment(a);
            time += GMCreator.time(msa, a);
            if (++i % 10 != 0) continue;
            System.out.println("[" + i + "/" + cs.getCognateIds().size() + "]");
        }
        System.out.println("time:" + time);
    }

    private static long time(MultiAlignment msa, Arbre<DerivationTree.DerivationNode> a) {
        long result = 0L;
        MultiAlignment.LinearizedAlignmentMatrix lam = msa.createAlignmentMatrix();
        Arbre<String> a2 = Arbre.arbreToArbreOfStrings(a);
        final HashGraph<String> g = new HashGraph<String>(Arbre.arbre2Tree(a2));
        HashMap m = new HashMap();
        for (int i = 0; i < lam.nCols(); ++i) {
            HashSet<Character> chars = new HashSet<Character>();
            for (int row = 0; row < lam.nRows(); ++row) {
                if (lam.charAt(row, i) != '.') {
                    chars.add(Character.valueOf(lam.charAt(row, i)));
                    continue;
                }
                chars.add(Character.valueOf('-'));
            }
            if (chars.size() == 1) continue;
            final int N = chars.size();
            GMFct pot = new GMFct(){

                public double get(Object n1, Object n2, int s1, int s2) {
                    return 1.0;
                }

                public double get(Object n, int s) {
                    return 1.0;
                }

                public Graph graph() {
                    return g;
                }

                public int nStates(Object node) {
                    return N;
                }
            };
            long time = System.currentTimeMillis();
            new TreeSumProd(pot).logZ();
            result += System.currentTimeMillis() - time;
        }
        return result;
    }
}

