/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;

public class EnumerateUnorderedWithReplacement {
    public static double trimCnst = 0.125;
    public static Random rand = new Random();

    public static double factorial(int n) {
        if (n == 0) {
            return 1.0;
        }
        return (double)n * EnumerateUnorderedWithReplacement.factorial(n - 1);
    }

    public static double nCk(int n, int k) {
        return EnumerateUnorderedWithReplacement.factorial(n) / EnumerateUnorderedWithReplacement.factorial(k) / EnumerateUnorderedWithReplacement.factorial(n - k);
    }

    public static double multinomial(int n, List<Integer> ks) {
        double cur = EnumerateUnorderedWithReplacement.factorial(n);
        for (int k : ks) {
            cur /= EnumerateUnorderedWithReplacement.factorial(k);
        }
        return cur;
    }

    public static void testExactStandardError() {
        Fct<List<Double>, Double> integrand = EnumerateUnorderedWithReplacement.constructIntegrand();
        ExactBootstrapSampler<Double> sampler = new ExactBootstrapSampler<Double>(EnumerateUnorderedWithReplacement.sortedData());
        MCIntegrator<Double> integrator = new MCIntegrator<Double>(sampler);
        integrator.setIterations((int)EnumerateUnorderedWithReplacement.nCk(2 * EnumerateUnorderedWithReplacement.sortedData().size() - 1, EnumerateUnorderedWithReplacement.sortedData().size()));
        System.out.println("Exact bootstrap of the std error: " + Math.sqrt(integrator.integrate(integrand)));
    }

    public static Fct<List<Double>, Double> constructIntegrand() {
        StdError stdError = new StdError(EnumerateUnorderedWithReplacement.trimmedMean(EnumerateUnorderedWithReplacement.sortedData(), trimCnst));
        TrimmedMean trimmedMean = new TrimmedMean(trimCnst);
        return new ComposedFct<List<Double>, Double, Double>(stdError, trimmedMean);
    }

    public static List<Integer> indices2ModIndices(List<Integer> bootstrapIndices) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < bootstrapIndices.size(); ++i) {
            result.add(0);
        }
        for (int currentBootstrapIndex : bootstrapIndices) {
            result.set(currentBootstrapIndex, (Integer)result.get(currentBootstrapIndex) + 1);
        }
        return result;
    }

    public static <T> List<T> indices2Sample(List<Integer> bootstrapIndices, List<T> initialData) {
        ArrayList<T> result = new ArrayList<T>();
        for (int currentIndex : bootstrapIndices) {
            result.add(initialData.get(currentIndex));
        }
        return result;
    }

    public static void testEnumerate() {
        System.out.println("Testing the enumeration procedure...");
        List<List<Integer>> test = EnumerateUnorderedWithReplacement.enumerate(3, 3);
        for (List<Integer> item : test) {
            System.out.println(item);
        }
    }

    public static void testTrimmedMean() {
        System.out.println("" + EnumerateUnorderedWithReplacement.trimmedMean(EnumerateUnorderedWithReplacement.sortedData(), trimCnst));
    }

    public static double trimmedMean(List<Double> data, double skipRatio) {
        return new TrimmedMean(skipRatio).evalAt(data);
    }

    public static double sum(Iterable<Double> list) {
        double sum = 0.0;
        for (Double item : list) {
            sum += item.doubleValue();
        }
        return sum;
    }

    public static <T> void testSampler(Sampler<T> s, Comparator<T> c, int iterations) {
        ArrayList<T> test = new ArrayList<T>();
        for (int i = 0; i < iterations; ++i) {
            test.add(s.sample());
        }
        Collections.sort(test, c);
        Object preceding = null;
        int counter = 0;
        for (Object current : test) {
            if (preceding != null && !preceding.equals(current)) {
                System.out.println("" + preceding + " -> " + counter);
                counter = 0;
            }
            ++counter;
            preceding = current;
        }
        System.out.println("" + preceding + " -> " + counter);
    }

    public static List<List<Integer>> enumerate(int n, int s) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        if (n == 1) {
            ArrayList<Integer> singleton = new ArrayList<Integer>();
            singleton.add(s);
            result.add(singleton);
            return result;
        }
        for (int i = 0; i <= s; ++i) {
            List<List<Integer>> recursion = EnumerateUnorderedWithReplacement.enumerate(n - 1, s - i);
            for (List<Integer> intermediate : recursion) {
                intermediate.add(i);
            }
            result.addAll(recursion);
        }
        return result;
    }

    public static List<Double> sortedData() {
        ArrayList<Double> result = new ArrayList<Double>();
        result.add(1.2);
        result.add(3.5);
        result.add(4.7);
        result.add(7.3);
        result.add(8.6);
        result.add(12.4);
        result.add(13.8);
        result.add(18.1);
        return result;
    }

    public static List<Double> smallSortedData() {
        ArrayList<Double> result = new ArrayList<Double>();
        result.add(1.2);
        result.add(3.5);
        result.add(4.7);
        return result;
    }

    public static void main(String[] args) {
        EnumerateUnorderedWithReplacement.testEnumerate();
        System.out.println("Test of OrderedWithoutReplacementSampler:");
        EnumerateUnorderedWithReplacement.testSampler(new OrderedWithoutReplacementSampler(2, 5), new LexicographicComparator(), 10000);
        System.out.println("Test of OrderedWithReplacementSampler:");
        EnumerateUnorderedWithReplacement.testSampler(new OrderedWithReplacementSampler(3, 3), new LexicographicComparator(), 10000);
        System.out.println("Test of smaller data set for Bootstrap:");
        EnumerateUnorderedWithReplacement.testSampler(new BootstrapSampler<Double>(EnumerateUnorderedWithReplacement.smallSortedData()), new LexicographicComparator(), 10000);
        System.out.println("Trimmed mean of the original data: " + EnumerateUnorderedWithReplacement.trimmedMean(EnumerateUnorderedWithReplacement.sortedData(), trimCnst));
        for (int i = 0; i < 10; ++i) {
            System.out.println("Using fresh random numbers..");
            EnumerateUnorderedWithReplacement.testSampledStandardError();
        }
        EnumerateUnorderedWithReplacement.testExactStandardError();
    }

    public static void testSampledStandardError() {
        int[] iterations = new int[]{25, 100, 200, 500, 1000, 2000};
        BootstrapSampler<Double> sampler = new BootstrapSampler<Double>(EnumerateUnorderedWithReplacement.sortedData());
        Fct<List<Double>, Double> integrand = EnumerateUnorderedWithReplacement.constructIntegrand();
        MCIntegrator<Double> integrator = new MCIntegrator<Double>(sampler);
        for (int curIt : iterations) {
            integrator.setIterations(curIt);
            System.out.println("MC estimation of the bootstrap of the std error with " + curIt + " iterations: " + Math.sqrt(integrator.integrate(integrand)));
        }
    }

    public static class OrderedWithoutReplacementSampler
    implements Sampler<List<Integer>> {
        private int n;
        private int s;

        public OrderedWithoutReplacementSampler(int n, int s) {
            this.s = s;
            this.n = n;
        }

        @Override
        public double previousSampleWeigth() {
            return 1.0;
        }

        @Override
        public List<Integer> sample() {
            return Sampling.sampleWithoutReplacement(rand, this.s, this.n);
        }
    }

    public static class OrderedWithReplacementSampler
    implements Sampler<List<Integer>> {
        private int n;
        private int s;

        public OrderedWithReplacementSampler(int n, int s) {
            this.s = s;
            this.n = n;
        }

        @Override
        public List<Integer> sample() {
            OrderedWithoutReplacementSampler sampler = new OrderedWithoutReplacementSampler(this.n, this.n + this.s - 1);
            Object trick = sampler.sample();
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int i = 0; i < this.n; ++i) {
                result.add((Integer)trick.get(i) - i);
            }
            return result;
        }

        @Override
        public double previousSampleWeigth() {
            return 1.0;
        }
    }

    public static class LexicographicComparator<T extends Comparable<T>>
    implements Comparator<List<T>> {
        @Override
        public int compare(List<T> arg0, List<T> arg1) {
            if (arg0 == null || arg1 == null) {
                throw new RuntimeException("Elements compared in LexicographicComparatorshould not be null");
            }
            if (arg0.size() > arg1.size()) {
                return 1;
            }
            if (arg0.size() < arg1.size()) {
                return -1;
            }
            for (int i = 0; i < arg0.size(); ++i) {
                Comparable o1;
                Comparable o0 = (Comparable)arg0.get(i);
                int comp = o0.compareTo(o1 = (Comparable)arg1.get(i));
                if (comp == -1) {
                    return -1;
                }
                if (comp != 1) continue;
                return 1;
            }
            return 0;
        }
    }

    public static class TrimmedMean
    implements Fct<List<Double>, Double> {
        private double skipRatio;

        public TrimmedMean(double skipRatio) {
            this.skipRatio = skipRatio;
        }

        @Override
        public Double evalAt(List<Double> data) {
            Collections.sort(data);
            double l = data.size();
            List<Double> goodData = data.subList((int)Math.ceil(l * this.skipRatio), (int)(l - Math.floor(l * this.skipRatio)));
            return EnumerateUnorderedWithReplacement.sum(goodData) / (double)goodData.size();
        }
    }

    public static class BootstrapSampler<T>
    implements Sampler<List<T>> {
        private List<T> initialData;
        private List<Integer> previousIndices;

        public BootstrapSampler(List<T> initialData) {
            this.initialData = initialData;
        }

        @Override
        public List<T> sample() {
            int size = this.initialData.size();
            OrderedWithReplacementSampler sampler = new OrderedWithReplacementSampler(size, size);
            Object bootstrapIndices = sampler.sample();
            this.previousIndices = EnumerateUnorderedWithReplacement.indices2ModIndices((List<Integer>)bootstrapIndices);
            return EnumerateUnorderedWithReplacement.indices2Sample((List<Integer>)bootstrapIndices, this.initialData);
        }

        @Override
        public double previousSampleWeigth() {
            return EnumerateUnorderedWithReplacement.multinomial(this.previousIndices.size(), this.previousIndices);
        }
    }

    public static class ExactBootstrapSampler<T>
    implements Sampler<List<T>> {
        private Iterator<List<Integer>> completeSpace;
        private List<T> initialData;
        private List<Integer> previousIndices;

        public ExactBootstrapSampler(List<T> initialData) {
            this.completeSpace = EnumerateUnorderedWithReplacement.enumerate(initialData.size(), initialData.size()).iterator();
            this.initialData = initialData;
        }

        @Override
        public List<T> sample() {
            if (!this.completeSpace.hasNext()) {
                throw new RuntimeException("Space already covered!");
            }
            ArrayList<T> result = new ArrayList<T>();
            List<Integer> modifiedIndices = this.completeSpace.next();
            this.previousIndices = modifiedIndices;
            for (int i = 0; i < modifiedIndices.size(); ++i) {
                for (int j = 0; j < modifiedIndices.get(i); ++j) {
                    result.add(this.initialData.get(i));
                }
            }
            return result;
        }

        @Override
        public double previousSampleWeigth() {
            return EnumerateUnorderedWithReplacement.multinomial(this.previousIndices.size(), this.previousIndices);
        }
    }

    public static interface Sampler<T> {
        public T sample();

        public double previousSampleWeigth();
    }

    public static class DefaultComparator<T extends Comparable<T>>
    implements Comparator<T> {
        @Override
        public int compare(T arg0, T arg1) {
            return arg0.compareTo(arg1);
        }
    }

    public static class MCIntegrator<D> {
        private Sampler<D> sampler;
        private int iterations = 100;

        int getIterations() {
            return this.iterations;
        }

        void setIterations(int iterations) {
            this.iterations = iterations;
        }

        public MCIntegrator(Sampler<D> sampler) {
            this.sampler = sampler;
        }

        public double integrate(Fct<D, Double> f) {
            double sum = 0.0;
            double denominator = 0.0;
            for (int i = 0; i < this.iterations; ++i) {
                double curEval = f.evalAt(this.sampler.sample());
                double weight = this.sampler.previousSampleWeigth();
                sum += curEval * weight;
                denominator += weight;
            }
            return sum / denominator;
        }
    }

    public static class StdError
    implements Fct<Double, Double> {
        private double mean;

        public StdError(double mean) {
            this.mean = mean;
        }

        @Override
        public Double evalAt(Double x) {
            double y = x - this.mean;
            return y * y;
        }
    }

    public static class ComposedFct<D, A, I>
    implements Fct<D, I> {
        private Fct<A, I> f;
        private Fct<D, A> g;

        public ComposedFct(Fct<A, I> f, Fct<D, A> g) {
            this.f = f;
            this.g = g;
        }

        @Override
        public I evalAt(D x) {
            return this.f.evalAt(this.g.evalAt(x));
        }
    }

    public static interface Fct<D, I> {
        public I evalAt(D var1);
    }
}

