/*
 * Decompiled with CFR 0.152.
 */
package smc;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import java.util.Random;
import nuts.io.IO;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import smc.EntangledParticle;
import smc.EntangledRandom;

public class TestEntangledParticle
implements Runnable {
    @Option(required=true)
    public int T;
    @Option(required=true)
    public int N;
    @Option(required=true)
    public int numMachines;
    @Option(required=true)
    public int machineId;
    @Option(required=true)
    public Random rand1 = new Random(1L);
    @Option(required=true)
    public Random rand2 = new Random(1L);

    @Override
    public void run() {
        LogInfo.logs("machine=" + this.machineId + " starting");
        int[][] config = new int[2][this.numMachines];
        int numParticlesPerMachine = this.N / this.numMachines;
        for (int k = 0; k < this.numMachines; ++k) {
            config[0][k] = numParticlesPerMachine;
            config[1][k] = numParticlesPerMachine * 2;
        }
        CoinFlipKernel coinFlipKernel = new CoinFlipKernel();
        CoinFlipProcessor coinProcessor = new CoinFlipProcessor();
        EntangledRandom eRandom = new EntangledRandom(this.machineId, this.N, this.T, this.rand1, this.rand2);
        EntangledParticle<CoinState> entangled = EntangledParticle.run(coinFlipKernel, coinProcessor, eRandom, this.machineId, config, this.N, EntangledParticle.ParticleAllocationStyle.RANDOM, null);
        double posterior = (double)coinProcessor.getNumHeads() / (double)config[0][this.machineId];
        LogInfo.logs("Estimation of posterior=" + posterior);
    }

    public static void main(String[] args) {
        IO.run(args, new TestEntangledParticle());
    }

    public static class CoinState {
        boolean headUp;

        public CoinState(boolean headUp) {
            this.headUp = headUp;
        }
    }

    public static class CoinFlipKernel
    implements ParticleKernel<CoinState> {
        @Override
        public Pair<CoinState, Double> next(Random rand, CoinState current) {
            double flip = rand.nextDouble();
            current.headUp = flip < 0.5;
            double weight = 0.5;
            weight = Math.log(weight);
            return new Pair<CoinState, Double>(current, new Double(weight));
        }

        @Override
        public int nIterationsLeft(CoinState partialState) {
            return 1;
        }

        @Override
        public CoinState getInitial() {
            return new CoinState(true);
        }
    }

    public static class CoinFlipProcessor
    implements ParticleFilter.ParticleProcessor<CoinState> {
        private int numHeads = 0;

        @Override
        public void process(CoinState state, double weight) {
            if (state.headUp) {
                ++this.numHeads;
            }
        }

        public int getNumHeads() {
            return this.numHeads;
        }
    }
}

