/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import spoon.SpoonException;
import spoon.compiler.Environment;
import spoon.reflect.factory.Factory;
import spoon.support.compiler.SnippetCompilationError;
import spoon.support.compiler.VirtualFile;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.compiler.jdt.JDTBatchCompiler;
import spoon.support.compiler.jdt.JDTTreeBuilder;

public class JDTSnippetCompiler
extends JDTBasedSpoonCompiler {
    public JDTSnippetCompiler(Factory factory, String contents) {
        super(factory);
        this.addInputSource(new VirtualFile(contents, ""));
    }

    @Override
    public boolean build() {
        if (this.factory == null) {
            throw new SpoonException("Factory not initialized");
        }
        this.factory.getEnvironment().debugMessage("compiling sources: " + this.sources.getAllJavaFiles());
        long t = System.currentTimeMillis();
        this.javaCompliance = this.factory.getEnvironment().getComplianceLevel();
        boolean srcSuccess = this.buildSources();
        this.reportProblems(this.factory.getEnvironment());
        this.factory.getEnvironment().debugMessage("compiled in " + (System.currentTimeMillis() - t) + " ms");
        t = System.currentTimeMillis();
        return srcSuccess;
    }

    @Override
    protected boolean buildSources() {
        if (this.sources.getAllJavaFiles().isEmpty()) {
            return true;
        }
        JDTBatchCompiler batchCompiler = this.createBatchCompiler();
        ArrayList<String> args = new ArrayList<String>();
        args.add("-1." + this.javaCompliance);
        if (this.encoding != null) {
            args.add("-encoding");
            args.add(this.encoding);
        }
        args.add("-preserveAllLocals");
        args.add("-enableJavadoc");
        args.add("-noExit");
        if (this.getSourceClasspath() != null) {
            args.add("-cp");
            args.add(this.computeJdtClassPath());
        } else {
            URL[] urls;
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            if (currentClassLoader instanceof URLClassLoader && (urls = ((URLClassLoader)currentClassLoader).getURLs()) != null && urls.length > 0) {
                String classpath = ".";
                for (URL url : urls) {
                    classpath = classpath + File.pathSeparator + url.getFile();
                }
                if (classpath != null) {
                    args.add("-cp");
                    args.add(classpath);
                }
            }
        }
        File f = this.createTmpJavaFile(new File("."));
        args.add(f.getPath());
        this.getFactory().getEnvironment().debugMessage("build args: " + args);
        batchCompiler.configure(args.toArray(new String[0]));
        CompilationUnitDeclaration[] units = batchCompiler.getUnits(this.sources.getAllJavaFiles());
        if (f != null && f.exists()) {
            f.delete();
        }
        JDTTreeBuilder builder = new JDTTreeBuilder(this.factory);
        for (CompilationUnitDeclaration unit : units) {
            unit.traverse((ASTVisitor)builder, unit.scope);
        }
        return this.getProblems().size() == 0;
    }

    @Override
    protected void report(Environment environment, CategorizedProblem problem) {
        throw new SnippetCompilationError(problem.getMessage() + "at line " + problem.getSourceLineNumber());
    }
}

