/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments;

import JSci.instruments.Image;
import JSci.instruments.ImageFilter;
import JSci.instruments.ImageSink;
import JSci.instruments.ImageSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public abstract class ImageFilterAdapter
implements ImageFilter {
    private ImageSink sink;
    private ImageSource source = null;

    public void setSink(ImageSink imageSink) {
        if (this.sink != imageSink) {
            this.sink = imageSink;
            this.sink.setSource(this);
        }
    }

    public void setSource(ImageSource imageSource) {
        if (this.source != imageSource) {
            this.source = imageSource;
            this.source.setSink(this);
        }
    }

    public void receive(Image image) {
        this.filter(image);
        if (this.sink != null) {
            this.sink.receive(image);
        }
    }

    public Component getControlComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        if (this.source.getControlComponent() != null) {
            jPanel.add(this.source.getControlComponent());
        }
        if (this.getFilterControlComponent() != null) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add(this.getFilterControlComponent());
            Border border = BorderFactory.createEtchedBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.getName());
            jPanel2.setBorder(titledBorder);
            jPanel.add(jPanel2);
        }
        return jPanel;
    }

    public int getWidth() {
        return this.source.getWidth();
    }

    public int getHeight() {
        return this.source.getHeight();
    }

    public Dimension getSize() {
        return this.source.getSize();
    }

    public Component getFilterControlComponent() {
        return null;
    }

    public abstract void filter(Image var1);

    public String getName() {
        return "Filter";
    }
}

