/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.DimensionException;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.ComplexVector;

public class ComplexMatrix
extends AbstractComplexMatrix {
    protected double[][] matrixRe;
    protected double[][] matrixIm;

    public ComplexMatrix(int n, int n2) {
        super(n, n2);
        this.matrixRe = new double[n][n2];
        this.matrixIm = new double[n][n2];
    }

    public ComplexMatrix(double[][] dArray, double[][] dArray2) {
        this(dArray.length, dArray[0].length);
        this.matrixRe = dArray;
        this.matrixIm = dArray2;
    }

    public ComplexMatrix(Complex[][] complexArray) {
        this(complexArray.length, complexArray[0].length);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.matrixRe[i][j] = complexArray[i][j].real();
                this.matrixIm[i][j] = complexArray[i][j].imag();
            }
        }
    }

    public ComplexMatrix(ComplexVector[] complexVectorArray) {
        this(complexVectorArray[0].dimension(), complexVectorArray.length);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.matrixRe[i][j] = complexVectorArray[j].getComponent(i).real();
                this.matrixIm[i][j] = complexVectorArray[j].getComponent(i).imag();
            }
        }
    }

    public boolean equals(AbstractComplexMatrix abstractComplexMatrix, double d) {
        if (abstractComplexMatrix != null && this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            double d2 = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double d3 = this.matrixRe[i][j] - abstractComplexMatrix.getRealElement(i, j);
                    double d4 = this.matrixIm[i][j] - abstractComplexMatrix.getImagElement(i, j);
                    d2 += d3 * d3 + d4 * d4;
                }
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(Complex.toString(this.matrixRe[i][j], this.matrixIm[i][j]));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public AbstractDoubleMatrix real() {
        return new DoubleMatrix(this.matrixRe);
    }

    public AbstractDoubleMatrix imag() {
        return new DoubleMatrix(this.matrixIm);
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return new Complex(this.matrixRe[n][n2], this.matrixIm[n][n2]);
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getRealElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrixRe[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getImagElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrixIm[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrixRe[n][n2] = complex.real();
        this.matrixIm[n][n2] = complex.imag();
    }

    public void setElement(int n, int n2, double d, double d2) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrixRe[n][n2] = d;
        this.matrixIm[n][n2] = d2;
    }

    public double infNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                d2 += Math.sqrt(this.matrixRe[i][j] * this.matrixRe[i][j] + this.matrixIm[i][j] * this.matrixIm[i][j]);
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                d += this.matrixRe[i][j] * this.matrixRe[i][j] + this.matrixIm[i][j] * this.matrixIm[i][j];
            }
        }
        return Math.sqrt(d);
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = -this.matrixRe[i][0];
            dArray2[i][0] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = -this.matrixRe[i][j];
                dArray2[i][j] = -this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix add(AbstractComplexMatrix abstractComplexMatrix) {
        if (abstractComplexMatrix instanceof ComplexMatrix) {
            return this.add((ComplexMatrix)abstractComplexMatrix);
        }
        if (this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.matrixRe[i][0] + abstractComplexMatrix.getElement(i, 0).real();
                dArray2[i][0] = this.matrixIm[i][0] + abstractComplexMatrix.getElement(i, 0).imag();
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.matrixRe[i][j] + abstractComplexMatrix.getElement(i, j).real();
                    dArray2[i][j] = this.matrixIm[i][j] + abstractComplexMatrix.getElement(i, j).imag();
                }
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        if (this.numRows == complexMatrix.numRows && this.numCols == complexMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.matrixRe[i][0] + complexMatrix.matrixRe[i][0];
                dArray2[i][0] = this.matrixIm[i][0] + complexMatrix.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.matrixRe[i][j] + complexMatrix.matrixRe[i][j];
                    dArray2[i][j] = this.matrixIm[i][j] + complexMatrix.matrixIm[i][j];
                }
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexMatrix subtract(AbstractComplexMatrix abstractComplexMatrix) {
        if (abstractComplexMatrix instanceof ComplexMatrix) {
            return this.subtract((ComplexMatrix)abstractComplexMatrix);
        }
        if (this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.matrixRe[i][0] - abstractComplexMatrix.getElement(i, 0).real();
                dArray2[i][0] = this.matrixIm[i][0] - abstractComplexMatrix.getElement(i, 0).imag();
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.matrixRe[i][j] - abstractComplexMatrix.getElement(i, j).real();
                    dArray2[i][j] = this.matrixIm[i][j] - abstractComplexMatrix.getElement(i, j).imag();
                }
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        if (this.numRows == complexMatrix.numRows && this.numCols == complexMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.matrixRe[i][0] - complexMatrix.matrixRe[i][0];
                dArray2[i][0] = this.matrixIm[i][0] - complexMatrix.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.matrixRe[i][j] - complexMatrix.matrixRe[i][j];
                    dArray2[i][j] = this.matrixIm[i][j] - complexMatrix.matrixIm[i][j];
                }
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = d * this.matrixRe[i][0] - d2 * this.matrixIm[i][0];
            dArray2[i][0] = d2 * this.matrixRe[i][0] + d * this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = d * this.matrixRe[i][j] - d2 * this.matrixIm[i][j];
                dArray2[i][j] = d2 * this.matrixRe[i][j] + d * this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = d * this.matrixRe[i][0];
            dArray2[i][0] = d * this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = d * this.matrixRe[i][j];
                dArray2[i][j] = d * this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix scalarDivide(Complex complex) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            complexArray[i][0] = new Complex(this.matrixRe[i][0], this.matrixIm[i][0]).divide(complex);
            for (int j = 1; j < this.numCols; ++j) {
                complexArray[i][j] = new Complex(this.matrixRe[i][j], this.matrixIm[i][j]).divide(complex);
            }
        }
        return new ComplexMatrix(complexArray);
    }

    public AbstractComplexMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = this.matrixRe[i][0] / d;
            dArray2[i][0] = this.matrixIm[i][0] / d;
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = this.matrixRe[i][j] / d;
                dArray2[i][j] = this.matrixIm[i][j] / d;
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexVector multiply(AbstractComplexVector abstractComplexVector) {
        if (this.numCols == abstractComplexVector.dimension()) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                Complex complex = abstractComplexVector.getComponent(0);
                dArray[i] = this.matrixRe[i][0] * complex.real() - this.matrixIm[i][0] * complex.imag();
                dArray2[i] = this.matrixIm[i][0] * complex.real() + this.matrixRe[i][0] * complex.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    complex = abstractComplexVector.getComponent(j);
                    int n = i;
                    dArray[n] = dArray[n] + (this.matrixRe[i][j] * complex.real() - this.matrixIm[i][j] * complex.imag());
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + (this.matrixIm[i][j] * complex.real() + this.matrixRe[i][j] * complex.imag());
                }
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractComplexMatrix multiply(AbstractComplexMatrix abstractComplexMatrix) {
        if (abstractComplexMatrix instanceof ComplexMatrix) {
            return this.multiply((ComplexMatrix)abstractComplexMatrix);
        }
        if (this.numCols == abstractComplexMatrix.rows()) {
            double[][] dArray = new double[this.numRows][abstractComplexMatrix.columns()];
            double[][] dArray2 = new double[this.numRows][abstractComplexMatrix.columns()];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < abstractComplexMatrix.columns(); ++j) {
                    Complex complex = abstractComplexMatrix.getElement(0, j);
                    dArray[i][j] = this.matrixRe[i][0] * complex.real() - this.matrixIm[i][0] * complex.imag();
                    dArray2[i][j] = this.matrixIm[i][0] * complex.real() + this.matrixRe[i][0] * complex.imag();
                    for (int k = 1; k < this.numCols; ++k) {
                        complex = abstractComplexMatrix.getElement(k, j);
                        double[] dArray3 = dArray[i];
                        int n = j;
                        dArray3[n] = dArray3[n] + (this.matrixRe[i][k] * complex.real() - this.matrixIm[i][k] * complex.imag());
                        double[] dArray4 = dArray2[i];
                        int n2 = j;
                        dArray4[n2] = dArray4[n2] + (this.matrixIm[i][k] * complex.real() + this.matrixRe[i][k] * complex.imag());
                    }
                }
            }
            if (this.numRows == abstractComplexMatrix.columns()) {
                return new ComplexSquareMatrix(dArray, dArray2);
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexMatrix multiply(ComplexMatrix complexMatrix) {
        if (this.numCols == complexMatrix.numRows) {
            double[][] dArray = new double[this.numRows][complexMatrix.numCols];
            double[][] dArray2 = new double[this.numRows][complexMatrix.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < complexMatrix.numCols; ++j) {
                    dArray[i][j] = this.matrixRe[i][0] * complexMatrix.matrixRe[0][j] - this.matrixIm[i][0] * complexMatrix.matrixIm[0][j];
                    dArray2[i][j] = this.matrixIm[i][0] * complexMatrix.matrixRe[0][j] + this.matrixRe[i][0] * complexMatrix.matrixIm[0][j];
                    for (int k = 1; k < this.numCols; ++k) {
                        double[] dArray3 = dArray[i];
                        int n = j;
                        dArray3[n] = dArray3[n] + (this.matrixRe[i][k] * complexMatrix.matrixRe[k][j] - this.matrixIm[i][k] * complexMatrix.matrixIm[k][j]);
                        double[] dArray4 = dArray2[i];
                        int n2 = j;
                        dArray4[n2] = dArray4[n2] + (this.matrixIm[i][k] * complexMatrix.matrixRe[k][j] + this.matrixRe[i][k] * complexMatrix.matrixIm[k][j]);
                    }
                }
            }
            if (this.numRows == complexMatrix.numCols) {
                return new ComplexSquareMatrix(dArray, dArray2);
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexMatrix directSum(AbstractComplexMatrix abstractComplexMatrix) {
        int n;
        int n2;
        double[][] dArray = new double[this.numRows + abstractComplexMatrix.numRows][this.numCols + abstractComplexMatrix.numCols];
        double[][] dArray2 = new double[this.numRows + abstractComplexMatrix.numRows][this.numCols + abstractComplexMatrix.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                dArray[n2][n] = this.matrixRe[n2][n];
                dArray2[n2][n] = this.matrixIm[n2][n];
            }
        }
        for (n2 = 0; n2 < abstractComplexMatrix.numRows; ++n2) {
            for (n = 0; n < abstractComplexMatrix.numCols; ++n) {
                Complex complex = abstractComplexMatrix.getElement(n2, n);
                dArray[n2 + this.numRows][n + this.numCols] = complex.real();
                dArray2[n2 + this.numRows][n + this.numCols] = complex.imag();
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix tensor(AbstractComplexMatrix abstractComplexMatrix) {
        double[][] dArray = new double[this.numRows * abstractComplexMatrix.numRows][this.numCols * abstractComplexMatrix.numCols];
        double[][] dArray2 = new double[this.numRows * abstractComplexMatrix.numRows][this.numCols * abstractComplexMatrix.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n = 0;
                while (n < abstractComplexMatrix.numRows) {
                    for (int k = 0; k < abstractComplexMatrix.numCols; ++k) {
                        Complex complex = abstractComplexMatrix.getElement(n, k);
                        dArray[i * abstractComplexMatrix.numRows + n][j * abstractComplexMatrix.numCols + k] = this.matrixRe[i][j] * complex.real() - this.matrixIm[i][j] * complex.imag();
                        dArray2[i * abstractComplexMatrix.numRows + n][j * abstractComplexMatrix.numCols + k] = this.matrixIm[i][j] * complex.real() + this.matrixRe[i][j] * complex.imag();
                    }
                    ++j;
                }
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix hermitianAdjoint() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[0][i] = this.matrixRe[i][0];
            dArray2[0][i] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[j][i] = this.matrixRe[i][j];
                dArray2[j][i] = -this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix conjugate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = -this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(this.matrixRe, dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[0][i] = this.matrixRe[i][0];
            dArray2[0][i] = this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[j][i] = this.matrixRe[i][j];
                dArray2[j][i] = this.matrixIm[i][j];
            }
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            complexArray[i][0] = complexMapping.map(this.matrixRe[i][0], this.matrixIm[i][0]);
            for (int j = 1; j < this.numCols; ++j) {
                complexArray[i][j] = complexMapping.map(this.matrixRe[i][j], this.matrixIm[i][j]);
            }
        }
        return new ComplexMatrix(complexArray);
    }
}

