/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.DimensionException;
import JSci.maths.ExtraMath;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.matrices.AbstractIntegerSquareMatrix;
import JSci.maths.matrices.ComplexDiagonalMatrix;
import JSci.maths.matrices.DiagonalMatrix;
import JSci.maths.matrices.DoubleDiagonalMatrix;
import JSci.maths.matrices.DoubleLUCache;
import JSci.maths.matrices.IntegerSquareMatrix;
import JSci.maths.matrices.IntegerTridiagonalMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.matrices.TridiagonalMatrix;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.maths.vectors.IntegerVector;

public class IntegerDiagonalMatrix
extends AbstractIntegerSquareMatrix
implements DiagonalMatrix {
    protected final int[] diag;

    public IntegerDiagonalMatrix(int n) {
        this(new int[n]);
    }

    public IntegerDiagonalMatrix(int[][] nArray) {
        this(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i].length != nArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            this.diag[i] = nArray[i][i];
        }
    }

    public IntegerDiagonalMatrix(int[] nArray) {
        super(nArray.length);
        this.diag = nArray;
    }

    public static IntegerDiagonalMatrix identity(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 1;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public boolean equals(AbstractIntegerMatrix abstractIntegerMatrix, double d) {
        if (abstractIntegerMatrix instanceof DiagonalMatrix) {
            if (this.numRows != abstractIntegerMatrix.rows() || this.numCols != abstractIntegerMatrix.columns()) {
                return false;
            }
            int n = 0;
            int n2 = this.diag[0] - abstractIntegerMatrix.getElement(0, 0);
            n += n2 * n2;
            for (int i = 1; i < this.numRows; ++i) {
                n2 = this.diag[i] - abstractIntegerMatrix.getElement(i, i);
                n += n2 * n2;
            }
            return (double)n <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.getElement(i, j));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public AbstractDoubleMatrix toDoubleMatrix() {
        double[] dArray = new double[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i] = this.diag[i];
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        double[] dArray = new double[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i] = this.diag[i];
        }
        return new ComplexDiagonalMatrix(dArray, new double[this.numRows]);
    }

    public int getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n == n2) {
                return this.diag[n];
            }
            return 0;
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, int n3) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n != n2) {
                throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
            }
        } else {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.diag[n] = n3;
    }

    public boolean isSymmetric() {
        return true;
    }

    public int det() {
        int n = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            n *= this.diag[i];
        }
        return n;
    }

    public int trace() {
        int n = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            n += this.diag[i];
        }
        return n;
    }

    public int infNorm() {
        int n = Math.abs(this.diag[0]);
        for (int i = 1; i < this.numRows; ++i) {
            int n2 = Math.abs(this.diag[i]);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public double frobeniusNorm() {
        double d = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            d = ExtraMath.hypot(d, this.diag[i]);
        }
        return d;
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return this.infNorm();
    }

    public AbstractIntegerSquareMatrix add(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerDiagonalMatrix) {
            return this.add((IntegerDiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof DiagonalMatrix) {
            return this.addDiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.add((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof TridiagonalMatrix) {
            return this.addTridiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.add((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numRows == abstractIntegerSquareMatrix.rows() && this.numCols == abstractIntegerSquareMatrix.columns()) {
            int n;
            int[][] nArray = new int[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                nArray[n][0] = abstractIntegerSquareMatrix.getElement(n, 0);
                for (int i = 1; i < this.numCols; ++i) {
                    nArray[n][i] = abstractIntegerSquareMatrix.getElement(n, i);
                }
            }
            for (n = 0; n < this.numRows; ++n) {
                int[] nArray2 = nArray[n];
                int n2 = n;
                nArray2[n2] = nArray2[n2] + this.diag[n];
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numRows == integerSquareMatrix.numRows && this.numCols == integerSquareMatrix.numCols) {
            int n;
            int[][] nArray = new int[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                System.arraycopy(integerSquareMatrix.matrix[n], 0, nArray[n], 0, this.numRows);
            }
            for (n = 0; n < this.numRows; ++n) {
                int[] nArray2 = nArray[n];
                int n2 = n;
                nArray2[n2] = nArray2[n2] + this.diag[n];
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix add(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        if (this.numRows == integerTridiagonalMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(this.numRows);
            System.arraycopy(integerTridiagonalMatrix.ldiag, 0, integerTridiagonalMatrix2.ldiag, 0, integerTridiagonalMatrix.ldiag.length);
            System.arraycopy(integerTridiagonalMatrix.udiag, 0, integerTridiagonalMatrix2.udiag, 0, integerTridiagonalMatrix.udiag.length);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] + integerTridiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                integerTridiagonalMatrix2.diag[i] = this.diag[i] + integerTridiagonalMatrix.diag[i];
            }
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix addTridiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        int n = this.numRows;
        if (n == abstractIntegerSquareMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] + abstractIntegerSquareMatrix.getElement(0, 0);
            integerTridiagonalMatrix.udiag[0] = abstractIntegerSquareMatrix.getElement(0, 1);
            --n;
            for (int i = 1; i < n; ++i) {
                integerTridiagonalMatrix.ldiag[i] = abstractIntegerSquareMatrix.getElement(i, i - 1);
                integerTridiagonalMatrix.diag[i] = this.diag[i] + abstractIntegerSquareMatrix.getElement(i, i);
                integerTridiagonalMatrix.udiag[i] = abstractIntegerSquareMatrix.getElement(i, i + 1);
            }
            integerTridiagonalMatrix.ldiag[n] = abstractIntegerSquareMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix.diag[n] = this.diag[n] + abstractIntegerSquareMatrix.getElement(n, n);
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix add(IntegerDiagonalMatrix integerDiagonalMatrix) {
        if (this.numRows == integerDiagonalMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] + integerDiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                nArray[i] = this.diag[i] + integerDiagonalMatrix.diag[i];
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerDiagonalMatrix addDiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (this.numRows == abstractIntegerSquareMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] + abstractIntegerSquareMatrix.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                nArray[i] = this.diag[i] + abstractIntegerSquareMatrix.getElement(i, i);
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerSquareMatrix subtract(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerDiagonalMatrix) {
            return this.subtract((IntegerDiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof DiagonalMatrix) {
            return this.subtractDiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.subtract((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.subtract((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numRows == abstractIntegerSquareMatrix.rows() && this.numCols == abstractIntegerSquareMatrix.columns()) {
            int n;
            int[][] nArray = new int[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                nArray[n][0] = -abstractIntegerSquareMatrix.getElement(n, 0);
                for (int i = 1; i < this.numCols; ++i) {
                    nArray[n][i] = -abstractIntegerSquareMatrix.getElement(n, i);
                }
            }
            for (n = 0; n < this.numRows; ++n) {
                int[] nArray2 = nArray[n];
                int n2 = n;
                nArray2[n2] = nArray2[n2] + this.diag[n];
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numRows == integerSquareMatrix.numRows && this.numCols == integerSquareMatrix.numCols) {
            int n;
            int[][] nArray = new int[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                nArray[n][0] = -integerSquareMatrix.matrix[n][0];
                for (int i = 1; i < this.numCols; ++i) {
                    nArray[n][i] = -integerSquareMatrix.matrix[n][i];
                }
            }
            for (n = 0; n < this.numRows; ++n) {
                int[] nArray2 = nArray[n];
                int n2 = n;
                nArray2[n2] = nArray2[n2] + this.diag[n];
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix subtract(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        int n = this.numRows;
        if (n == integerTridiagonalMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] - integerTridiagonalMatrix.diag[0];
            integerTridiagonalMatrix2.udiag[0] = -integerTridiagonalMatrix.udiag[0];
            --n;
            for (int i = 1; i < n; ++i) {
                integerTridiagonalMatrix2.ldiag[i] = -integerTridiagonalMatrix.ldiag[i];
                integerTridiagonalMatrix2.diag[i] = this.diag[i] - integerTridiagonalMatrix.diag[i];
                integerTridiagonalMatrix2.udiag[i] = -integerTridiagonalMatrix.udiag[i];
            }
            integerTridiagonalMatrix2.ldiag[n] = -integerTridiagonalMatrix.ldiag[n];
            integerTridiagonalMatrix2.diag[n] = this.diag[n] - integerTridiagonalMatrix.diag[n];
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix subtractTridiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        int n = this.numRows;
        if (n == abstractIntegerSquareMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] - abstractIntegerSquareMatrix.getElement(0, 0);
            integerTridiagonalMatrix.udiag[0] = -abstractIntegerSquareMatrix.getElement(0, 1);
            --n;
            for (int i = 1; i < n; ++i) {
                integerTridiagonalMatrix.ldiag[i] = -abstractIntegerSquareMatrix.getElement(i, i - 1);
                integerTridiagonalMatrix.diag[i] = this.diag[i] - abstractIntegerSquareMatrix.getElement(i, i);
                integerTridiagonalMatrix.udiag[i] = -abstractIntegerSquareMatrix.getElement(i, i + 1);
            }
            integerTridiagonalMatrix.ldiag[n] = -abstractIntegerSquareMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix.diag[n] = this.diag[n] - abstractIntegerSquareMatrix.getElement(n, n);
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix subtract(IntegerDiagonalMatrix integerDiagonalMatrix) {
        if (this.numRows == integerDiagonalMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] - integerDiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                nArray[i] = this.diag[i] - integerDiagonalMatrix.diag[i];
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerDiagonalMatrix subtractDiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (this.numRows == abstractIntegerSquareMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] - abstractIntegerSquareMatrix.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                nArray[i] = this.diag[i] - abstractIntegerSquareMatrix.getElement(i, i);
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerMatrix scalarMultiply(int n) {
        int[] nArray = new int[this.numRows];
        nArray[0] = n * this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            nArray[i] = n * this.diag[i];
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public int scalarProduct(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerDiagonalMatrix) {
            return this.scalarProduct((IntegerDiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.scalarProduct((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.scalarProduct((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numRows == abstractIntegerSquareMatrix.rows() && this.numCols == abstractIntegerSquareMatrix.columns()) {
            int n = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                n += this.diag[i] * abstractIntegerSquareMatrix.getElement(i, i);
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numRows == integerSquareMatrix.numRows && this.numCols == integerSquareMatrix.numCols) {
            int n = this.diag[0] * integerSquareMatrix.matrix[0][0];
            for (int i = 1; i < this.numRows; ++i) {
                n += this.diag[i] * integerSquareMatrix.matrix[i][i];
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        if (this.numRows == integerTridiagonalMatrix.numRows) {
            int n = this.diag[0] * integerTridiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                n += this.diag[i] * integerTridiagonalMatrix.diag[i];
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerDiagonalMatrix integerDiagonalMatrix) {
        if (this.numRows == integerDiagonalMatrix.numRows) {
            int n = this.diag[0] * integerDiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                n += this.diag[i] * integerDiagonalMatrix.diag[i];
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerVector multiply(AbstractIntegerVector abstractIntegerVector) {
        if (this.numCols == abstractIntegerVector.dimension()) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] * abstractIntegerVector.getComponent(0);
            for (int i = 1; i < this.numRows; ++i) {
                nArray[i] = this.diag[i] * abstractIntegerVector.getComponent(i);
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractIntegerSquareMatrix multiply(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerDiagonalMatrix) {
            return this.multiply((IntegerDiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof DiagonalMatrix) {
            return this.multiplyDiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.multiply((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.multiply((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numCols == abstractIntegerSquareMatrix.rows()) {
            int n = abstractIntegerSquareMatrix.columns();
            int[][] nArray = new int[this.numRows][n];
            for (int i = 0; i < this.numRows; ++i) {
                nArray[i][0] = this.diag[0] * abstractIntegerSquareMatrix.getElement(i, 0);
                for (int j = 1; j < n; ++j) {
                    nArray[i][j] = this.diag[i] * abstractIntegerSquareMatrix.getElement(i, j);
                }
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numCols == integerSquareMatrix.numRows) {
            int[][] nArray = new int[this.numRows][integerSquareMatrix.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                nArray[i][0] = this.diag[0] * integerSquareMatrix.matrix[i][0];
                for (int j = 1; j < integerSquareMatrix.numCols; ++j) {
                    nArray[i][j] = this.diag[i] * integerSquareMatrix.matrix[i][j];
                }
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerTridiagonalMatrix multiply(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        int n = this.numRows;
        if (this.numCols == integerTridiagonalMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] * integerTridiagonalMatrix.diag[0];
            integerTridiagonalMatrix2.udiag[0] = this.diag[0] * integerTridiagonalMatrix.udiag[0];
            --n;
            for (int i = 1; i < n; ++i) {
                integerTridiagonalMatrix2.ldiag[i] = this.diag[i] * integerTridiagonalMatrix.ldiag[i];
                integerTridiagonalMatrix2.diag[i] = this.diag[i] * integerTridiagonalMatrix.diag[i];
                integerTridiagonalMatrix2.udiag[i] = this.diag[i] * integerTridiagonalMatrix.udiag[i];
            }
            integerTridiagonalMatrix2.ldiag[n] = this.diag[n] * integerTridiagonalMatrix.ldiag[n];
            integerTridiagonalMatrix2.diag[n] = this.diag[n] * integerTridiagonalMatrix.diag[n];
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerTridiagonalMatrix multiplyTridiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        int n = this.numRows;
        if (this.numCols == abstractIntegerSquareMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, 0);
            integerTridiagonalMatrix.udiag[0] = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, 1);
            --n;
            for (int i = 1; i < n; ++i) {
                integerTridiagonalMatrix.ldiag[i] = this.diag[i] * abstractIntegerSquareMatrix.getElement(i, i - 1);
                integerTridiagonalMatrix.diag[i] = this.diag[i] * abstractIntegerSquareMatrix.getElement(i, i);
                integerTridiagonalMatrix.udiag[i] = this.diag[i] * abstractIntegerSquareMatrix.getElement(i, i + 1);
            }
            integerTridiagonalMatrix.ldiag[n] = this.diag[n] * abstractIntegerSquareMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix.diag[n] = this.diag[n] * abstractIntegerSquareMatrix.getElement(n, n);
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerDiagonalMatrix multiply(IntegerDiagonalMatrix integerDiagonalMatrix) {
        if (this.numCols == integerDiagonalMatrix.numRows) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] * integerDiagonalMatrix.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                nArray[i] = this.diag[i] * integerDiagonalMatrix.diag[i];
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerDiagonalMatrix multiplyDiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (this.numCols == abstractIntegerSquareMatrix.rows()) {
            int[] nArray = new int[this.numRows];
            nArray[0] = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                nArray[i] = this.diag[i] * abstractIntegerSquareMatrix.getElement(i, i);
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        return this;
    }

    public AbstractDoubleSquareMatrix inverse() {
        double[] dArray = new double[this.numRows];
        dArray[0] = 1.0 / (double)this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            dArray[i] = 1.0 / (double)this.diag[i];
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public AbstractDoubleSquareMatrix[] luDecompose(int[] nArray) {
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = this.luDecompose_cache(nArray);
        if (abstractDoubleSquareMatrixArray != null) {
            return abstractDoubleSquareMatrixArray;
        }
        if (nArray == null) {
            nArray = new int[this.numRows + 1];
        }
        for (int i = 0; i < this.numRows; ++i) {
            nArray[i] = i;
        }
        nArray[this.numRows] = 1;
        DoubleDiagonalMatrix doubleDiagonalMatrix = DoubleDiagonalMatrix.identity(this.numRows);
        DoubleDiagonalMatrix doubleDiagonalMatrix2 = (DoubleDiagonalMatrix)this.toDoubleMatrix();
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.luCache = new DoubleLUCache(doubleDiagonalMatrix, doubleDiagonalMatrix2, nArray2);
        return new DoubleDiagonalMatrix[]{doubleDiagonalMatrix, doubleDiagonalMatrix2};
    }

    public AbstractDoubleSquareMatrix[] luDecompose() {
        return this.luDecompose(null);
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[2];
        double[] dArray = new double[this.numRows];
        dArray[0] = Math.sqrt(this.diag[0]);
        for (int i = 1; i < this.numRows; ++i) {
            dArray[i] = Math.sqrt(this.diag[i]);
        }
        abstractDoubleSquareMatrixArray[0] = new DoubleDiagonalMatrix(dArray);
        abstractDoubleSquareMatrixArray[1] = abstractDoubleSquareMatrixArray[0];
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] qrDecompose() {
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{DoubleDiagonalMatrix.identity(this.numRows), (AbstractDoubleSquareMatrix)this.toDoubleMatrix()};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int n = this.numRows;
        int n2 = n - 1;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = -1.0;
            dArray2[i] = Math.abs(this.diag[i]);
            dArray3[i] = (double)this.diag[i] < 0.0 ? 1.0 : -1.0;
        }
        dArray[n2] = 1.0;
        dArray2[n2] = Math.abs(this.diag[n2]);
        dArray3[n2] = (double)this.diag[n2] < 0.0 ? -1.0 : 1.0;
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleDiagonalMatrix(dArray), new DoubleDiagonalMatrix(dArray2), new DoubleDiagonalMatrix(dArray3)};
        return abstractDoubleSquareMatrixArray;
    }
}

