/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.cdf2_4;

import JSci.maths.wavelet.FWT;

public class FastCDF2_4
extends FWT {
    static int FilterType = 1;
    static final float[] scale = new float[]{0.03314563f, -0.06629126f, -0.17677669f, 0.41984466f, 0.9943689f, 0.41984466f, -0.17677669f, -0.06629126f, 0.03314563f};
    static final float[] wavelet = new float[]{-0.5f, 1.0f, -0.5f};
    static final float[][] scaleLeft = new float[][]{{1.0275146f, 0.77339804f, -0.22097087f, -0.3314563f, 0.16572815f}, {-0.22189158f, 0.44378316f, 0.90229774f, 0.58004856f, -0.25687864f, -0.06629126f, 0.03314563f}, {0.07549838f, -0.15099676f, -0.09575404f, 0.34250486f, 1.0330389f, 0.41984466f, -0.17677669f, -0.06629126f, 0.03314563f}, {-0.013810679f, 0.027621359f, 0.011048543f, -0.049718447f, -0.18506311f, 0.41984466f, 0.9943689f, 0.41984466f, -0.17677669f, -0.06629126f, 0.03314563f}};
    static final float[][] scaleRight = new float[][]{{0.03314563f, -0.06629126f, -0.17677669f, 0.41984466f, 0.9943689f, 0.41984466f, -0.18506311f, -0.049718447f, 0.011048543f, 0.027621359f, -0.013810679f}, {0.03314563f, -0.06629126f, -0.17677669f, 0.41984466f, 1.0330389f, 0.34250486f, -0.09575404f, -0.15099676f, 0.07549838f}, {0.03314563f, -0.06629126f, -0.25687864f, 0.58004856f, 0.90229774f, 0.44378316f, -0.22189158f}, {0.16572815f, -0.3314563f, -0.22097087f, 0.77339804f, 1.0275146f}};
    static final float[] scalePrimary = new float[]{0.35355338f, 0.70710677f, 0.35355338f};
    static final float[] waveletPrimary = new float[]{0.0234375f, 0.046875f, -0.125f, -0.296875f, 0.703125f, -0.296875f, -0.125f, 0.046875f, 0.0234375f};
    static final float[][] scalePrimaryLeft = new float[][]{{0.70710677f, 0.35355338f}};
    static final float[][] scalePrimaryRight = new float[][]{{0.35355338f, 0.70710677f}};
    static final float[][] waveletPrimaryLeft = new float[][]{{-0.546875f, 0.56966144f, -0.3138021f, -0.103515625f, 0.106770836f, 0.043619793f, -0.01953125f, -0.009765625f}, {0.234375f, -0.087890625f, -0.41015625f, 0.6738281f, -0.2421875f, -0.103515625f, 0.03515625f, 0.017578125f}};
    static final float[][] waveletPrimaryRight = new float[][]{{0.017578125f, 0.03515625f, -0.103515625f, -0.2421875f, 0.6738281f, -0.41015625f, -0.087890625f, 0.234375f}, {-0.009765625f, -0.01953125f, 0.043619793f, 0.106770836f, -0.103515625f, -0.3138021f, 0.56966144f, -0.546875f}};

    public void transform(float[] fArray) {
        int n = fArray.length;
        while (n >= 15) {
            FastCDF2_4.transform(fArray, n);
            n = (n + FilterType) / 2;
        }
    }

    public void invTransform(float[] fArray) {
        int n = fArray.length;
        while (n >= 15) {
            n = n / 2 + FilterType;
        }
        while (2 * n - FilterType <= fArray.length) {
            FastCDF2_4.invTransform(fArray, n);
            n = 2 * n - FilterType;
        }
    }

    public static void transform(float[] fArray, int n) {
        int n2;
        int n3;
        float[] fArray2 = new float[n];
        int n4 = (n + FilterType) / 2;
        if (2 * n4 - FilterType != n) {
            throw new IllegalArgumentException("Illegal subband : " + n + " within array of length " + fArray.length);
        }
        for (n3 = 0; n3 < scaleLeft.length; ++n3) {
            for (n2 = 0; n2 < scaleLeft[n3].length; ++n2) {
                int n5 = n3;
                fArray2[n5] = fArray2[n5] + scaleLeft[n3][n2] * fArray[n2];
            }
        }
        for (n3 = scaleLeft.length; n3 < n4 - scaleRight.length; ++n3) {
            for (n2 = 0; n2 < scale.length; ++n2) {
                int n6 = n3;
                fArray2[n6] = fArray2[n6] + scale[n2] * fArray[2 * n3 + n2 - scaleLeft.length];
            }
        }
        for (n3 = 0; n3 < scaleRight.length; ++n3) {
            for (n2 = 0; n2 < scaleRight[n3].length; ++n2) {
                int n7 = n3 + n4 - scaleRight.length;
                fArray2[n7] = fArray2[n7] + scaleRight[n3][n2] * fArray[fArray.length - scaleRight[n3].length + n2];
            }
        }
        for (n3 = 0; n3 < n4 - FilterType; ++n3) {
            for (n2 = 0; n2 < wavelet.length; ++n2) {
                int n8 = n3 + n4;
                fArray2[n8] = fArray2[n8] + wavelet[n2] * fArray[2 * n3 + n2];
            }
        }
        System.arraycopy(fArray2, 0, fArray, 0, n);
    }

    public static void invTransform(float[] fArray, int n) {
        int n2;
        int n3;
        float[] fArray2 = new float[2 * n - FilterType];
        for (n3 = 0; n3 < scalePrimaryLeft.length; ++n3) {
            for (n2 = 0; n2 < scalePrimaryLeft[n3].length; ++n2) {
                int n4 = n2;
                fArray2[n4] = fArray2[n4] + scalePrimaryLeft[n3][n2] * fArray[n3];
            }
        }
        for (n3 = scalePrimaryLeft.length; n3 < n - scalePrimaryRight.length; ++n3) {
            for (n2 = 0; n2 < scalePrimary.length; ++n2) {
                int n5 = 2 * n3 - FilterType + n2;
                fArray2[n5] = fArray2[n5] + scalePrimary[n2] * fArray[n3];
            }
        }
        for (n3 = 0; n3 < scalePrimaryRight.length; ++n3) {
            for (n2 = 0; n2 < scalePrimaryRight[n3].length; ++n2) {
                int n6 = n2 - scalePrimaryRight[n3].length + fArray2.length;
                fArray2[n6] = fArray2[n6] + scalePrimaryRight[n3][n2] * fArray[n3 + n - scalePrimaryRight.length];
            }
        }
        for (n3 = 0; n3 < waveletPrimaryLeft.length; ++n3) {
            for (n2 = 0; n2 < waveletPrimaryLeft[n3].length; ++n2) {
                int n7 = n2;
                fArray2[n7] = fArray2[n7] + waveletPrimaryLeft[n3][n2] * fArray[n3 + n];
            }
        }
        for (n3 = waveletPrimaryLeft.length; n3 < n - FilterType - waveletPrimaryRight.length; ++n3) {
            for (n2 = 0; n2 < waveletPrimary.length; ++n2) {
                int n8 = 2 * (n3 - FilterType) - 1 + n2;
                fArray2[n8] = fArray2[n8] + waveletPrimary[n2] * fArray[n3 + n];
            }
        }
        for (n3 = 0; n3 < waveletPrimaryRight.length; ++n3) {
            for (n2 = 0; n2 < waveletPrimaryRight[n3].length; ++n2) {
                int n9 = n2 - waveletPrimaryRight[n3].length + fArray2.length;
                fArray2[n9] = fArray2[n9] + waveletPrimaryRight[n3][n2] * fArray[n3 + 2 * n - FilterType - waveletPrimaryRight.length];
            }
        }
        System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
    }
}

