/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nhx;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public final class NHXParser
implements PhylogenyParser {
    public static final PhylogenyMethods.TAXONOMY_EXTRACTION TAXONOMY_EXTRACTION_DEFAULT = PhylogenyMethods.TAXONOMY_EXTRACTION.NO;
    private static final boolean GUESS_ROOTEDNESS_DEFAULT = true;
    private static final boolean GUESS_IF_SUPPORT_VALUES = true;
    private static final boolean IGNORE_QUOTES_DEFAULT = false;
    public static final boolean REPLACE_UNDERSCORES_DEFAULT = false;
    private boolean _saw_closing_paren;
    private static final byte STRING = 0;
    private static final byte STRING_BUFFER = 1;
    private static final byte CHAR_ARRAY = 2;
    private static final byte BUFFERED_READER = 3;
    private boolean _guess_rootedness;
    private boolean _has_next;
    private boolean _ignore_quotes;
    private byte _input_type;
    private int _source_length;
    private PhylogenyNode _current_node;
    private StringBuilder _current_anotation;
    private Object _nhx_source;
    private int _clade_level;
    private List<Phylogeny> _phylogenies;
    private Phylogeny _current_phylogeny;
    private PhylogenyMethods.TAXONOMY_EXTRACTION _taxonomy_extraction;
    private boolean _replace_underscores;
    public static final Pattern UC_LETTERS_NUMBERS_PATTERN = Pattern.compile("^[A-Z0-9]+$");
    public static final Pattern NUMBERS_ONLY_PATTERN = Pattern.compile("^[0-9\\.]+$");
    public static final Pattern MB_PROB_PATTERN = Pattern.compile("prob=([^,]+)");
    public static final Pattern MB_PROB_SD_PATTERN = Pattern.compile("prob_stddev=([^,]+)");
    public static final Pattern MB_BL_PATTERN = Pattern.compile("length_median=([^,]+)");

    public NHXParser() {
        this.init();
    }

    private void decreaseCladeLevel() throws PhylogenyParserException {
        if (this.getCladeLevel() < 0) {
            throw new PhylogenyParserException("error in NH (Newick)/NHX formatted data: most likely cause: number of close parens is larger than number of open parens");
        }
        --this._clade_level;
    }

    private void finishPhylogeny() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        this.setCladeLevel(0);
        if (this.getCurrentPhylogeny() != null) {
            PhylogenyNode phylogenyNode;
            NHXParser.parseNHX(this.getCurrentAnotation().toString(), this.getCurrentPhylogeny().getRoot(), this.getTaxonomyExtraction(), this.isReplaceUnderscores());
            if (NHXParser.isBranchLengthsLikeBootstrapValues(this.getCurrentPhylogeny())) {
                NHXParser.moveBranchLengthsToConfidenceValues(this.getCurrentPhylogeny());
            }
            if (this.isGuessRootedness() && ((phylogenyNode = this.getCurrentPhylogeny().getRoot()).getDistanceToParent() >= 0.0 || !ForesterUtil.isEmpty(phylogenyNode.getName()) || !ForesterUtil.isEmpty(PhylogenyMethods.getSpecies(phylogenyNode)) || phylogenyNode.isHasAssignedEvent())) {
                this.getCurrentPhylogeny().setRooted(true);
            }
            this.getPhylogenies().add(this.getCurrentPhylogeny());
        }
    }

    private void finishSingleNodePhylogeny() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        this.setCladeLevel(0);
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        NHXParser.parseNHX(this.getCurrentAnotation().toString(), phylogenyNode, this.getTaxonomyExtraction(), this.isReplaceUnderscores());
        this.setCurrentPhylogeny(new Phylogeny());
        this.getCurrentPhylogeny().setRoot(phylogenyNode);
        this.getPhylogenies().add(this.getCurrentPhylogeny());
    }

    private int getCladeLevel() {
        return this._clade_level;
    }

    private StringBuilder getCurrentAnotation() {
        return this._current_anotation;
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private Phylogeny getCurrentPhylogeny() {
        return this._current_phylogeny;
    }

    private byte getInputType() {
        return this._input_type;
    }

    private Object getNhxSource() {
        return this._nhx_source;
    }

    private List<Phylogeny> getPhylogenies() {
        return this._phylogenies;
    }

    private Phylogeny[] getPhylogeniesAsArray() {
        Phylogeny[] phylogenyArray = new Phylogeny[this.getPhylogenies().size()];
        for (int i = 0; i < this.getPhylogenies().size(); ++i) {
            phylogenyArray[i] = this.getPhylogenies().get(i);
        }
        return phylogenyArray;
    }

    private int getSourceLength() {
        return this._source_length;
    }

    public PhylogenyMethods.TAXONOMY_EXTRACTION getTaxonomyExtraction() {
        return this._taxonomy_extraction;
    }

    public boolean hasNext() {
        return this._has_next;
    }

    private void increaseCladeLevel() {
        ++this._clade_level;
    }

    private void init() {
        this.setTaxonomyExtraction(TAXONOMY_EXTRACTION_DEFAULT);
        this.setReplaceUnderscores(false);
        this.setGuessRootedness(true);
        this.setIgnoreQuotes(false);
        this.setHasNext(false);
    }

    private boolean isGuessRootedness() {
        return this._guess_rootedness;
    }

    private boolean isIgnoreQuotes() {
        return this._ignore_quotes;
    }

    private boolean isReplaceUnderscores() {
        return this._replace_underscores;
    }

    private boolean isSawClosingParen() {
        return this._saw_closing_paren;
    }

    private void newCurrentAnotation() {
        this.setCurrentAnotation(new StringBuilder());
    }

    @Override
    public Phylogeny[] parse() throws IOException, NHXFormatException {
        this.setHasNext(false);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        this.setPhylogenies(new ArrayList<Phylogeny>());
        this.setCladeLevel(0);
        this.newCurrentAnotation();
        int n = 0;
        while (true) {
            char c = '\b';
            if (this.getInputType() == 3) {
                int n2 = ((BufferedReader)this.getNhxSource()).read();
                if (n2 < 0) break;
                c = (char)n2;
            } else {
                if (n >= this.getSourceLength()) break;
                switch (this.getInputType()) {
                    case 0: {
                        c = ((String)this.getNhxSource()).charAt(n);
                        break;
                    }
                    case 1: {
                        c = ((StringBuffer)this.getNhxSource()).charAt(n);
                        break;
                    }
                    case 2: {
                        c = ((char[])this.getNhxSource())[n];
                    }
                }
            }
            if (!bl6 && !bl5) {
                if (c == ':') {
                    bl2 = true;
                } else if (c >= '!' && c <= '~' && bl2 && c != '[' && c != '.' && (c < '0' || c > '9')) {
                    bl2 = false;
                }
                if (bl4 && c == ']') {
                    bl4 = false;
                }
            }
            if (!(this.isIgnoreQuotes() && (c < '!' || c > '~' || c == '\"' || c == '\'' || this.getCladeLevel() == 0 && c == ';') || !this.isIgnoreQuotes() && (c < ' ' || c > '~' || this.getCladeLevel() == 0 && c == ';') || c == ' ' && !bl6 && !bl5)) {
                if (bl) {
                    if (c == ']') {
                        bl = false;
                    }
                } else if (bl5) {
                    if (c == '\"') {
                        bl5 = false;
                    } else {
                        this.getCurrentAnotation().append(c);
                    }
                } else if (c == '\"') {
                    bl5 = true;
                } else if (bl6) {
                    if (c == '\'') {
                        bl6 = false;
                    } else {
                        this.getCurrentAnotation().append(c);
                    }
                } else if (c == '\'') {
                    bl6 = true;
                } else if (c == '[') {
                    bl3 = true;
                    bl4 = true;
                } else if (bl3) {
                    if (c != ']') {
                        if (c == '&') {
                            this.getCurrentAnotation().append("[&");
                        } else if (bl2) {
                            this.getCurrentAnotation().append("[" + c);
                        } else {
                            bl = true;
                        }
                    }
                    bl3 = false;
                } else if (c == '(' && !bl4) {
                    this.processOpenParen();
                } else if (c == ')' && !bl4) {
                    this.processCloseParen();
                } else if (c == ',' && !bl4) {
                    this.processComma();
                } else {
                    this.getCurrentAnotation().append(c);
                }
            }
            ++n;
        }
        if (this.getCladeLevel() != 0) {
            this.setPhylogenies(null);
            throw new PhylogenyParserException("error in NH (Newick)/NHX formatted data: most likely cause: number of open parens does not equal number of close parens");
        }
        if (this.getCurrentPhylogeny() != null) {
            this.finishPhylogeny();
        } else if (this.getCurrentAnotation().length() > 0) {
            this.finishSingleNodePhylogeny();
        } else if (this.getPhylogenies().size() < 1) {
            this.getPhylogenies().add(new Phylogeny());
        }
        return this.getPhylogeniesAsArray();
    }

    public Phylogeny parseNext() throws IOException, NHXFormatException {
        return null;
    }

    private void processCloseParen() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        this.decreaseCladeLevel();
        if (!this.isSawClosingParen()) {
            PhylogenyNode phylogenyNode = new PhylogenyNode();
            NHXParser.parseNHX(this.getCurrentAnotation().toString(), phylogenyNode, this.getTaxonomyExtraction(), this.isReplaceUnderscores());
            this.newCurrentAnotation();
            this.getCurrentNode().addAsChild(phylogenyNode);
        } else {
            NHXParser.parseNHX(this.getCurrentAnotation().toString(), this.getCurrentNode().getLastChildNode(), this.getTaxonomyExtraction(), this.isReplaceUnderscores());
            this.newCurrentAnotation();
        }
        if (!this.getCurrentNode().isRoot()) {
            this.setCurrentNode(this.getCurrentNode().getParent());
        }
        this.setSawClosingParen(true);
    }

    private void processComma() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        if (!this.isSawClosingParen()) {
            PhylogenyNode phylogenyNode = new PhylogenyNode();
            NHXParser.parseNHX(this.getCurrentAnotation().toString(), phylogenyNode, this.getTaxonomyExtraction(), this.isReplaceUnderscores());
            if (this.getCurrentNode() == null) {
                throw new NHXFormatException("format might not be NH or NHX");
            }
            this.getCurrentNode().addAsChild(phylogenyNode);
        } else {
            NHXParser.parseNHX(this.getCurrentAnotation().toString(), this.getCurrentNode().getLastChildNode(), this.getTaxonomyExtraction(), this.isReplaceUnderscores());
        }
        this.newCurrentAnotation();
        this.setSawClosingParen(false);
    }

    private void processOpenParen() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        if (this.getCladeLevel() == 0) {
            if (this.getCurrentPhylogeny() != null) {
                this.finishPhylogeny();
            }
            this.setCladeLevel(1);
            this.newCurrentAnotation();
            this.setCurrentPhylogeny(new Phylogeny());
            this.getCurrentPhylogeny().setRoot(phylogenyNode);
        } else {
            this.increaseCladeLevel();
            this.getCurrentNode().addAsChild(phylogenyNode);
        }
        this.setCurrentNode(phylogenyNode);
        this.setSawClosingParen(false);
    }

    private void setCladeLevel(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to set clade level to a number smaller than zero.");
        }
        this._clade_level = n;
    }

    private void setCurrentAnotation(StringBuilder stringBuilder) {
        this._current_anotation = stringBuilder;
    }

    private void setCurrentNode(PhylogenyNode phylogenyNode) {
        this._current_node = phylogenyNode;
    }

    private void setCurrentPhylogeny(Phylogeny phylogeny) {
        this._current_phylogeny = phylogeny;
    }

    public void setGuessRootedness(boolean bl) {
        this._guess_rootedness = bl;
    }

    private void setHasNext(boolean bl) {
        this._has_next = bl;
    }

    public void setIgnoreQuotes(boolean bl) {
        this._ignore_quotes = bl;
    }

    private void setInputType(byte by) {
        this._input_type = by;
    }

    private void setNhxSource(Object object) {
        this._nhx_source = object;
    }

    private void setPhylogenies(ArrayList<Phylogeny> arrayList) {
        this._phylogenies = arrayList;
    }

    public void setReplaceUnderscores(boolean bl) {
        this._replace_underscores = bl;
    }

    private void setSawClosingParen(boolean bl) {
        this._saw_closing_paren = bl;
    }

    @Override
    public void setSource(Object object) throws PhylogenyParserException, IOException {
        if (object == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        if (object instanceof String) {
            this.setInputType((byte)0);
            this.setSourceLength(((String)object).length());
            this.setNhxSource(object);
        } else if (object instanceof StringBuffer) {
            this.setInputType((byte)1);
            this.setSourceLength(((StringBuffer)object).length());
            this.setNhxSource(object);
        } else if (object instanceof char[]) {
            this.setInputType((byte)2);
            this.setSourceLength(((char[])object).length);
            this.setNhxSource(object);
        } else if (object instanceof File) {
            this.setInputType((byte)3);
            this.setSourceLength(0);
            File file = (File)object;
            String string = ForesterUtil.isReadableFile(file);
            if (!ForesterUtil.isEmpty(string)) {
                throw new PhylogenyParserException(string);
            }
            this.setNhxSource(new BufferedReader(new FileReader(file)));
        } else if (object instanceof InputStream) {
            this.setInputType((byte)3);
            this.setSourceLength(0);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
            this.setNhxSource(new BufferedReader(inputStreamReader));
        } else {
            throw new IllegalArgumentException(this.getClass() + " can only parse objects of type String," + " StringBuffer, char[], File," + " or InputStream " + " [attempt to parse object of " + object.getClass() + "].");
        }
        this.setHasNext(true);
    }

    private void setSourceLength(int n) {
        this._source_length = n;
    }

    public void setTaxonomyExtraction(PhylogenyMethods.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) {
        this._taxonomy_extraction = tAXONOMY_EXTRACTION;
    }

    private static double doubleValue(String string) throws NHXFormatException {
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NHXFormatException("error in NH/NHX formatted data: failed to parse number from :\"" + string + "\"");
        }
    }

    private static boolean isBranchLengthsLikeBootstrapValues(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        double d = phylogenyNodeIterator.next().getDistanceToParent();
        if (d < 10.0 || !phylogenyNodeIterator.hasNext()) {
            return false;
        }
        while (phylogenyNodeIterator.hasNext()) {
            double d2 = phylogenyNodeIterator.next().getDistanceToParent();
            if (d2 == d && !(d2 < 10.0)) continue;
            return false;
        }
        return true;
    }

    private static void moveBranchLengthsToConfidenceValues(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            PhylogenyMethods.setBootstrapConfidence(phylogenyNode, phylogenyNode.getDistanceToParent());
            phylogenyNode.setDistanceToParent(-1024.0);
        }
    }

    public static void parseNHX(String string, PhylogenyNode phylogenyNode, PhylogenyMethods.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION, boolean bl) throws NHXFormatException, PhyloXmlDataFormatException {
        if (tAXONOMY_EXTRACTION != PhylogenyMethods.TAXONOMY_EXTRACTION.NO && bl) {
            throw new IllegalArgumentException("cannot extract taxonomies and replace under scores at the same time");
        }
        if (string != null && string.length() > 0) {
            Object object;
            if (bl) {
                string = string.replaceAll("_+", " ");
            }
            boolean bl2 = false;
            int n = string.indexOf("[");
            if (n > -1) {
                object = "";
                bl2 = true;
                int n2 = string.indexOf("]");
                if (n2 < 0) {
                    throw new NHXFormatException("error in NHX formatted data: no closing \"]\" in \"" + string + "\"");
                }
                if (string.indexOf("&&NHX") == n + 1) {
                    object = string.substring(n + 6, n2);
                } else {
                    String string2 = string.substring(n + 1, n2);
                    Matcher matcher = NUMBERS_ONLY_PATTERN.matcher(string2);
                    if (matcher.matches()) {
                        object = ":B=" + string2;
                    } else if (string.indexOf("prob=") > -1) {
                        NHXParser.processMrBayes3Data(string, phylogenyNode);
                    }
                }
                string = string.substring(0, n) + (String)object;
                if (string.indexOf("[") > -1 || string.indexOf("]") > -1) {
                    throw new NHXFormatException("error in NHX formatted data: more than one \"]\" or \"[\"");
                }
            }
            if (((StringTokenizer)(object = new StringTokenizer(string, ":"))).countTokens() > 0) {
                if (!string.startsWith(":")) {
                    String string3;
                    phylogenyNode.setName(((StringTokenizer)object).nextToken());
                    if (!(bl || bl2 || tAXONOMY_EXTRACTION == PhylogenyMethods.TAXONOMY_EXTRACTION.NO || ForesterUtil.isEmpty(string3 = ParserUtils.extractTaxonomyCodeFromNodeName(phylogenyNode.getName(), tAXONOMY_EXTRACTION)))) {
                        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                        }
                        phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode(string3);
                    }
                }
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string = ((StringTokenizer)object).nextToken();
                    if (string.startsWith("S=")) {
                        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                        }
                        phylogenyNode.getNodeData().getTaxonomy().setScientificName(string.substring(2));
                        continue;
                    }
                    if (string.startsWith("AN=")) {
                        if (!phylogenyNode.getNodeData().isHasSequence()) {
                            phylogenyNode.getNodeData().setSequence(new Sequence());
                        }
                        Annotation annotation = new Annotation("_:_");
                        annotation.setDesc(string.substring(3));
                        phylogenyNode.getNodeData().getSequence().addAnnotation(annotation);
                        continue;
                    }
                    if (string.startsWith("D=")) {
                        if (string.charAt(2) == 'Y' || string.charAt(2) == 'T') {
                            phylogenyNode.getNodeData().setEvent(Event.createSingleDuplicationEvent());
                            continue;
                        }
                        if (string.charAt(2) == 'N' || string.charAt(2) == 'F') {
                            phylogenyNode.getNodeData().setEvent(Event.createSingleSpeciationEvent());
                            continue;
                        }
                        if (string.charAt(2) == '?') {
                            phylogenyNode.getNodeData().setEvent(Event.createSingleSpeciationOrDuplicationEvent());
                            continue;
                        }
                        throw new NHXFormatException("error in NHX formatted data: :D=Y or :D=N or :D=?");
                    }
                    if (string.startsWith("B=")) {
                        PhylogenyMethods.setConfidence(phylogenyNode, NHXParser.doubleValue(string.substring(2)));
                        continue;
                    }
                    if (string.startsWith("T=")) {
                        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                        }
                        phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(string.substring(2)));
                        continue;
                    }
                    if (string.startsWith("W=")) {
                        PhylogenyMethods.setBranchWidthValue(phylogenyNode, Integer.parseInt(string.substring(2)));
                        continue;
                    }
                    if (string.startsWith("C=")) {
                        Color color = NHXParser.stringToColor(string.substring(2));
                        if (color == null) continue;
                        PhylogenyMethods.setBranchColorValue(phylogenyNode, color);
                        continue;
                    }
                    if (string.startsWith("XN=")) {
                        if (!phylogenyNode.getNodeData().isHasProperties()) {
                            phylogenyNode.getNodeData().setProperties(new PropertiesMap());
                        }
                        phylogenyNode.getNodeData().getProperties().addProperty(Property.createFromNhxString(string));
                        continue;
                    }
                    if (string.startsWith("DS=")) {
                        if (!phylogenyNode.getNodeData().isHasSequence()) {
                            phylogenyNode.getNodeData().setSequence(new Sequence());
                        }
                        phylogenyNode.getNodeData().getSequence().setDomainArchitecture(new DomainArchitecture(string.substring(3)));
                        continue;
                    }
                    if (string.startsWith("ID=")) {
                        phylogenyNode.getNodeData().setNodeIdentifier(new Identifier(string.substring(3)));
                        continue;
                    }
                    if (string.startsWith("AC=")) {
                        if (!phylogenyNode.getNodeData().isHasSequence()) {
                            phylogenyNode.getNodeData().setSequence(new Sequence());
                        }
                        phylogenyNode.getNodeData().getSequence().setAccession(new Accession(string.substring(3), "?"));
                        continue;
                    }
                    if (string.startsWith("GN=")) {
                        if (!phylogenyNode.getNodeData().isHasSequence()) {
                            phylogenyNode.getNodeData().setSequence(new Sequence());
                        }
                        phylogenyNode.getNodeData().getSequence().setName(string.substring(3));
                        continue;
                    }
                    if (string.startsWith("G=")) {
                        if (!phylogenyNode.getNodeData().isHasSequence()) {
                            phylogenyNode.getNodeData().setSequence(new Sequence());
                        }
                        phylogenyNode.getNodeData().getSequence().setName(string.substring(2));
                        continue;
                    }
                    if (string.indexOf(61) >= 0) continue;
                    if (phylogenyNode.getDistanceToParent() != -1024.0) {
                        throw new NHXFormatException("error in NHX formatted data: more than one distance to parent:\"" + string + "\"");
                    }
                    phylogenyNode.setDistanceToParent(NHXParser.doubleValue(string));
                }
            }
        }
    }

    private static void processMrBayes3Data(String string, PhylogenyNode phylogenyNode) throws NHXFormatException {
        Matcher matcher;
        Matcher matcher2;
        double d = -1.0;
        Matcher matcher3 = MB_PROB_SD_PATTERN.matcher(string);
        if (matcher3.find()) {
            try {
                d = Double.parseDouble(matcher3.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NHXFormatException("failed to parse probability standard deviation (Mr Bayes output) from \"" + string + "\"");
            }
        }
        if ((matcher2 = MB_PROB_PATTERN.matcher(string)).find()) {
            double d2 = -1.0;
            try {
                d2 = Double.parseDouble(matcher2.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NHXFormatException("failed to parse probability (Mr Bayes output) from \"" + string + "\"");
            }
            if (d2 >= 0.0) {
                if (d >= 0.0) {
                    phylogenyNode.getBranchData().addConfidence(new Confidence(d2, "posterior probability", d));
                } else {
                    phylogenyNode.getBranchData().addConfidence(new Confidence(d2, "posterior probability"));
                }
            }
        }
        if ((matcher = MB_BL_PATTERN.matcher(string)).find()) {
            double d3 = -1.0;
            try {
                d3 = Double.parseDouble(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NHXFormatException("failed to parse median branch length (Mr Bayes output) from \"" + string + "\"");
            }
            if (d3 >= 0.0) {
                phylogenyNode.setDistanceToParent(d3);
            }
        }
    }

    private static Color stringToColor(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 3) {
            throw new IllegalArgumentException("illegal format for color: " + string);
        }
        int n = ForesterUtil.limitRangeForColor(Integer.parseInt(stringTokenizer.nextToken()));
        int n2 = ForesterUtil.limitRangeForColor(Integer.parseInt(stringTokenizer.nextToken()));
        int n3 = ForesterUtil.limitRangeForColor(Integer.parseInt(stringTokenizer.nextToken()));
        return new Color(n, n2, n3);
    }
}

