/*
 * Decompiled with CFR 0.152.
 */
package briefj.run;

import briefj.BriefIO;
import briefj.BriefStrings;
import briefj.db.Records;
import briefj.opt.OptionsParser;
import briefj.opt.OrderedStringMap;
import briefj.repo.RepositoryUtils;
import briefj.run.DependencyUtils;
import briefj.run.ExecutionInfoFiles;
import briefj.run.HashUtils;
import briefj.run.IOLinkUtils;
import briefj.run.OptionsUtils;
import briefj.run.RedirectionUtils;
import briefj.run.Results;
import briefj.run.SysInfoUtils;
import com.google.common.hash.HashCode;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Mains {
    private static OrderedStringMap outputMap = new OrderedStringMap();

    public static void instrumentedRun(String[] args, Runnable mainClass) {
        long startTime = System.currentTimeMillis();
        RedirectionUtils.Tees tees = ExecutionInfoFiles.exists("stdout.txt") ? null : RedirectionUtils.createTees(ExecutionInfoFiles.getExecutionInfoFolder());
        RecordPermanentStateResults optsRead = Mains.recordPermanentState(args, mainClass);
        Mains.recordTransientInfo(args, mainClass, startTime);
        if (optsRead.optionReadSuccessfully) {
            try {
                mainClass.run();
            }
            catch (RuntimeException e) {
                BriefIO.write(ExecutionInfoFiles.getFile("exception-message.txt"), ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
        long endTime = System.currentTimeMillis();
        if (!ExecutionInfoFiles.exists("end-time.txt")) {
            BriefIO.write(ExecutionInfoFiles.getFile("end-time.txt"), "" + endTime);
        }
        System.out.println("executionMilliseconds : " + (endTime - startTime));
        System.out.println("outputFolder : " + Results.getResultFolder().getAbsolutePath());
        if (tees != null) {
            tees.close();
        }
        outputMap.printEasy(ExecutionInfoFiles.getFile("output.map"));
        if (System.getenv().get("CONN_PATH") != null) {
            Records.recordsFromEnvironmentVariable().recordFullRun(optsRead.options.asLinkedHashMap(), outputMap.asLinkedHashMap(), Results.getResultFolder());
        }
    }

    private static void recordTransientInfo(String[] args, Runnable mainClass, long startTime) {
        if (!ExecutionInfoFiles.exists("start-time.txt")) {
            BriefIO.write(ExecutionInfoFiles.getFile("start-time.txt"), "" + startTime);
        }
        if (!ExecutionInfoFiles.exists("host-info.map")) {
            BriefIO.write(ExecutionInfoFiles.getFile("host-info.map"), Mains.hostInfo());
        }
    }

    private static CharSequence hostInfo() {
        return "Host\t" + SysInfoUtils.getHostName() + "\n" + "CPUSpeed\t" + SysInfoUtils.getCPUSpeedStr() + "\n" + "MaxMemory\t" + SysInfoUtils.getMaxMemoryStr() + "\n" + "NumCPUs\t" + SysInfoUtils.getNumCPUs();
    }

    private static RecordPermanentStateResults recordPermanentState(String[] args, Runnable mainClass) {
        boolean success;
        OptionsParser parser;
        try {
            parser = OptionsUtils.parseOptions(args, mainClass);
            if (!ExecutionInfoFiles.exists("options.map")) {
                OptionsUtils.recordOptions(parser);
            }
        }
        catch (OptionsUtils.InvalidOptionsException e) {
            return new RecordPermanentStateResults(false, null);
        }
        try {
            if (!ExecutionInfoFiles.exists("code/info.map") && !RepositoryUtils.recordCodeVersion(mainClass)) {
                BriefIO.write(ExecutionInfoFiles.getFile("dirty.sha1"), HashUtils.HASH_FUNCTION.hashUnencodedChars((CharSequence)BriefStrings.generateUniqueId()).toString());
            }
        }
        catch (RuntimeException e) {
            System.err.println("WARNING: Bare Repository has neither a working tree, nor an index.");
            BriefIO.write(ExecutionInfoFiles.getFile("exception-message.txt"), ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (!ExecutionInfoFiles.exists("code/classpath.txt")) {
            DependencyUtils.recordClassPath();
        }
        if (!ExecutionInfoFiles.exists("inputs") && !(success = IOLinkUtils.createIOLinks(parser))) {
            BriefIO.write(ExecutionInfoFiles.getFile("dirty.sha1"), HashUtils.HASH_FUNCTION.hashUnencodedChars((CharSequence)BriefStrings.generateUniqueId()).toString());
        }
        HashCode global = HashUtils.computeFileHashCodesRecursively(ExecutionInfoFiles.getExecutionInfoFolder());
        BriefIO.write(ExecutionInfoFiles.getFile("global.sha1"), global.toString());
        return new RecordPermanentStateResults(true, parser.getOptionPairs());
    }

    public static void putLogRec(String key, Object value) {
        outputMap.put(key, value.toString());
    }

    private static class RecordPermanentStateResults {
        public boolean optionReadSuccessfully;
        public OrderedStringMap options;

        public RecordPermanentStateResults(boolean optionReadSuccessfully, OrderedStringMap options) {
            this.optionReadSuccessfully = optionReadSuccessfully;
            this.options = options;
        }
    }
}

