/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

final class TextFrame
extends JFrame
implements ActionListener,
ClipboardOwner {
    private static final long serialVersionUID = -5012834229705518363L;
    private static Color ta_text_color = new Color(0, 0, 0);
    private static Color ta_background_color = new Color(240, 240, 240);
    private static Color background_color = new Color(215, 215, 215);
    private static Color button_background_color = new Color(215, 215, 215);
    private static Color button_text_color = new Color(0, 0, 0);
    private static final Font button_font = new Font("Helvetica", 0, 10);
    private static final Font ta_font = new Font("Helvetica", 0, 10);
    private boolean can_use_clipboard;
    private final String text;
    private final JTextArea jtextarea;
    private final JButton close_button;
    private JButton copy_button;
    private final JPanel buttonjpanel;
    private final Container contentpane;

    private TextFrame(String string) {
        this.setTitle("Archaeopteryx");
        this.text = string;
        this.can_use_clipboard = true;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkSystemClipboardAccess();
            }
            catch (Exception exception) {
                this.can_use_clipboard = false;
            }
        }
        this.setBackground(background_color);
        this.buttonjpanel = new JPanel();
        this.buttonjpanel.setBackground(background_color);
        this.close_button = new JButton("          Close          ");
        this.close_button.setBackground(button_background_color);
        this.close_button.setForeground(button_text_color);
        this.close_button.setFont(button_font);
        this.close_button.addActionListener(this);
        this.buttonjpanel.add(this.close_button);
        if (this.can_use_clipboard) {
            this.copy_button = new JButton("Copy to clipboard");
            this.copy_button.setBackground(button_background_color);
            this.copy_button.setForeground(button_text_color);
            this.copy_button.setFont(button_font);
            this.copy_button.addActionListener(this);
            this.buttonjpanel.add(this.copy_button);
        }
        this.contentpane = this.getContentPane();
        this.contentpane.setLayout(new BorderLayout());
        this.jtextarea = new JTextArea(this.text);
        this.jtextarea.setBackground(ta_background_color);
        this.jtextarea.setForeground(ta_text_color);
        this.jtextarea.setFont(ta_font);
        this.jtextarea.setEditable(false);
        this.jtextarea.setWrapStyleWord(true);
        this.jtextarea.setLineWrap(true);
        this.contentpane.add((Component)new JScrollPane(this.jtextarea), "Center");
        this.buttonjpanel.setLayout(new FlowLayout(1, 20, 5));
        this.contentpane.add((Component)this.buttonjpanel, "South");
        this.setSize(500, 400);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TextFrame.this.close();
            }
        });
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.close_button) {
            this.close();
        } else if (object == this.copy_button) {
            this.copy();
        }
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void copy() {
        if (!this.can_use_clipboard) {
            return;
        }
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(this.jtextarea.getText());
        clipboard.setContents(stringSelection, this);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    static TextFrame instantiate(String string) {
        return new TextFrame(string);
    }
}

