/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.particles;

import JSci.physics.particles.ElectronNeutrino;
import JSci.physics.particles.Lepton;
import JSci.physics.particles.Photon;
import JSci.physics.particles.Positron;
import JSci.physics.particles.WMinus;
import JSci.physics.particles.WPlus;
import JSci.physics.particles.ZZero;
import JSci.physics.quantum.QuantumParticle;

public final class Electron
extends Lepton {
    public double restMass() {
        return 0.510998902;
    }

    public int charge() {
        return -1;
    }

    public int eLeptonQN() {
        return 1;
    }

    public int muLeptonQN() {
        return 0;
    }

    public int tauLeptonQN() {
        return 0;
    }

    public QuantumParticle anti() {
        return new Positron();
    }

    public boolean isAnti(QuantumParticle quantumParticle) {
        return quantumParticle != null && quantumParticle instanceof Positron;
    }

    public String toString() {
        return new String("Electron");
    }

    public Electron emit(Photon photon) {
        this.momentum = this.momentum.subtract(photon.momentum);
        return this;
    }

    public Electron absorb(Photon photon) {
        this.momentum = this.momentum.add(photon.momentum);
        return this;
    }

    public ElectronNeutrino emit(WMinus wMinus) {
        ElectronNeutrino electronNeutrino = new ElectronNeutrino();
        electronNeutrino.momentum = this.momentum.subtract(wMinus.momentum);
        return electronNeutrino;
    }

    public ElectronNeutrino absorb(WPlus wPlus) {
        ElectronNeutrino electronNeutrino = new ElectronNeutrino();
        electronNeutrino.momentum = this.momentum.add(wPlus.momentum);
        return electronNeutrino;
    }

    public Electron emit(ZZero zZero) {
        this.momentum = this.momentum.subtract(zZero.momentum);
        return this;
    }

    public Electron absorb(ZZero zZero) {
        this.momentum = this.momentum.add(zZero.momentum);
        return this;
    }
}

