/*
 * Decompiled with CFR 0.152.
 */
package conifer.evol;

import conifer.evol.EvolutionaryModel;
import ev.poi.PoissonParameters;
import fig.basic.Option;
import java.util.Random;
import ma.SequenceType;

public class EvolutionaryOptions {
    @Option
    public EvolutionaryModel model = EvolutionaryModel.SIMPLE_SUBSTITUTION;
    @Option
    public Random rand = new Random(1L);
    @Option(gloss="If the model is based on a fixed number of site")
    public int nSites = 1000;
    @Option
    public double transitionToTransversionRatio = 2.0;
    @Option
    public SequenceType sequenceType = SequenceType.RNA;
    @Option
    public double pipParam1 = 100.0;
    @Option
    public double pipParam2 = 10.0;
    @Option
    public PIPParamType pipParamType = PIPParamType.LEN_INT;
    @Option
    public double tkfParam1 = 100.0;
    @Option
    public double tkfParam2 = 1.0;

    public static enum PIPParamType {
        LEN_INT{

            @Override
            public double getLambda(double param1, double param2) {
                return PoissonParameters.getInsertionRateFromAdditiveIntensityParam(param1, param2);
            }

            @Override
            public double getMu(double param1, double param2) {
                return PoissonParameters.getDeleteRateFromAdditiveIntensityParam(param1, param2);
            }
        }
        ,
        LAMBDA_MU{

            @Override
            public double getLambda(double param1, double param2) {
                return param1;
            }

            @Override
            public double getMu(double param1, double param2) {
                return param2;
            }
        };


        public abstract double getLambda(double var1, double var3);

        public abstract double getMu(double var1, double var3);
    }
}

