/*
 * Decompiled with CFR 0.152.
 */
package conifer.fastpf;

import conifer.fastpf.FastParticle;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import nuts.util.Arbre;
import nuts.util.Tree;
import pty.RootedTree;

public class FastPFUtils {
    public static <S> void merge(S[] source, S[] destination, int first, int second, S merged) {
        int i;
        if (destination.length != source.length - 1) {
            throw new RuntimeException();
        }
        if (first == second) {
            throw new RuntimeException();
        }
        if (first > second) {
            int _first = first;
            first = second;
            second = _first;
        }
        for (i = 0; i < first; ++i) {
            destination[i] = source[i];
        }
        destination[first] = merged;
        for (i = first + 1; i < second; ++i) {
            destination[i] = source[i];
        }
        for (i = second; i < destination.length; ++i) {
            destination[i] = source[i + 1];
        }
    }

    public static RootedTree getTree(FastParticle.CacheNode node) {
        HashMap<Taxon, Double> branchLengths = new HashMap<Taxon, Double>();
        Arbre<Taxon> topo = FastPFUtils.processTree(node.tree, branchLengths);
        return RootedTree.Util.create(topo, branchLengths);
    }

    private static Arbre<Taxon> processTree(Tree<FastParticle.PhyloNode> tree, Map<Taxon, Double> branchLengths) {
        int nChildren = tree.getChildren().size();
        if (nChildren != tree.getLabel().childrenBLs.size()) {
            throw new RuntimeException();
        }
        ArrayList transformedChildren = new ArrayList();
        for (int i = 0; i < nChildren; ++i) {
            double bl = tree.getLabel().childrenBLs.get(i);
            Tree<FastParticle.PhyloNode> child = tree.getChildren().get(i);
            branchLengths.put(child.getLabel().taxon, bl);
            transformedChildren.add(FastPFUtils.processTree(child, branchLengths));
        }
        return new Arbre<Taxon>(tree.getLabel().taxon, transformedChildren);
    }

    public static void testSpeed() {
        Random rand = new Random(1L);
        long init = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            ArrayList<Double> array = new ArrayList<Double>(24000);
            for (int k = 0; k < 24000; ++k) {
                array.add(rand.nextDouble());
            }
            for (int j = 0; j < 20000; ++j) {
                ArrayList array2 = new ArrayList(array.size() - 1);
                for (int k = 0; k < array.size() - 1; ++k) {
                    array2.add(array.get(k));
                }
                array = array2;
            }
            double interv = System.currentTimeMillis() - init;
            System.out.println("" + interv / ((double)i + 1.0));
        }
    }
}

