/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import cern.jet.stat.Gamma;

public class MittagLefflerFunction {
    private static final double EPS = 1.0E-14;
    private static final boolean DEBUG = false;
    private static double[] a0 = new double[]{-424.129, -2910.78, -1595.94, -4016.68, -4806.19, -3587.0, -4312.71, -10481.3, -11318.2, -10053.4, -7718.9, -2099.49, -20196.6, -14418.5, -3586.99, -36738.4, -8343.48, -6659.2, -8803.13, -5169.37, -18165.4, -28773.9, -28396.9, -21895.0, -18486.5, -15493.0, -25265.6, -34828.6, -22317.8, -26215.2, -11031.6, -34488.7, -25344.0, -32003.7, -78864.8, -28978.1, -14205.1, -81655.1, -57587.1, -17380.8, -10347.7, -19508.6, -33316.5, -47328.6, -14759.8, -15291.4, -16703.7, -14261.1, -65470.6, -188.8, -51644.8, -39215.4, -13544.9, -9538.41, -793.386, -5992.32, -33739.3, -46396.0, -1517.91, -5027.29, -48010.3, -6715.12, -31278.0, -56795.4, -1492.3, -43339.6, -7523.21, -50314.9, -11347.5, -277.604, -55169.4, -31030.5, -1607.66, 3419.35, 1737.63, -1980.04, -2555.74, -1073.1, -4944.5, -2180.66, -5343.78, -6754.67, -702.848, -6099.8, -10305.3, -7747.71, -8389.04, -4477.5, -3907.87, -7246.88, -15226.2, -15010.8, -10649.5, -15390.6, -6003.32, -44579.7, -35517.1, -14539.7, -10599.6};
    private static double[] a1 = new double[]{-695856.0, -2317050.0, -883786.0, -1513290.0, -1455500.0, -953746.0, -958824.0, -2205620.0, -2041620.0, -1655460.0, -1169520.0, -331485.0, -2646280.0, -1773800.0, -414163.0, -3879820.0, -877610.0, -661019.0, -839225.0, -463982.0, -1599290.0, -2416170.0, -2335230.0, -1742740.0, -1428470.0, -1165720.0, -1873670.0, -2501570.0, -1588190.0, -1806300.0, -741001.0, -2315400.0, -1659430.0, -2069830.0, -5066200.0, -1953790.0, -971770.0, -5235780.0, -3485330.0, -1172770.0, -686777.0, -1296170.0, -2212520.0, -3117420.0, -982326.0, -1047120.0, -1145330.0, -991368.0, -4556180.0, -13537.0, -3731700.0, -2896870.0, -1063920.0, -748349.0, -63933.3, -443865.0, -2861900.0, -4051680.0, -125852.0, -464569.0, -4611030.0, -708363.0, -3289860.0, -6322390.0, -182752.0, -5499880.0, -1096820.0, -7828280.0, -2048000.0, -53539.7, -1.58192E7, -1.02892E7, -4492540.0, -2419060.0, -1033570.0, -170209.0, -399973.0, -102865.0, -463767.0, -219047.0, -539996.0, -688012.0, -69057.8, -583751.0, -915547.0, -667011.0, -693431.0, -359964.0, -296304.0, -509096.0, -1001580.0, -942028.0, -626399.0, -847297.0, -311566.0, -2144920.0, -1596740.0, -610793.0, -416113.0};
    private static double[] a2 = new double[]{-391944.0, -1213930.0, -485177.0, -678102.0, -643881.0, -452754.0, -424475.0, -1096490.0, -931135.0, -753470.0, -530686.0, -178194.0, -1183610.0, -787251.0, -180624.0, -1577080.0, -381391.0, -279508.0, -352670.0, -186660.0, -655973.0, -962412.0, -935683.0, -687682.0, -555414.0, -448241.0, -720787.0, -938597.0, -597404.0, -659350.0, -263517.0, -831618.0, -579558.0, -712936.0, -1728630.0, -707274.0, -354821.0, -1758720.0, -1076170.0, -408516.0, -231234.0, -429282.0, -718492.0, -981295.0, -304968.0, -326140.0, -346912.0, -293586.0, -1308490.0, -3836.75, -1027160.0, -780114.0, -289899.0, -193214.0, -15987.5, -95261.4, -663678.0, -899289.0, -24150.7, -91918.7, -860143.0, -131044.0, -533551.0, -945394.0, -25949.9, -664464.0, -126030.0, -716973.0, -158167.0, -2266.39, -673086.0, 66334.8, -116371.0, -66971.7, -513330.0, -546410.0, -408010.0, -104591.0, -357502.0, -128115.0, -258539.0, -275764.0, -24078.9, -176849.0, -247199.0, -156824.0, -141730.0, -62998.3, -44609.9, -65494.0, -106340.0, -79281.0, -39885.9, -37130.8, 7560.57, -11985.5, 20670.8, 19040.2, 20434.0};
    private static double[] b1 = new double[]{-1386370.0, -4601000.0, -1747110.0, -2989580.0, -2866380.0, -1868150.0, -1874470.0, -4278370.0, -3955680.0, -3193710.0, -2246580.0, -628014.0, -5039440.0, -3362810.0, -782040.0, -7320690.0, -1639910.0, -1230900.0, -1554650.0, -857478.0, -2933800.0, -4416850.0, -4239700.0, -3148030.0, -2566700.0, -2082890.0, -3323620.0, -4417640.0, -2782650.0, -3151840.0, -1286580.0, -3983740.0, -2841330.0, -3519750.0, -8548650.0, -3240610.0, -1593850.0, -8607670.0, -5740120.0, -1878570.0, -1093920.0, -2046980.0, -3465520.0, -4849920.0, -1513240.0, -1592460.0, -1727740.0, -1480610.0, -6750940.0, -19822.3, -5413570.0, -4157030.0, -1501420.0, -1048870.0, -88643.9, -619108.0, -3885350.0, -5442540.0, -169238.0, -611566.0, -6002970.0, -906252.0, -4186110.0, -7947660.0, -226154.0, -6745190.0, -1320940.0, -9328830.0, -2400960.0, -62191.0, -1.78833E7, -1.15056E7, -4824290.0, -2522950.0, -1068530.0, -212224.0, -461840.0, -125079.0, -563528.0, -262855.0, -645497.0, -819312.0, -82428.3, -697471.0, -1102780.0, -805409.0, -840712.0, -437447.0, -362820.0, -630388.0, -1252540.0, -1186690.0, -797901.0, -1092420.0, -406277.0, -2841190.0, -2146730.0, -834188.0, -577797.0};
    private static double[] b2 = new double[]{-795778.0, -2503850.0, -1015620.0, -1447430.0, -1397510.0, -996694.0, -952144.0, -2487470.0, -2155240.0, -1773050.0, -1269540.0, -428531.0, -2929060.0, -1981840.0, -463020.0, -4140170.0, -1011200.0, -755801.0, -970538.0, -525412.0, -1873160.0, -2807010.0, -2773980.0, -2079110.0, -1712820.0, -1409060.0, -2305550.0, -3069510.0, -1987230.0, -2246020.0, -919175.0, -2945220.0, -2103360.0, -2643420.0, -6542230.0, -2681370.0, -1365690.0, -7052950.0, -4509940.0, -1678330.0, -977034.0, -1855820.0, -3181940.0, -4472000.0, -1421890.0, -1545530.0, -1691180.0, -1470620.0, -6754810.0, -20276.8, -5597980.0, -4371010.0, -1643340.0, -1144600.0, -97979.9, -646389.0, -4387670.0, -6205150.0, -185486.0, -705142.0, -6979980.0, -1088430.0, -4945180.0, -9471070.0, -275373.0, -8156450.0, -1642960.0, -1.15421E7, -3018970.0, -76819.2, -2.32888E7, -1.46317E7, -6820610.0, -3767900.0, -2124900.0, -727938.0, -889107.0, -207143.0, -802633.0, -339154.0, -766988.0, -908437.0, -84714.2, -667838.0, -963517.0, -651177.0, -624128.0, -299094.0, -222076.0, -335377.0, -574996.0, -467003.0, -255226.0, -268144.0, -71035.3, -270455.0, -42369.0, 46408.3, 75560.3};
    private static double[] b3 = new double[]{-207.4, -1279.23, -832.687, -1382.6, -1711.18, -1608.73, -1750.12, -5948.5, -5601.93, -5277.49, -4291.68, -1839.67, -12345.1, -9234.08, -2354.32, -21868.3, -6190.07, -4953.76, -6898.8, -3919.39, -15396.8, -24405.7, -26140.4, -20855.0, -18255.4, -15999.8, -28057.1, -39252.7, -27220.1, -32138.9, -13744.9, -47379.5, -35288.8, -46705.8, -122026.0, -55597.8, -30238.6, -156056.0, -99172.0, -42955.8, -25872.7, -51482.1, -92251.8, -134275.0, -44778.9, -51730.2, -58760.5, -53176.0, -253173.0, -797.517, -228252.0, -185908.0, -74910.6, -53046.2, -4699.73, -28869.0, -223581.0, -324201.0, -9041.56, -37794.0, -378472.0, -62683.2, -268704.0, -509518.0, -15131.7, -407908.0, -84370.3, -500161.0, -117538.0, -1504.46, -532630.0, 202771.0, -111373.0, -80853.8, -787594.0, -906762.0, -736776.0, -205284.0, -767703.0, -302753.0, -675138.0, -800006.0, -77929.3, -642815.0, -1013970.0, -733497.0, -763282.0, -396021.0, -331368.0, -584487.0, -1173090.0, -1123660.0, -766267.0, -1064810.0, -401715.0, -2856410.0, -2192390.0, -865369.0, -608788.0};
    private double alpha;
    private double beta;

    public MittagLefflerFunction(double alpha) {
        this.alpha = alpha;
        this.beta = 1.0;
    }

    public MittagLefflerFunction(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    public static void main(String[] arg) {
        int j;
        double x;
        int i;
        System.out.println("Comparing power-series expansion to Pade approximation of");
        System.out.println("E_{\\alpha}(-x^{\\alpha})");
        int lenAlpha = 20;
        int lenX = 1000;
        double startAlpha = 0.05;
        double endAlpha = 0.999;
        double startX = 0.001;
        double endX = 20.0;
        double incAlpha = (endAlpha - startAlpha) / (double)lenAlpha;
        double incX = (endX - startX) / (double)lenX;
        double[][] padeResults = new double[lenAlpha][lenX];
        double[][] powsResults = new double[lenAlpha][lenX];
        long start = System.nanoTime();
        double alpha = startAlpha;
        for (i = 0; i < lenAlpha; ++i) {
            x = startX;
            for (j = 0; j < lenX; ++j) {
                padeResults[i][j] = MittagLefflerFunction.evaluatePade(x, alpha);
                x += incX;
            }
            alpha += incAlpha;
        }
        long end = System.nanoTime();
        System.out.println("Pade run: " + (end - start));
        start = System.nanoTime();
        alpha = startAlpha;
        for (i = 0; i < lenAlpha; ++i) {
            x = startX;
            for (j = 0; j < lenX; ++j) {
                powsResults[i][j] = MittagLefflerFunction.evaluatePowerSeries(x, alpha);
                x += incX;
            }
            alpha += incAlpha;
        }
        end = System.nanoTime();
        System.out.println("PowS run: " + (end - start));
        double MSE = 0.0;
        for (int i2 = 0; i2 < lenAlpha; ++i2) {
            for (int j2 = 0; j2 < lenX; ++j2) {
                double delta = padeResults[i2][j2] - powsResults[i2][j2];
                MSE += delta * delta;
                if (!(Math.abs(delta) > 0.1)) continue;
                System.err.println("Big difference at (" + i2 + "," + j2 + ") = " + delta);
            }
        }
        System.out.println("MSE = " + (MSE /= (double)(lenAlpha * lenX)));
    }

    public double evaluate(double x) {
        return MittagLefflerFunction.evaluatePowerSeries(x, this.alpha, this.beta);
    }

    public static double evaluatePowerSeries(double x, double alpha, double beta) {
        return MittagLefflerFunction.evaluatePowerSeries(x, alpha, beta, 1.0E-14);
    }

    public static double evaluatePowerSeries(double x, double alpha) {
        return MittagLefflerFunction.evaluatePowerSeries(x, alpha, 1.0, 1.0E-14);
    }

    public static double evaluatePowerSeries(double x, double alpha, double beta, double eps) {
        double z = -Math.pow(x, alpha);
        double E = 0.0;
        double summand = 1.0;
        int k = 0;
        double XpowK = 1.0;
        while (Math.abs(summand) >= eps) {
            summand = XpowK / MittagLefflerFunction.gamma(beta + alpha * (double)k);
            XpowK *= z;
            ++k;
            E += summand;
        }
        return E;
    }

    public static double evaluatePade(double x, double alpha) {
        return MittagLefflerFunction.evaluatePade(x, 0.0, alpha);
    }

    public static double evaluatePade(double x, double y, double alpha) {
        double E;
        block7: {
            block8: {
                block6: {
                    if (alpha < 0.01 || alpha > 1.0) {
                        System.err.println("alpha = " + alpha);
                        throw new RuntimeException("Mittag-Leffler function only implemented for 0.01 <= alpha <= 1");
                    }
                    if (y != 0.0) {
                        throw new RuntimeException("Mittag-Leffler function only implemented for real arguments");
                    }
                    if (alpha == 1.0) {
                        return Math.exp(-Math.pow(x, alpha));
                    }
                    if (x < 0.0) {
                        throw new RuntimeException("Mittag-Leffler function only defined for positive quantities");
                    }
                    if (!(x <= 0.1)) break block6;
                    E = 0.0;
                    double z = -Math.pow(x, alpha);
                    for (int k = 0; k <= 4; ++k) {
                        E += Math.pow(z, k) / MittagLefflerFunction.gamma(1.0 + alpha * (double)k);
                    }
                    break block7;
                }
                if (!(x < 15.0)) break block8;
                double rescaledAlpha = alpha * 100.0;
                int end = (int)rescaledAlpha;
                int start = end - 1;
                double delta = rescaledAlpha - (double)end;
                E = MittagLefflerFunction.padeApproximation(x, start);
                if (!(delta > 0.0)) break block7;
                E *= 1.0 - delta;
                E = end < 99 ? (E += MittagLefflerFunction.padeApproximation(x, end) * delta) : (E += Math.exp(x) * delta);
                break block7;
            }
            E = 0.0;
            double z = -Math.pow(x, -alpha);
            for (int k = 1; k <= 4; ++k) {
                E -= Math.pow(z, k) / MittagLefflerFunction.gamma(1.0 - alpha * (double)k);
            }
        }
        return E;
    }

    private static double gamma(double z) {
        if (z > 0.0) {
            return Gamma.gamma((double)z);
        }
        int n = (int)(-z) + 1;
        double factor = 1.0;
        for (int i = 0; i < n; ++i) {
            factor *= z + (double)i;
        }
        return Gamma.gamma((double)(z + (double)n)) / factor;
    }

    private static double padeApproximation(double x, int i) {
        return (a0[i] + a1[i] * x + a2[i] * x * x) / (1.0 + b1[i] * x + b2[i] * x * x + b3[i] * x * x * x);
    }
}

