/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import cern.jet.stat.Gamma;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class BifractionalDiffusionDensity
implements Distribution {
    private static double oneOverSqrtPi = 1.0 / Math.sqrt(Math.PI);
    private static double oneOverPi = 0.3183098861837907;
    public static final int maxK = 50;
    private double alpha;
    private double beta;
    private double v;
    private double[][][] coefficients;

    public BifractionalDiffusionDensity(double v, double alpha, double beta) {
        this.v = v;
        this.alpha = alpha;
        this.beta = beta;
        this.coefficients = BifractionalDiffusionDensity.constructBifractionalDiffusionCoefficients(alpha, beta);
    }

    public BifractionalDiffusionDensity(double alpha, double beta) {
        this(1.0, alpha, beta);
    }

    @Override
    public double pdf(double x) {
        return this.pdf(x, this.v);
    }

    public double pdf(double x, double v) {
        return BifractionalDiffusionDensity.pdf(x, v, this.alpha, this.beta, this.coefficients);
    }

    @Override
    public double logPdf(double x) {
        return BifractionalDiffusionDensity.logPdf(x, this.v, this.alpha, this.beta, this.coefficients);
    }

    @Override
    public double cdf(double x) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double quantile(double y) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not yet implemented");
    }

    public static double logPdf(double x, double v, double alpha, double beta) {
        return Math.log(BifractionalDiffusionDensity.pdf(x, v, alpha, beta));
    }

    public static double logPdf(double x, double v, double alpha, double beta, double[][][] coefficients) {
        return Math.log(BifractionalDiffusionDensity.pdf(x, v, alpha, beta, coefficients));
    }

    public static SignedDouble logGamma(double z) {
        if (z > 0.0) {
            return new SignedDouble(Gamma.logGamma((double)z), true);
        }
        int n = (int)(-z);
        if (z + (double)n == 0.0) {
            return new SignedDouble(Double.NaN, true);
        }
        boolean positive = ++n % 2 == 0;
        return new SignedDouble(Gamma.logGamma((double)(z + (double)n)) - Gamma.logGamma((double)(-z + 1.0)) + Gamma.logGamma((double)(-z - (double)n + 1.0)), positive);
    }

    public static double gamma(double z) {
        if (z > 0.0) {
            return Gamma.gamma((double)z);
        }
        int n = (int)(-z);
        if (z + (double)n == 0.0) {
            return Double.NaN;
        }
        boolean positive = ++n % 2 == 0;
        double result = Gamma.gamma((double)(z + (double)n)) / Gamma.gamma((double)(-z + 1.0)) * Gamma.gamma((double)(-z - (double)n + 1.0));
        if (!positive) {
            result *= -1.0;
        }
        return result;
    }

    private static double evaluateGreensFunctionAtZero(double t, double alpha, double beta) {
        if (beta == 1.0) {
            double oneOverAlpha = 1.0 / alpha;
            return BifractionalDiffusionDensity.gamma(oneOverAlpha) / (Math.PI * alpha * Math.pow(t, oneOverAlpha));
        }
        double betaOverAlpha = beta / alpha;
        return 1.0 / (alpha * Math.pow(t, betaOverAlpha) * Math.sin(Math.PI / alpha) * BifractionalDiffusionDensity.gamma(1.0 - betaOverAlpha));
    }

    private static double evaluateGreensFunctionAlphaEqualsBeta(double x, double t, double alpha) {
        double absX = Math.abs(x);
        double twoAlpha = 2.0 * alpha;
        double tPowAlpha = Math.pow(t, alpha);
        double piHalfAlpha = 1.5707963267948966 * alpha;
        double green = Math.pow(absX, alpha - 1.0) * tPowAlpha * Math.sin(piHalfAlpha) / (Math.pow(t, twoAlpha) + 2.0 * Math.pow(absX, alpha) * tPowAlpha * Math.cos(piHalfAlpha) + Math.pow(absX, twoAlpha));
        return oneOverPi * green;
    }

    private static double evaluateGreensFunctionBetaGreaterThanAlpha(double x, double t, double alpha, double beta, double[][][] coefficients) {
        double z = Math.pow(2.0, alpha) * Math.pow(t, beta) / Math.pow(Math.abs(x), alpha);
        return oneOverSqrtPi / Math.sqrt(Math.abs(x)) * BifractionalDiffusionDensity.generalizedWrightFunction(-z, coefficients[0], coefficients[1]);
    }

    private static double evaluateGreensFunctionAlphaGreaterThanBeta(double x, double t, double alpha, double beta, double[][][] coefficients) {
        double z1 = Math.pow(Math.abs(x), alpha) / (Math.pow(2.0, alpha) * Math.pow(t, beta));
        double z2 = x * x / (4.0 * Math.pow(t, 2.0 * beta / alpha));
        double green1 = oneOverSqrtPi * Math.pow(Math.abs(x), alpha - 1.0) / (Math.pow(2.0, alpha) * Math.pow(t, beta)) * BifractionalDiffusionDensity.generalizedWrightFunction(-z1, coefficients[2], coefficients[3]);
        double green2 = oneOverSqrtPi / (alpha * Math.pow(t, beta / alpha)) * BifractionalDiffusionDensity.generalizedWrightFunction(-z2, coefficients[4], coefficients[5]);
        return green1 + green2;
    }

    public static double pdf(double x, double v, double alpha, double beta) {
        return BifractionalDiffusionDensity.pdf(x, v, alpha, beta, null);
    }

    public static double pdf(double x, double v, double alpha, double beta, double[][][] coefficients) {
        double t = 0.5 * v;
        if (x == 0.0) {
            return BifractionalDiffusionDensity.evaluateGreensFunctionAtZero(t, alpha, beta);
        }
        if (alpha == beta) {
            return BifractionalDiffusionDensity.evaluateGreensFunctionAlphaEqualsBeta(x, t, alpha);
        }
        if (coefficients == null) {
            coefficients = BifractionalDiffusionDensity.constructBifractionalDiffusionCoefficients(alpha, beta);
        }
        if (alpha > beta) {
            return BifractionalDiffusionDensity.evaluateGreensFunctionAlphaGreaterThanBeta(x, t, alpha, beta, coefficients);
        }
        return BifractionalDiffusionDensity.evaluateGreensFunctionBetaGreaterThanAlpha(x, t, alpha, beta, coefficients);
    }

    public static double[][][] constructBifractionalDiffusionCoefficients(double alpha, double beta) {
        double[][][] coefficients = new double[][][]{new double[][]{{0.5, alpha / 2.0}, {1.0, 1.0}}, new double[][]{{1.0, beta}, {0.0, -alpha / 2.0}}, new double[][]{{0.5 - alpha / 2.0, -alpha / 2.0}, {1.0, 1.0}}, new double[][]{{1.0 - beta, -beta}, {alpha / 2.0, alpha / 2.0}}, new double[][]{{1.0 / alpha, 2.0 / alpha}, {1.0 - 1.0 / alpha, -2.0 / alpha}}, new double[][]{{0.5, 1.0}, {1.0 - beta / alpha, -2.0 * beta / alpha}}};
        return coefficients;
    }

    public static double generalizedWrightFunction(double z, double[][] aAp, double[][] bBq) {
        int p = aAp.length;
        int q = bBq.length;
        double sum = 0.0;
        double zPowK = 1.0;
        for (int k = 0; k < 50; ++k) {
            double x;
            int i;
            double incr = 1.0;
            for (i = 0; i < p; ++i) {
                double[] aAi = aAp[i];
                x = BifractionalDiffusionDensity.gamma(aAi[0] + aAi[1] * (double)k);
                if (!Double.isNaN(x)) {
                    incr *= x;
                    continue;
                }
                incr = Double.NaN;
            }
            for (i = 0; i < q; ++i) {
                double[] bBi = bBq[i];
                x = BifractionalDiffusionDensity.gamma(bBi[0] + bBi[1] * (double)k);
                if (!Double.isNaN(x)) {
                    incr /= x;
                    continue;
                }
                incr = 0.0;
            }
            incr /= BifractionalDiffusionDensity.gamma(k + 1);
            sum += (incr *= zPowK);
            zPowK *= z;
        }
        return sum;
    }

    public static void main(String[] arg) {
        double alpha = 2.0;
        double beta = 0.8;
        double z1 = -2.34;
        SignedDouble result = BifractionalDiffusionDensity.logGamma(z1);
        System.err.println("logGamma(" + z1 + ") = " + result.x + " " + (result.positive ? "(+)" : "(-)"));
        System.err.println("gamma(" + z1 + ") = " + BifractionalDiffusionDensity.gamma(z1));
        System.err.println("gamma(-2.0) = " + BifractionalDiffusionDensity.gamma(-2.0));
        System.err.println("");
        double var = 4.0;
        double t = 0.5 * var;
        double x = 1.0;
        double[][][] coefficients = BifractionalDiffusionDensity.constructBifractionalDiffusionCoefficients(alpha, beta);
        System.err.println("p(x = " + x + ", v = " + var + ") = " + BifractionalDiffusionDensity.evaluateGreensFunctionAlphaGreaterThanBeta(x, t, alpha, beta, coefficients));
        alpha = 0.7;
        beta = 1.4;
        coefficients = BifractionalDiffusionDensity.constructBifractionalDiffusionCoefficients(alpha, beta);
        System.err.println("p(x = " + x + ", v = " + var + ") = " + BifractionalDiffusionDensity.evaluateGreensFunctionBetaGreaterThanAlpha(x, t, alpha, beta, coefficients));
    }

    static class SignedDouble {
        double x;
        boolean positive;

        SignedDouble(double x, boolean positive) {
            this.x = x;
            this.positive = positive;
        }
    }
}

