/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import cern.jet.stat.Gamma;
import dr.math.distributions.KernelDensityEstimatorDistribution;
import dr.stats.DiscreteStatistics;

public class GammaKDEDistribution
extends KernelDensityEstimatorDistribution {
    public GammaKDEDistribution(Double[] sample) {
        this(sample, null);
    }

    public GammaKDEDistribution(Double[] sample, Double bandWidth) {
        super(sample, 0.0, Double.POSITIVE_INFINITY, bandWidth);
    }

    @Override
    protected void processBounds(Double lowerBound, Double upperBound) {
        if (lowerBound > DiscreteStatistics.min(this.sample)) {
            throw new RuntimeException("Sample min out of bounds.  Gamma kernel for use with positive data only: " + DiscreteStatistics.min(this.sample));
        }
        if (upperBound < DiscreteStatistics.max(this.sample)) {
            throw new RuntimeException("Sample max out of bounds" + DiscreteStatistics.max(this.sample));
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    protected void setBandWidth(Double bandWidth) {
        if (bandWidth == null) {
            double sigma = DiscreteStatistics.stdev(this.sample);
            this.bandWidth = sigma * Math.pow(this.N, -0.2);
        } else {
            this.bandWidth = bandWidth;
        }
    }

    @Override
    protected double evaluateKernel(double x) {
        double shape = x >= 2.0 * this.bandWidth ? x / this.bandWidth : 0.25 * Math.pow(x / this.bandWidth, 2.0) + 1.0;
        double scale = this.bandWidth;
        double pdf = 0.0;
        for (int i = 0; i < this.N; ++i) {
            pdf += Math.pow(this.sample[i], shape - 1.0) * Math.exp(-this.sample[i] / scale) / (Math.pow(scale, shape) * this.gamma(shape));
        }
        return pdf / (double)this.N;
    }

    private double gamma(double value) {
        return Gamma.gamma((double)value);
    }
}

