/*
 * Decompiled with CFR 0.152.
 */
package emc;

import fig.basic.LogInfo;
import java.util.List;
import java.util.Random;
import nuts.util.CollUtils;

public class StochasticMaps {
    private Random rand1;
    private Random rand2;
    private Integer s0;
    private List<Integer> s = CollUtils.list();
    private List<Integer> t = CollUtils.list();

    public StochasticMaps(int R, int K, int seed1, int seed2) {
        this.rand1 = new Random(seed1);
        this.rand2 = new Random(seed2);
        int numSeedsNeeded = (int)Math.ceil(Math.log10(R * K + 1) / Math.log10(2.0)) + 1;
        this.s0 = new Integer(this.rand1.nextInt());
        for (int i = 0; i < numSeedsNeeded; ++i) {
            this.s.add(this.rand1.nextInt());
            this.t.add(this.rand2.nextInt());
        }
    }

    public int getSamplingSeed(long id) {
        if (id == 1L) {
            return this.s0;
        }
        int currSeed = this.s0;
        long value = id;
        int length = 0;
        while (value > 0L) {
            value >>= 1;
            ++length;
        }
        long temp = 0L;
        for (int n = 0; n < length; ++n) {
            temp = id & (long)(1 << n);
            if ((temp >>= n) == 0L) {
                currSeed ^= this.s.get(n).intValue();
                continue;
            }
            if (temp == 1L) {
                currSeed ^= this.t.get(n).intValue();
                continue;
            }
            LogInfo.logs("Unrecoverable error: bug in the bit operation part");
            System.exit(-1);
        }
        return currSeed;
    }
}

