/*
 * Decompiled with CFR 0.152.
 */
package ev.poi.processors;

import ev.multi.Segmenter;
import ev.poi.PoissonModel;
import ev.poi.PoissonSampleProcessor;
import ev.poi.SampleContext;
import ev.poi.proposals.MSAProposal;
import ma.GreedyDecoder;
import nuts.util.CounterMap;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class CountEdgeProcessor
implements PoissonSampleProcessor {
    private final CounterMap<Segmenter.SegmentedCognateId, GreedyDecoder.Edge> edgeCounts = new CounterMap();
    private double nIters = 0.0;
    public SummaryStatistics acceptRate = new SummaryStatistics();

    @Override
    public void process(PoissonModel sample, SampleContext context) {
        if (context.proposal instanceof MSAProposal) {
            this.nIters += 1.0;
            MSAProposal prop = (MSAProposal)context.proposal;
            Segmenter.SegmentedCognateId sci = (Segmenter.SegmentedCognateId)prop.id;
            this.edgeCounts.getCounter(sci).incrementAll(sample.alignments.get(sci).edges(), 1.0);
            this.acceptRate.addValue(context.accepted ? 1.0 : 0.0);
        }
    }

    public CounterMap<Segmenter.SegmentedCognateId, GreedyDecoder.Edge> getEdgePosteriors() {
        if (this.nIters % (double)this.edgeCounts.keySet().size() != 0.0) {
            throw new RuntimeException("Seems like a bad sampling schedule");
        }
        double norm = this.nIters / (double)this.edgeCounts.keySet().size();
        CounterMap<Segmenter.SegmentedCognateId, GreedyDecoder.Edge> result = new CounterMap<Segmenter.SegmentedCognateId, GreedyDecoder.Edge>();
        for (Segmenter.SegmentedCognateId id : this.edgeCounts.keySet()) {
            for (GreedyDecoder.Edge e : this.edgeCounts.getCounter(id)) {
                double cur = this.edgeCounts.getCount(id, e) / norm;
                if (cur > 1.0 || cur < 0.0) {
                    throw new RuntimeException();
                }
                result.setCount(id, e, cur);
            }
        }
        return result;
    }
}

