/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.IOUtils;
import fig.basic.OrderedMap;
import fig.basic.Pair;
import fig.basic.Utils;
import fig.exec.servlet.ArgumentException;
import fig.exec.servlet.DirSource;
import fig.exec.servlet.Exceptions;
import fig.exec.servlet.Field;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.IndexFileItem;
import fig.exec.servlet.Item;
import fig.exec.servlet.ItemFactory;
import fig.exec.servlet.ItemsOpResponseParams;
import fig.exec.servlet.MyException;
import fig.exec.servlet.OperationRP;
import fig.exec.servlet.Permissions;
import fig.exec.servlet.ResponseElement;
import fig.exec.servlet.ResponseObject;
import fig.exec.servlet.ResponseParams;
import fig.exec.servlet.SaveItemsRP;
import fig.exec.servlet.SaveValuesRP;
import fig.exec.servlet.Trail;
import fig.exec.servlet.TrailException;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.Value;
import fig.html.HtmlCell;
import fig.html.HtmlRow;
import fig.html.HtmlTable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class View<ItemType extends Item>
extends Item {
    protected OrderedMap<String, ItemType> items = new OrderedMap();

    public ItemType getItem(String name) throws MyException {
        Item item = (Item)this.getItems().get(name);
        if (item == null) {
            throw new ArgumentException("Invalid name: " + name);
        }
        return (ItemType)item;
    }

    public ItemType getItemEasy(String name) {
        try {
            return this.getItem(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public OrderedMap<String, ? extends ItemType> getItems() {
        return this.items;
    }

    public Item getItem(Trail trail) throws TrailException {
        if (trail.atEnd()) {
            return this;
        }
        Item item = null;
        try {
            item = (Item)this.getItem(trail.getHead());
        }
        catch (MyException e) {
            throw TrailException.notFound(trail, e.getMessage());
        }
        if (trail.getTail().atEnd()) {
            return item;
        }
        if (!(item instanceof View)) {
            throw TrailException.notFound(trail, "expected a view, but got " + item);
        }
        return ((View)item).getItem(trail.getTail());
    }

    @Override
    protected Value getFieldValue(String name) throws MyException {
        if (name.equals("Count")) {
            return new Value(this.getItems().size());
        }
        return super.getFieldValue(name);
    }

    public abstract FieldListMap getItemsFields();

    public HtmlTable getItemsTable() throws MyException {
        FieldListMap fields = this.getItemsFields();
        HtmlTable table = new HtmlTable();
        table.setNoWrap(true);
        HtmlRow header = new HtmlRow();
        header.setIsHeader(true);
        HtmlCell cell = new HtmlCell("name");
        cell.setAttr("fieldName", "name");
        cell.setAttr("gloss", "Name");
        header.addCell(cell);
        for (Field field : fields.values()) {
            cell = this.fieldToCell(field, field.getName());
            cell.setAttr("fieldName", field.getName());
            cell.setAttr("gloss", field.getGloss());
            header.addCell(cell);
        }
        table.addRow(header);
        Pair<String, Boolean> sortSpec = this.getDefaultSortSpec();
        Field sortField = null;
        boolean reverse = false;
        if (sortSpec != null) {
            sortField = (Field)fields.get(sortSpec.getFirst());
            reverse = sortSpec.getSecond();
        }
        OrderedMap<String, ItemType> items = this.getItems();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (String name : items.keys()) {
            Item item = (Item)items.get(name);
            if (item.isHidden() || item.isDead()) continue;
            Object cmpKey = null;
            if (sortField != null) {
                String s;
                Value value = sortField.getValue(item);
                String string = s = value.cmpKey == null ? value.value : value.cmpKey;
                cmpKey = sortField.numeric ? Double.valueOf(Utils.parseDoubleEasy(s)) : (s == null ? "" : s);
            }
            item.setSent();
            entries.add(new Entry(name, item, (Comparable)cmpKey));
        }
        if (sortField != null) {
            Collections.sort(entries);
            if (reverse) {
                Collections.reverse(entries);
            }
        }
        for (Entry entry : entries) {
            String name = entry.name;
            Item item = entry.item;
            HtmlRow row = new HtmlRow();
            row.setAttr("itemName", name);
            if (item instanceof View) {
                row.setAttr("isView");
            }
            String dividerStr = "<hr color=\"darkblue\">";
            row.addCell(item.isDivider() ? "<hr color=\"darkblue\">" : name);
            for (Field field : fields.values()) {
                Value value = item.isDivider() ? new Value("<hr color=\"darkblue\">") : field.getValue(item);
                cell = new HtmlCell(value.value);
                if (value.cmpKey != null) {
                    cell.setAttr("cmpKey", value.cmpKey);
                }
                row.addCell(cell);
            }
            table.addRow(row);
        }
        return table;
    }

    protected boolean useNumbering() {
        return false;
    }

    protected String itemToName(OrderedMap<String, ItemType> items, ItemType item) {
        if (((Item)item).isDivider()) {
            return ((Item)item).getDividerName();
        }
        return this.useNumbering() ? "" + items.size() : ((Item)item).getTrail().getName();
    }

    public void addSave(ItemType item) throws MyException {
        this.addAllSave(Collections.singletonList(item));
    }

    public void addAllSave(List<ItemType> srcItems) throws MyException {
        IndexFileItem fileItem = Exceptions.cast(this.source.getFileItem(this.getGroundedIndexPath()), IndexFileItem.class);
        for (Item item : srcItems) {
            this.addItem(this.items, item);
            String spec = this.itemToSpec(item);
            if (spec == null) continue;
            fileItem.addToList(spec);
        }
        fileItem.save();
    }

    protected File getGroundedIndexPath() {
        return null;
    }

    public void saveItems(SaveItemsRP req, ResponseParams resp) throws MyException {
        File groundedPath = this.getGroundedIndexPath();
        if (groundedPath == null) {
            throw Exceptions.unsupported("saveItems", this.getTrail());
        }
        OrderedMap newItems = new OrderedMap();
        String[] itemNames = req.getItems();
        for (String itemName : itemNames) {
            Item item = (Item)this.items.get(itemName);
            this.addItem(newItems, item);
        }
        for (String itemName : this.items.keys()) {
            Item item = (Item)this.items.get(itemName);
            if (item.isDivider() || item.hasSent() || newItems.containsKey(itemName)) continue;
            this.addItem(newItems, item);
            resp.put(itemName, "NEW");
        }
        this.items = newItems;
        IndexFileItem fileItem = Exceptions.cast(this.source.getFileItem(groundedPath), IndexFileItem.class);
        fileItem.setList(this.getSpecList());
        fileItem.save();
    }

    private List<String> getSpecList() throws MyException {
        return this.getSpecList(this.items);
    }

    private List<String> getSpecList(OrderedMap<String, ItemType> items) throws MyException {
        ArrayList<String> specs = new ArrayList<String>();
        for (Item item : items.values()) {
            String spec = this.itemToSpec(item);
            if (spec == null) continue;
            specs.add(spec);
        }
        return specs;
    }

    public void saveValues(SaveValuesRP req) throws MyException {
        req.doOperation(this.getItems(), this.getItemsFields());
    }

    @Override
    public ResponseObject handleOperation(OperationRP req, Permissions perm) throws MyException {
        String op = req.getOp();
        if (op.equals("childOp")) {
            String childOp = req.getReq("childOp");
            req.setOp(childOp);
            if (req.containsKey("childItem")) {
                ItemType item = this.getItem(req.getReq("childItem"));
                return ((Item)item).handleOperation(req, perm);
            }
            if (req.containsKey("childItems")) {
                String[] childItemNames = req.getStringListReq("childItems");
                ItemsOpResponseParams resp = new ItemsOpResponseParams(childOp);
                for (String childItemName : childItemNames) {
                    try {
                        ItemType item = this.getItem(childItemName);
                        ResponseObject childResp = ((Item)item).handleOperation(req, perm);
                        if (childResp instanceof ResponseParams) {
                            resp.setSuccess(childItemName, ((ResponseParams)childResp).getMsg());
                            continue;
                        }
                        resp.setSuccess(childItemName, childResp.toString());
                    }
                    catch (MyException e) {
                        resp.setFailed(childItemName, e.getMessage());
                    }
                }
                return resp.finish();
            }
            throw new ArgumentException("Either childItem or childItems required");
        }
        if (op.equals("getItemsTable")) {
            this.updateMeNow(req.getUpdateSpec());
            String name = (String)req.get("name");
            HtmlTable table = this.getItemsTable();
            return new ResponseElement(this.putInBlock(table, name, op));
        }
        if (op.equals("saveItems")) {
            perm.checkCanModify();
            SaveItemsRP saveReq = new SaveItemsRP(req);
            ResponseParams resp = new ResponseParams("Saved " + saveReq);
            this.saveItems(saveReq, resp);
            return resp;
        }
        if (op.equals("saveValues")) {
            perm.checkCanModify();
            SaveValuesRP saveReq = new SaveValuesRP(req);
            this.saveValues(saveReq);
            return new ResponseParams("Saved " + saveReq);
        }
        if (op.equals("addItem")) {
            Trail srcTrail = new Trail(req.getReq("srcTrail"));
            Item srcItem = this.source.getDomainView().getItem(srcTrail);
            this.addSave(srcItem);
            return new ResponseParams("Added " + srcTrail + " to " + this);
        }
        if (op.equals("addItems")) {
            Trail srcTrail = new Trail(req.getReq("srcTrail"));
            View srcView = Exceptions.cast(this.source.getDomainView().getItem(srcTrail), View.class);
            ArrayList<Item> srcItems = new ArrayList<Item>();
            for (Item item : srcView.getItems().values()) {
                srcItems.add(item);
            }
            this.addAllSave(srcItems);
            return new ResponseParams("Added " + srcTrail + " to " + this);
        }
        if (op.equals("newItem")) {
            String name = req.getReq("name");
            if (this.items.containsKey(name)) {
                throw new ArgumentException("Name " + name + " already exists in " + this);
            }
            ItemType item = this.newItem(name);
            if (item == null) {
                throw Exceptions.unsupported("newItem", this.getTrail());
            }
            this.addSave(item);
            return new ResponseParams("Created new " + item + " in " + this);
        }
        return super.handleOperation(req, perm);
    }

    protected ItemType newItem(String name) {
        return null;
    }

    protected ItemType newDividerItem() {
        return null;
    }

    public void updateChildren(UpdateSpec spec, UpdateQueue.Priority priority) {
        spec.getQueue().merge(this.getPrioritizedItems(priority));
    }

    protected void updateItemsFromDir(DirSource source, int depth, DirSource.TraverseSpec spec, ItemFactory<ItemType> factory, boolean stripExt) throws MyException {
        OrderedMap<String, ItemType> newItems = new OrderedMap<String, ItemType>();
        List<String> childNames = source.getChildren(depth, spec);
        Iterator<String> iterator = childNames.iterator();
        while (iterator.hasNext()) {
            Object item;
            String childName;
            String fileName = childName = iterator.next();
            if (stripExt) {
                childName = IOUtils.stripFileExt(childName);
            }
            if ((item = this.getItemEasy(childName)) == null || ((Item)item).isDead()) {
                item = (Item)factory.newItem(this.childTrail(childName), source, fileName);
            }
            newItems.put(childName, item);
        }
        this.items = newItems;
    }

    protected String itemToSpec(ItemType item) throws MyException {
        if (((Item)item).isDivider()) {
            return ((Item)item).getDividerName();
        }
        return ((Item)item).getTrail().getName();
    }

    protected String specToName(String spec) throws MyException {
        return spec;
    }

    protected ItemType specToItem(String spec) throws MyException {
        String name = this.specToName(spec);
        if (this.items.containsKey(name)) {
            return (ItemType)((Item)this.items.get(name));
        }
        return this.newItem(spec);
    }

    private ItemType specToItemEasy(String spec) {
        try {
            return this.specToItem(spec);
        }
        catch (MyException e) {
            return null;
        }
    }

    protected void updateItemsFromFile(UpdateSpec updateSpec, FileSource source) throws MyException {
        this.updateItemsFromFile(updateSpec, Collections.EMPTY_LIST, source, Collections.EMPTY_LIST);
    }

    protected void updateItemsFromFile(UpdateSpec updateSpec, List<? extends ItemType> prependItems, FileSource source, List<? extends ItemType> appendItems) throws MyException {
        IndexFileItem fileItem = Exceptions.cast(source.getFileItem(this.getGroundedIndexPath()), IndexFileItem.class);
        fileItem.update(updateSpec, UpdateQueue.Priority.HIGH);
        OrderedMap newItems = new OrderedMap();
        for (Item item : prependItems) {
            this.addItem(newItems, item);
        }
        for (String spec : fileItem.getList()) {
            ItemType item = this.specToItemEasy(spec);
            this.addItem(newItems, item);
        }
        for (Item item : appendItems) {
            this.addItem(newItems, item);
        }
        this.items = newItems;
    }

    protected void addItemHard(ItemType item) {
        try {
            this.addItem(this.items, item);
        }
        catch (MyException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addItem(ItemType item) throws MyException {
        this.addItem(this.items, item);
    }

    protected void addItem(OrderedMap<String, ItemType> items, ItemType item) throws MyException {
        if (item == null && (item = this.newDividerItem()) == null) {
            throw new MyException("Can't create a divider");
        }
        if (((Item)item).isDead()) {
            return;
        }
        items.put(this.itemToName(items, item), item);
    }

    protected Pair<String, Boolean> getDefaultSortSpec() {
        return null;
    }

    public UpdateQueue getPrioritizedItems(UpdateQueue.Priority priority) {
        UpdateQueue queue = new UpdateQueue();
        for (Item item : this.getItems().values()) {
            queue.enqueue(item, priority);
        }
        return queue;
    }

    private static class Entry
    implements Comparable<Entry> {
        public final String name;
        public final Item item;
        public final Comparable cmpKey;

        public Entry(String name, Item item, Comparable cmpKey) {
            this.name = name;
            this.item = item;
            this.cmpKey = cmpKey;
        }

        @Override
        public int compareTo(Entry e) {
            return this.cmpKey.compareTo(e.cmpKey);
        }
    }
}

