/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import goblin.HLParams;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import nuts.maxent.BaseMeasures;
import pepper.Encodings;

public class HLBaseMeasures
implements BaseMeasures<HLParams.HLContext, HLParams.HLOutcome> {
    private static final long serialVersionUID = 1L;
    public final Encodings enc;
    private final SortedSet<HLParams.HLOutcome> allButSpecial;
    private final SortedSet<HLParams.HLOutcome> allButBound;

    public HLBaseMeasures(Encodings enc) {
        this.enc = enc;
        TreeSet<HLParams.HLOutcome> allButSpecial = new TreeSet<HLParams.HLOutcome>();
        TreeSet<HLParams.HLOutcome> allButBound = new TreeSet<HLParams.HLOutcome>();
        for (int i = 0; i < enc.getNumberOfPhonemes() + 1; ++i) {
            if (i != HLParams.specialOutcomeCode(enc)) {
                allButSpecial.add(new HLParams.HLOutcome(enc, i));
            }
            if (i == enc.getBoundaryPhoneId()) continue;
            allButBound.add(new HLParams.HLOutcome(enc, i));
        }
        this.allButSpecial = Collections.unmodifiableSortedSet(allButSpecial);
        this.allButBound = Collections.unmodifiableSortedSet(allButBound);
    }

    @Override
    public SortedSet<HLParams.HLOutcome> support(HLParams.HLContext input) {
        if (input == null || this.enc == null) {
            throw new RuntimeException();
        }
        if (input.top == this.enc.getBoundaryPhoneId() && input.type == HLParams.ChoiceType.SUBDEL) {
            throw new RuntimeException("Args do not make sense in HLBaseMeasures.support()");
        }
        if (input.type == HLParams.ChoiceType.ROOT) {
            return this.allButSpecial;
        }
        return this.allButBound;
    }
}

