/*
 * Decompiled with CFR 0.152.
 */
package marking;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import marking.Comment;
import marking.EvaluatedQuestion;
import marking.Grader;
import marking.GraderCreator;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.math.StatisticsMap;
import nuts.tui.Table;
import nuts.util.CollUtils;
import nuts.util.Counter;

public class Grade
implements Runnable {
    @Option(required=true)
    public File assignmentFolder;
    @Option
    public String sidFile = "student-ids.txt";
    @Option(required=true)
    public String gradingScheme;
    @Option
    public boolean publish = false;
    @Option
    public String publishFolder = "/Users/bouchard/Documents/courses/stat547-fa2011/web/stat547-fa2011/comments";
    @Option
    public ArrayList<String> latexLibraries = new ArrayList<String>(Arrays.asList("/Users/bouchard/w/stat547c-latex/files/basic-math-macros.tex", "/Users/bouchard/w/stat547c-latex/files/typesetting-macros.tex"));
    @Option
    public String latexTemplate = "/Users/bouchard/w/stat547c-latex/files/grading-template.tex";
    private File latex = null;
    private List<String> template;
    private String cleanedName;
    public static Random rand = new Random();

    public static void main(String[] args) {
        IO.run(args, new Grade());
    }

    @Override
    public void run() {
        this.cleanedName = "" + Character.toUpperCase(this.assignmentFolder.getName().charAt(0));
        String truncName = this.assignmentFolder.getName().substring(1);
        this.cleanedName = this.cleanedName + StringUtils.selectFirstRegex("^([^0-9]*).*$", truncName);
        this.cleanedName = this.cleanedName + " ";
        this.cleanedName = this.cleanedName + StringUtils.selectFirstRegex("^[^0-9]*([0-9]*)$", truncName);
        CommentDescriptions cd = new CommentDescriptions(this.assignmentFolder);
        StudentComments sc = new StudentComments(this.assignmentFolder);
        Comment.AllStudents as = new Comment.AllStudents(new File(this.sidFile));
        Comment.backup(this.assignmentFolder);
        IO.cp(new File(this.gradingScheme), new File(Execution.getFile("grading-scheme.txt")));
        GraderCreator gc = new GraderCreator();
        Grader grader = gc.createGrader(new File(this.gradingScheme), cd.allIds());
        StatisticsMap<String> sm = new StatisticsMap<String>();
        this.latex = new File(Execution.getFile("latex"));
        this.latex.mkdir();
        for (String lib : this.latexLibraries) {
            IO.cp(new File(lib), this.latex);
        }
        this.template = IO.f2l(new File(this.latexTemplate));
        Table table = new Table();
        int r = 1;
        for (String string : as.ids) {
            Counter<String> indics = sc.indicatorsForSID(string);
            table.set(0, 0, "student-id");
            table.set(r, 0, string);
            if (indics.totalCount() == 0.0) {
                LogInfo.warning("Warning: no comment on " + string + "... ignoring it in statistics and all output.");
            } else {
                List<EvaluatedQuestion> evaluatedQs = grader.evaluate(indics);
                this.createLatex(string, evaluatedQs, cd, sc);
                for (int i = 0; i < evaluatedQs.size(); ++i) {
                    int c = i + 1;
                    EvaluatedQuestion eq = evaluatedQs.get(i);
                    String qdescr = eq.questionIdentification;
                    if (table.get(0, c) != null && !table.get(0, c).equals("") && !qdescr.equals(table.get(0, c))) {
                        throw new RuntimeException("" + table.get(0, c) + " vs " + qdescr);
                    }
                    table.set(0, c, qdescr);
                    table.set(r, c, eq.value);
                    sm.addValue(qdescr, eq.value);
                    if (r != as.ids.size()) continue;
                    table.set(r + 1, c, sm.mean(qdescr));
                }
            }
            ++r;
        }
        LogInfo.logs(table.toString());
        IO.writeToDisk(new File(Execution.getFile("grades.csv")), table.toCSV(true));
        IO.writeToDisk(new File(Execution.getFile("grades.html")), table.toHTML(true));
        ArrayList<File> latexFiles = CollUtils.list();
        for (File f : IO.ls(this.latex, "tex")) {
            if (!f.getName().matches("^[0-9]+[.]tex$")) continue;
            IO.call("pdflatex " + f.getName(), "x\nx\nx\nx\nx\nx\n", IO.ResultCodeBehavior.WARN, 10000L, this.latex);
            latexFiles.add(new File(f.getParent(), f.getName().replaceAll("[.]tex$", ".pdf")));
        }
        if (this.publish) {
            File file = new File(this.publishFolder);
            if (!file.isDirectory()) {
                throw new RuntimeException("Should be a dir:" + file.getAbsolutePath());
            }
            File markedSoftLink = new File(this.assignmentFolder, "marked");
            Grade.preventOverwrite(markedSoftLink);
            File srcSoftLink = new File(Execution.getVirtualExecDir());
            IOUtils.createSymLink(srcSoftLink.getAbsolutePath(), markedSoftLink.getAbsolutePath());
            File assignmentWebDest = new File(file, this.assignmentFolder.getName());
            Grade.preventOverwrite(assignmentWebDest);
            assignmentWebDest.mkdir();
            File htaccess = new File(assignmentWebDest, ".htaccess");
            PrintWriter pw = IOUtils.openOutHard(htaccess);
            pw.append("IndexIgnore *\n<FilesMatch \"^.*.pdf$\">\nOrder deny,allow\nDeny from all\nAllow from ubc.ca\n</FilesMatch>\n");
            pw.close();
            LogInfo.track("Copying files");
            for (File latexFile : latexFiles) {
                LogInfo.logs("cp " + latexFile.getAbsolutePath() + " " + assignmentWebDest.getAbsolutePath());
                if (!assignmentWebDest.exists()) {
                    System.out.println("Error does not exists:" + assignmentWebDest.getAbsolutePath());
                }
                IO.call("cp " + latexFile.getAbsolutePath() + " " + assignmentWebDest);
            }
            LogInfo.end_track();
        }
    }

    public static void preventOverwrite(File f) {
        if (!f.exists()) {
            return;
        }
        String newName = f.getName() + "-" + System.currentTimeMillis() + "-" + rand.nextLong();
        File dest = new File(f.getParent(), newName);
        if (dest.exists()) {
            throw new RuntimeException();
        }
        f.renameTo(dest);
    }

    private void createLatex(String sid, List<EvaluatedQuestion> evaluatedQs, CommentDescriptions cd, StudentComments sc) {
        Table grades = new Table();
        grades.set(0, 0, "Question");
        grades.set(0, 1, "Full formula");
        grades.set(0, 2, "Value");
        int c = 1;
        for (EvaluatedQuestion eq : evaluatedQs) {
            grades.set(c, 0, this.cleanQID(eq.questionIdentification));
            grades.set(c, 1, eq.formula);
            grades.set(c, 2, eq.value);
            ++c;
        }
        String cleanedId = sid.substring(1, sid.length());
        PrintWriter out = IOUtils.openOutHard(new File(this.latex, cleanedId + ".tex"));
        for (String line : this.template) {
            if (line.contains("$template:title")) {
                out.append(this.cleanedName + "\n");
                continue;
            }
            if (line.contains("$template:sid")) {
                out.append(cleanedId + "\n");
                continue;
            }
            if (line.contains("$template:grade")) {
                out.append(grades.toLatex());
                continue;
            }
            if (line.contains("$template:comments")) {
                out.append(this.comments(sid, cd, sc) + '\n');
                continue;
            }
            out.append(line + "\n");
        }
        out.close();
    }

    private String cleanQID(String qid) {
        return qid.replaceAll("^q", "");
    }

    private String comments(String sid, CommentDescriptions cd, StudentComments sc) {
        StringBuilder result = new StringBuilder();
        for (String qid : cd.sortedQuestions()) {
            result.append("\\subsection*{" + (this.cleanQID(qid).contains("ummary") ? "" : "Question ") + this.cleanQID(qid) + "}\n");
            StringBuilder sub = new StringBuilder();
            for (String cid : cd.sortedCIDs(qid)) {
                if (!sc.isAssociated(sid, cid)) continue;
                sub.append("\\item[" + cid + ":]\n");
                sub.append("" + cd.getDescription(cid) + "\n");
                sub.append(sc.getSpecificComment(sid, cid) + "\n");
            }
            if (sub.length() == 0) {
                result.append("Good work!\n");
                continue;
            }
            result.append("\\begin{description}\n" + sub.toString() + "\\end{description}");
        }
        return result.toString();
    }

    public static class CommentDescriptions {
        public static final String CID = "comment-id";
        public static final String QID = "question-id";
        public static final String DESC = "description";
        public PrintWriter fileOut;
        private final File directory;
        public Map<String, String> descriptions;
        public Map<String, Map<String, String>> question2descriptions;
        public int maxId = -1;

        public CommentDescriptions(File directory) {
            this.directory = directory;
            this.fileOut = IOUtils.openOutAppendHard(Comment.getCDFile(directory));
            this.load();
        }

        public String getDescription(String cid) {
            return this.descriptions.get(cid);
        }

        public Set<String> allIds() {
            return this.descriptions.keySet();
        }

        private int peekNextId() {
            return this.maxId + 1;
        }

        public String add(String questionId, String description) {
            String newId = "c" + this.peekNextId();
            if (description == null) {
                description = "";
            }
            this._add(newId, questionId, description);
            this.fileOut.append("\n" + CSV.body(newId, questionId, description));
            this.fileOut.flush();
            return newId;
        }

        private void _add(String idStr, String qId, String descr) {
            int curId = Integer.parseInt(idStr.substring(1, idStr.length()));
            this.maxId = Math.max(this.maxId, curId);
            this.descriptions.put(idStr, descr);
            ((Map)CollUtils.getNoNull(this.question2descriptions, qId, new HashMap())).put(idStr, descr);
        }

        private void load() {
            this.descriptions = CollUtils.map();
            this.question2descriptions = CollUtils.map();
            for (Map<String, String> line : IO.iCSVMap(Comment.getCDFile(this.directory))) {
                String cid = line.get(CID);
                String qid = line.get(QID);
                String desc = line.get(DESC);
                if (qid == null || qid.equals("") || qid.charAt(0) != 'q') {
                    throw new RuntimeException();
                }
                if (cid == null || cid.equals("") || cid.charAt(0) != 'c') {
                    throw new RuntimeException();
                }
                if (desc == null) {
                    desc = "";
                }
                this._add(cid, qid, desc);
            }
            if (this.isEmpty()) {
                this.createHeader();
            }
        }

        private void createHeader() {
            this.fileOut.append(CSV.header(CID, QID, DESC) + "\n");
            this.fileOut.flush();
        }

        public boolean isEmpty() {
            if (!Comment.getCDFile(this.directory).exists()) {
                return true;
            }
            for (String line : IO.i(Comment.getCDFile(this.directory))) {
                if (line.matches("^\\s*$")) continue;
                return false;
            }
            return true;
        }

        public void close() {
            this.fileOut.close();
        }

        public boolean containsQuestionId(String qid) {
            return this.question2descriptions.keySet().contains(qid);
        }

        public Set<String> allQuestionId() {
            return this.question2descriptions.keySet();
        }

        public boolean checkAssociated(String cur_qid, String cid) {
            if (!this.question2descriptions.containsKey(cur_qid)) {
                return false;
            }
            return this.question2descriptions.get(cur_qid).keySet().contains(cid);
        }

        public List<String> sortedQuestions() {
            ArrayList<String> result = CollUtils.list(this.question2descriptions.keySet());
            Collections.sort(result);
            return result;
        }

        public List<String> sortedCIDs(String qid) {
            ArrayList<String> result = CollUtils.list(this.question2descriptions.get(qid).keySet());
            Collections.sort(result);
            return result;
        }

        public String toString(String qid) {
            StringBuilder result = new StringBuilder();
            if (this.question2descriptions.containsKey(qid)) {
                ArrayList<Pair> sorted = CollUtils.list();
                for (String cid : this.question2descriptions.get(qid).keySet()) {
                    sorted.add(Pair.makePair(cid, this.question2descriptions.get(qid).get(cid)));
                }
                Collections.sort(sorted, new Comparator<Pair<String, String>>(){

                    @Override
                    public int compare(Pair<String, String> arg0, Pair<String, String> arg1) {
                        return arg0.getFirst().compareTo(arg1.getFirst());
                    }
                });
                for (Pair item : sorted) {
                    result.append("" + (String)item.getFirst() + "\t" + (String)item.getSecond() + "\n");
                }
            }
            return result.toString();
        }
    }

    public static class StudentComments {
        public static final String SID = "student-id";
        public static final String NOTE = "notes";
        public PrintWriter fileOut;
        private final File directory;
        public Map<String, Map<String, String>> associations;

        public StudentComments(File directory) {
            this.directory = directory;
            this.fileOut = IOUtils.openOutAppendHard(Comment.getSCFile(directory));
            this.load();
        }

        public String getSpecificComment(String sid, String cid) {
            return this.associations.get(sid).get(cid);
        }

        public boolean isAssociated(String sid, String cid) {
            if (!this.associations.containsKey(sid)) {
                return false;
            }
            return this.associations.get(sid).containsKey(cid);
        }

        public Counter<String> indicatorsForSID(String sid) {
            Counter<String> result = new Counter<String>();
            if (this.associations.containsKey(sid)) {
                for (String cid : this.associations.get(sid).keySet()) {
                    result.setCount(cid, 1.0);
                }
            }
            return result;
        }

        public boolean add(String sid, String cid, String note) {
            Map<String, String> currentMap = this.getCID2Note(sid);
            if (currentMap.keySet().contains(cid)) {
                return false;
            }
            if (note == null) {
                note = "";
            }
            currentMap.put(cid, note);
            this.fileOut.append("\n" + CSV.body(sid, cid, note));
            this.fileOut.flush();
            return true;
        }

        private Map<String, String> getCID2Note(String sid) {
            return CollUtils.getNoNull(this.associations, sid, new HashMap());
        }

        private void load() {
            this.associations = CollUtils.map();
            for (Map<String, String> line : IO.iCSVMap(Comment.getSCFile(this.directory))) {
                String sid = line.get(SID);
                String cid = line.get("comment-id");
                String note = line.get(NOTE);
                if (sid == null || sid.equals("") || sid.charAt(0) != 's') {
                    throw new RuntimeException();
                }
                if (cid == null || cid.equals("") || cid.charAt(0) != 'c') {
                    throw new RuntimeException();
                }
                if (note == null) {
                    note = "";
                }
                this.getCID2Note(sid).put(cid, note);
            }
            if (this.isEmpty()) {
                this.createHeader();
            }
        }

        private void createHeader() {
            this.fileOut.append(CSV.header(SID, "comment-id", NOTE) + "\n");
            this.fileOut.flush();
        }

        public boolean isEmpty() {
            if (!Comment.getSCFile(this.directory).exists()) {
                return true;
            }
            for (String line : IO.i(Comment.getSCFile(this.directory))) {
                if (line.matches("^\\s*$")) continue;
                return false;
            }
            return true;
        }

        public void close() {
            this.fileOut.close();
        }
    }
}

