/*
 * Decompiled with CFR 0.152.
 */
package nuts.remote;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.StrUtils;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.remote.JarCreator;
import nuts.util.CollUtils;
import nuts.util.RemoteUtils;

public class LaunchLargeExperiment
implements Runnable {
    private final String main;
    private final List<File> pbsFiles = CollUtils.list();
    private final List<String> remoteCmds = CollUtils.list();
    @Option
    public String remotePath = "/opt/torque/bin/:/global/software/torque/bin/:/opt/bin/:/usr/local/bin/:/opt/bin:/opt/openmpi/bin:/usr/local/bin:/usr/kerberos/bin:/global/software/intel/ictce/3.2.2.013/bin:/global/software/intel/impi/3.2.2.006/bin64:/global/software/intel/itac/7.2.2.006/bin:/global/software/intel/Compiler/11.1/059/bin/intel64:/global/software/intel/Compiler/11.1/059/bin/intel64:/opt/globus-4.2.1/bin:/opt/globus-4.2.1/bin:/opt/globus-4.2.1/sbin:/usr/bin:/bin:/usr/sbin:/sbin/:/home/bouchard/bin/mrbayes-3.1.2/:/home/bouchard/bin/phylip-3.67/exe/:/home/bouchard/bin/jdk1.6.0_24/bin/:/eecs/bouchard/bin/phylo/phylip-3.67/exe:/home/eecs/bouchard/bin/mrbayes-3.1.2/:/home/eecs/bouchard/bin/java/jdk1.6.0_22-x64/bin/:/global/software/R-3.0.1-2-rh6/bin/";
    @Option
    public String memoryPerInstance = "6g";
    @Option
    public String wallTime = "72:00:00";
    @Option
    public String cput = "864000";
    @Option(required=true)
    public String remoteDirectory;
    @Option(required=true)
    public String remoteHost;
    @Option
    public String coresPerInstance = "";
    public static final File LAUNCH_EXECS = new File("state", "launched");
    public static final String REMOTE_EXECS = "remote-execs";
    public static final String PBS_FILES = "pbs-files";
    public static final String JAR_DEST_FOLDER = "launchedJars";
    private PrintWriter remoteExecs = null;
    private List<String> remoteExecsList = CollUtils.list();
    private File jarFile = null;
    private final List remoteArguments = new ArrayList();
    private final Map<Bookmark, Set<String>> toExpand = CollUtils.map();
    public static final Pattern idPattern = Pattern.compile("([0-9]+)[.].*");
    private int seg = 0;

    public LaunchLargeExperiment(String main, List<String> remoteArguments) {
        this.main = main;
        for (int i = 0; i < remoteArguments.size(); ++i) {
            String item = remoteArguments.get(i);
            if (item.contains(",")) {
                this.remoteArguments.add(this.addItemToExpand(item, remoteArguments.get(i - 1).replace("-", "")));
                continue;
            }
            this.remoteArguments.add(item);
        }
    }

    private Bookmark addItemToExpand(String item, String prev) {
        Bookmark bookmark = new Bookmark(prev);
        HashSet expansions = CollUtils.set();
        for (String subItem : item.split("[,]")) {
            expansions.add(subItem);
        }
        this.toExpand.put(bookmark, expansions);
        return bookmark;
    }

    public static void main(String[] args) {
        List<String> secondOptionBlock;
        String main;
        List<String> firstOptionBlock;
        try {
            List<String> options = Arrays.asList(args);
            int index = options.indexOf(":");
            firstOptionBlock = options.subList(0, index);
            main = options.get(index + 1);
            secondOptionBlock = options.subList(index + 2, options.size());
        }
        catch (Exception e) {
            System.err.println("Usage: java ev.ex.LaunchLargeExperiment [-option value]* : package.class [options]");
            return;
        }
        String[] firstBlockArray = new String[firstOptionBlock.size()];
        for (int i = 0; i < firstBlockArray.length; ++i) {
            firstBlockArray[i] = firstOptionBlock.get(i);
        }
        IO.run(firstBlockArray, new LaunchLargeExperiment(main, secondOptionBlock));
    }

    @Override
    public void run() {
        if (this.remoteDirectory.charAt(0) != '/') {
            throw new RuntimeException("Argument remote directory should be an absolute path");
        }
        this.jarFile = new File(Execution.getFile("classpath-" + System.currentTimeMillis() + ".jar"));
        JarCreator jc = new JarCreator(this.jarFile);
        jc.addCurrentClassPath();
        if (jc.isEmpty()) {
            throw new RuntimeException("Class path was considered empty ('.' is ignored)");
        }
        try {
            RemoteUtils.scp(this.jarFile, this.remoteHost, this.remoteDirectory + "/" + JAR_DEST_FOLDER + "/");
        }
        catch (Exception e) {
            try {
                ArrayList<String> cmds = CollUtils.list();
                cmds.add("mkdir " + this.remoteDirectory);
                cmds.add("mkdir " + this.remoteDirectory + "/state");
                cmds.add("mkdir " + this.remoteDirectory + "/state/execs");
                cmds.add("mkdir " + this.remoteDirectory + "/" + JAR_DEST_FOLDER);
                cmds.add("mkdir " + this.remoteDirectory + "/" + PBS_FILES);
                RemoteUtils.remoteBash(this.remoteHost, cmds);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new RuntimeException("Check if " + this.remoteDirectory + " is writeable on the remote host " + this.remoteHost);
            }
            RemoteUtils.scp(this.jarFile, this.remoteHost, this.remoteDirectory + "/" + JAR_DEST_FOLDER + "/");
        }
        this.remoteCmds.add("export PATH=$PATH:" + this.remotePath);
        this.remoteCmds.add("cd " + this.remoteDirectory);
        LogInfo.logsForce(this.toString(this.remoteArguments));
        this.remoteExecs = IOUtils.openOutHard(Execution.getFile(REMOTE_EXECS));
        this.run(this.toExpand, new HashMap<Bookmark, String>());
        this.remoteExecs.close();
        LogInfo.track("Starting jobs");
        LogInfo.logsForce("Sending off pbs files");
        RemoteUtils.scp(this.pbsFiles, this.remoteHost, this.remoteDirectory + "/" + PBS_FILES);
        LogInfo.logsForce("Executing qsub cmds");
        String response = RemoteUtils.remoteBash(this.remoteHost, this.remoteCmds);
        LogInfo.logsForce("Response:\n" + response);
        ArrayList ids = CollUtils.list();
        for (String line : response.split("\n")) {
            if (!idPattern.matcher(line).matches()) continue;
            ids.add(StringUtils.selectFirstRegex(idPattern, line));
        }
        IO.writeToDisk(Execution.getFile("job-ids"), StrUtils.join(ids, "\n"));
        LogInfo.end_track();
        PrintWriter out = IOUtils.openOutAppendHard(LAUNCH_EXECS);
        out.println("" + Execution.getVirtualExecDir());
        out.close();
    }

    public String toString(List remoteArguments) {
        StringBuilder remoteArgs = new StringBuilder();
        StringBuilder subs = new StringBuilder();
        int i = 1;
        for (Object item : remoteArguments) {
            if (item instanceof String) {
                remoteArgs.append(item + " ");
                continue;
            }
            remoteArgs.append("$" + i + " ");
            subs.append("$" + i++ + "=" + this.toExpand.get(item) + " ");
        }
        return "Remote arguments:" + remoteArgs + "\nValues: " + subs;
    }

    public void run(Map<Bookmark, Set<String>> toExpand, Map<Bookmark, String> expanded) {
        if (toExpand.size() == 0) {
            this.run(expanded);
        } else {
            Bookmark variableName = CollUtils.pick(toExpand.keySet());
            for (String value : toExpand.get(variableName)) {
                HashMap<Bookmark, Set<String>> recToExp = CollUtils.map(toExpand);
                recToExp.remove(variableName);
                HashMap<Bookmark, String> recExp = CollUtils.map(expanded);
                recExp.put(variableName, value);
                this.run(recToExp, recExp);
            }
        }
    }

    public void run(Map<Bookmark, String> expanded) {
        LogInfo.track("Preparing " + expanded);
        List<String> expendedRemoteArguments = this.substitute(expanded);
        String currentExecFolder = "gp" + new File(Execution.getVirtualExecDir()).getName().replace(".exec", "") + ".seg" + this.seg + ".time" + System.currentTimeMillis() + ".exec";
        this.remoteCmds.add("mkdir state/execs/" + currentExecFolder);
        File pbsFile = this.createPbsFile(expendedRemoteArguments, currentExecFolder);
        this.qsub(pbsFile, currentExecFolder);
        LogInfo.end_track();
    }

    private List<String> substitute(Map<Bookmark, String> expanded) {
        ArrayList<String> result = CollUtils.list();
        for (Object item : this.remoteArguments) {
            if (item instanceof String) {
                result.add((String)item);
                continue;
            }
            result.add(expanded.get(item));
        }
        return result;
    }

    private void qsub(File pbsFile, String currentExecFolder) {
        String remotePbsDirectory = this.remoteDirectory + "/" + PBS_FILES;
        String remotePbsFile = remotePbsDirectory + "/" + pbsFile.getName();
        this.pbsFiles.add(pbsFile);
        String str = "qsub -l cput=" + this.cput + ",walltime=" + this.wallTime + ",mem=" + this.memoryPerInstance + (this.coresPerInstance == null || this.coresPerInstance.equals("") ? "" : ",nodes=1:ppn=" + this.coresPerInstance) + " -e state/execs/" + currentExecFolder + " -o state/execs/" + currentExecFolder + " " + remotePbsFile;
        LogInfo.logs("Command: " + str);
        this.remoteCmds.add(str);
    }

    private File createPbsFile(List<String> remoteArguments, String currentExecFolder) {
        File f = new File(Execution.getFile("pbs-" + currentExecFolder));
        PrintWriter out = IOUtils.openOutHard(f);
        out.println("#!/bin/bash");
        out.println("#PBS -S /bin/bash");
        out.println("cd " + this.remoteDirectory);
        out.println("export CLASSPATH=" + this.remoteDirectory + "/" + JAR_DEST_FOLDER + "/" + this.jarFile.getName() + "\nexport PATH=$PATH:" + this.remotePath + "\n");
        this.remoteExecs.println(currentExecFolder);
        this.remoteExecsList.add(currentExecFolder);
        LogInfo.logsForce("currentRemoteExecFolder: " + currentExecFolder);
        out.println("java  -server -Xmx" + this.memoryPerInstance + " " + this.main + " " + StrUtils.join(remoteArguments, " ") + " -execName " + currentExecFolder);
        out.close();
        ++this.seg;
        return f;
    }

    private static class Bookmark {
        private final String desc;

        public Bookmark(String str) {
            this.desc = str;
        }

        public String toString() {
            return this.desc;
        }
    }
}

