/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

public class EasyFormat {
    private static DecimalFormat stdFormat = null;

    public static DecimalFormat getStdFormat() {
        if (stdFormat == null) {
            DecimalFormatSymbols dsymb = new DecimalFormatSymbols();
            dsymb.setDecimalSeparator('.');
            stdFormat = new DecimalFormat("0.0000");
            stdFormat.setDecimalFormatSymbols(dsymb);
        }
        return stdFormat;
    }

    public static String std(double number) {
        return EasyFormat.getStdFormat().format(number);
    }

    public static String fmt(double number) {
        return EasyFormat.std(number);
    }

    public static String fmt(List<Double> numbers) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (int i = 0; i < numbers.size(); ++i) {
            result.append(EasyFormat.fmt(numbers.get(i)));
            if (i == numbers.size() - 1) continue;
            result.append(" ");
        }
        result.append("]");
        return result.toString();
    }

    public static String fmt2(double x) {
        if (x == 0.0) {
            return "0";
        }
        if (Math.abs(x) < 0.001) {
            return String.format(Locale.US, "%.3e", x);
        }
        return String.format(Locale.US, "%.5f", x);
    }
}

