/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nuts.io.Extensions;
import nuts.io.IO;
import nuts.lang.StringUtils;

public class CompareLL {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println("Usage: [xpdir 1] [xpdir 2] [number of iters]");
            return;
        }
        String xpFile0 = args[0];
        String xpFile1 = args[1];
        String itersString = args[2];
        int iters = Integer.parseInt(itersString);
        for (int i = 0; i < iters; ++i) {
            List<Double> xp0 = CompareLL.logLL(xpFile0 + "/derivations." + Extensions.extension2String(i));
            List<Double> xp1 = CompareLL.logLL(xpFile1 + "/derivations." + Extensions.extension2String(i));
            double llxp0 = 0.0;
            double llxp1 = 0.0;
            assert (xp0.size() == xp1.size());
            for (int j = 0; j < xp0.size(); ++j) {
                if (xp0.get(j) == null || xp1.get(j) == null || xp0.get(j) == Double.NaN || xp0.get(j) == Double.NEGATIVE_INFINITY || xp0.get(j) == Double.POSITIVE_INFINITY || xp1.get(j) == Double.NaN || xp1.get(j) == Double.NEGATIVE_INFINITY || xp1.get(j) == Double.POSITIVE_INFINITY) continue;
                llxp0 += xp0.get(j).doubleValue();
                llxp1 += xp1.get(j).doubleValue();
            }
            System.out.println(xpFile0 + ": " + llxp0);
            System.out.println(xpFile1 + ": " + llxp1);
            System.out.println(xpFile0 + "-" + xpFile1 + ": " + (llxp0 - llxp1));
        }
    }

    public static List<Double> logLL(String file) throws IOException {
        ArrayList<Double> result = new ArrayList<Double>();
        for (String line : IO.i(file)) {
            if (!line.matches("[=]+.*[=]+")) continue;
            if (line.contains("Stalled")) {
                result.add(null);
                continue;
            }
            String ll = StringUtils.selectRegex(".*LogLhood[:] ([^ ]+) [|].*", line).get(0);
            result.add(Double.parseDouble(ll));
        }
        return result;
    }
}

