/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ICSILanguageModel {
    private Map<List<String>, Double> logProbabilities = new HashMap<List<String>, Double>();
    private Map<List<String>, Double> backOffs = new HashMap<List<String>, Double>();
    private double unkLogPr = Double.NEGATIVE_INFINITY;
    private String nGramFilePath;
    private List<String> unknownKeywordPhrase = null;
    private int maxN;

    public ICSILanguageModel(String nGramFilePath, String unknownKeyword, int maxN) {
        this.maxN = maxN;
        if (unknownKeyword == null) {
            unknownKeyword = "<unk>";
        }
        this.nGramFilePath = nGramFilePath;
        BufferedReader nGramReader = IOUtils.openInHard(nGramFilePath);
        ARPAFormatParser parser = new ARPAFormatParser(nGramReader);
        this.unknownKeywordPhrase = this.createUnknownKeywordPhrase(unknownKeyword);
        try {
            parser.parse();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ARPAParserException e) {
            throw new RuntimeException(e);
        }
    }

    public ICSILanguageModel(String path) {
        this(path, "<unk>", 3);
    }

    public int getMaxN() {
        return this.maxN;
    }

    public double score(List<String> nGram) {
        Double logPr = this.logProbabilities.get(nGram);
        if (logPr != null) {
            return logPr;
        }
        if (nGram.size() > 1) {
            List<String> tail = nGram.subList(1, nGram.size());
            List<String> head = nGram.subList(0, nGram.size() - 1);
            return this.getBackOff(head) + this.score(tail);
        }
        return this.unkLogPr;
    }

    protected List<String> createUnknownKeywordPhrase(String keyword) {
        return Collections.singletonList(keyword);
    }

    protected double getBackOff(List<String> phrase) {
        Double b = this.backOffs.get(phrase);
        return b == null ? 0.0 : b;
    }

    protected class ARPAParserException
    extends Exception {
        private static final long serialVersionUID = -2025827985646156639L;

        public ARPAParserException() {
        }

        public ARPAParserException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }

        public ARPAParserException(String arg0) {
            super(arg0);
        }

        public ARPAParserException(Throwable arg0) {
            super(arg0);
        }
    }

    protected class ARPAFormatParser {
        private BufferedReader reader;
        private int currentNGramLength = 1;
        int currentNGramCount = 0;
        private int lineNumber = 1;

        protected String readLine() throws IOException {
            ++this.lineNumber;
            return this.reader.readLine();
        }

        ARPAFormatParser(BufferedReader reader) {
            this.reader = reader;
        }

        protected void parse() throws IOException, ARPAParserException {
            LogInfo.track("Parsing ARPA language model file: " + ICSILanguageModel.this.nGramFilePath);
            this.parseHeader();
            this.parseNGrams();
            LogInfo.end_track();
        }

        protected void parseHeader() throws IOException, ARPAParserException {
            while (this.reader.ready()) {
                if (!this.readLine().contains("\\1-grams:")) continue;
                return;
            }
            throw new ARPAParserException("\"\\1-grams: expected (line " + this.lineNumber + ")");
        }

        protected void parseNGrams() throws IOException, ARPAParserException {
            while (this.reader.ready()) {
                String line = this.readLine();
                if (line.length() == 0) continue;
                if (line.charAt(0) == '\\') {
                    LogInfo.logs(this.currentNGramCount + " " + this.currentNGramLength + "-gram read.");
                    ++this.currentNGramLength;
                    this.currentNGramCount = 0;
                    continue;
                }
                this.parseLine(line);
            }
            if (this.currentNGramLength - 1 != ICSILanguageModel.this.getMaxN()) {
                LogInfo.error("Warning: the max size of the n-grams extracted from the file " + ICSILanguageModel.this.nGramFilePath + " do not match the specified maxNGramLength.");
            }
        }

        protected void parseLine(String line) throws ARPAParserException {
            String[] columns = line.split("\t");
            if (columns.length < 2) {
                throw new ARPAParserException("Every entry should have at least 2 columns (line " + this.lineNumber + ")");
            }
            if (columns.length > 3) {
                throw new ARPAParserException("Every entry should have no more than 3 columns (line " + this.lineNumber + ")");
            }
            List<String> nGram = this.parseNGram(columns[1]);
            try {
                double logProbability = Double.parseDouble(columns[0]);
                if (nGram.equals(ICSILanguageModel.this.unknownKeywordPhrase)) {
                    ICSILanguageModel.this.unkLogPr = logProbability;
                } else {
                    ICSILanguageModel.this.logProbabilities.put(nGram, logProbability);
                    if (columns.length == 3) {
                        double backOff = Double.parseDouble(columns[2]);
                        ICSILanguageModel.this.backOffs.put(nGram, backOff);
                    }
                }
                ++this.currentNGramCount;
            }
            catch (NumberFormatException e) {
                throw new ARPAParserException("Number expected at line " + this.lineNumber);
            }
        }

        private List<String> parseNGram(String string) {
            ArrayList<String> result = new ArrayList<String>();
            String[] words = string.split(" ");
            for (int i = 0; i < words.length; ++i) {
                result.add(words[i]);
            }
            return result;
        }
    }
}

