/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.models;

import nuts.math.TrapezoidLogSpaceIntegrator;
import nuts.util.MathUtils;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.distribution.GammaDistributionImpl;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.apache.commons.math.special.Gamma;
import pty.smc.models.VarianceMarginalUtils;

public class Tet {
    public double logGammaDensity(double x, double a, double b) {
        double y = (a - 1.0) * Math.log(x) - b * x + a * Math.log(b) - Gamma.logGamma((double)a);
        return y;
    }

    public double logNormalDensity(double x, double a, double b) {
        double y = -Math.pow(x - a, 2.0) / (2.0 * b) - 0.5 * Math.log(Math.PI * 2 * b);
        return y;
    }

    public void compareDensityApproximations(double a, double b, double m) {
        int i;
        double[] x = new double[1000];
        for (i = 0; i < x.length; ++i) {
            x[i] = (double)i * 0.05;
        }
        for (i = 0; i < x.length; ++i) {
            double n = (m - 2.0) / 2.0;
            double ygamma = this.logGammaDensity((n + x[i] * Math.sqrt(n)) / b, n, 0.5 * b) + 0.5 * (Math.log(n) - Math.log(b * b));
            double ynormal = this.logNormalDensity(x[i], 0.0, 1.0);
            System.out.println("gamma = " + ygamma + "\tnormal = " + ynormal);
        }
    }

    public double numericalIntegrate(double a, double b, double m, double c) {
        double i;
        TrapezoidLogSpaceIntegrator trap = new TrapezoidLogSpaceIntegrator(new GIGLogDensity(b, a, 0.5 * m - 1.0));
        try {
            i = trap.integrate(0.0, 1.0 / c);
            m = MathUtils.nint(m);
            System.out.println("p=" + (0.5 * m - 1.0) + "m=" + m);
            double lognorm = Math.log(2.0) + VarianceMarginalUtils.logModifiedBesselSecondKind(0.5 * m - 1.0, Math.sqrt(a * b)) - 0.25 * (m - 2.0) * (Math.log(b) - Math.log(a));
            i -= lognorm;
        }
        catch (Exception e) {
            System.out.println("error");
            e.printStackTrace();
            i = -1.0;
        }
        return i;
    }

    public double analyticalIntegrateNormal(double a, double b, double m, double c) {
        double result = 0.0;
        NormalDistributionImpl normal = new NormalDistributionImpl((m - 2.0) / b, Math.sqrt(2.0 * (m - 2.0)) / b);
        try {
            result += Math.log(normal.cumulativeProbability(0.0, 1.0 / c));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public double analyticalIntegrateGamma(double a, double b, double m, double c) {
        double result;
        GammaDistributionImpl gamma = new GammaDistributionImpl(0.5 * m - 1.0, 1.0 / (0.5 * b));
        try {
            result = Math.log(gamma.cumulativeProbability(0.0, 1.0 / c));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = -1.0;
        }
        return result;
    }

    public void compareIntegralApproximations(double a, double b, double m) {
        int i;
        double[] c = new double[10];
        for (i = 0; i < c.length; ++i) {
            c[i] = (double)(i + 1) * 0.05;
        }
        for (i = 0; i < c.length; ++i) {
            double numerical = 0.0;
            double gamma = this.analyticalIntegrateGamma(a, b, m, c[i]);
            double normal = this.analyticalIntegrateNormal(a, b, m, c[i]);
            double normal0 = this.analyticalIntegrateNormal(a, b, m, 0.0);
            double normal2 = Tet.normalcdf2((1.0 / c[i] - (m - 2.0) / b) / Math.sqrt(2.0 * (m - 2.0)) / b);
            double normal20 = Tet.normalcdf2(-(m - 2.0) / b / Math.sqrt(2.0 * (m - 2.0)) / b);
            normal2 = Math.log(normal2 - normal20);
            double zorder = this.logGammaDensity(1.0 / c[i], 0.5 * (m - 2.0), 0.5 * b) + 1.0 / c[i];
            System.out.println("c = " + c[i] + "\tNumerical = " + numerical + "\tGamma approximation = " + gamma + "\tNormal approximation = " + normal2 + "\tzorder = " + zorder);
        }
    }

    public static double normalcdf1(double x) {
        double p0 = 1.253314137;
        double a = 0.212023887;
        double b = 0.28245512;
        double x2 = x * x;
        double y = Math.pow(p0 * x, 2.0) + Math.exp(-0.5 * x2) * Math.sqrt(1.0 + b * x2) / (1.0 + a * x2);
        y = Math.exp(-0.5 * x2) - Math.sqrt(y);
        y = p0 + y / x;
        return y;
    }

    public static double normalcdf2(double x) {
        double y = 0.07056 * Math.pow(x, 3.0) + 1.5976 * x;
        y = 1.0 / (1.0 + Math.exp(-y));
        return y;
    }

    public static double normalcdf3(double x) {
        double y = 1.702 * x;
        y = 1.0 / (1.0 + Math.exp(y));
        return y;
    }

    public static void main(String[] args) {
        System.out.println("Running Test");
        try {
            Tet t = new Tet();
            t.compareIntegralApproximations(1.0, 1.0, 999.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class GIGLogDensity
    implements UnivariateRealFunction {
        double a;
        double b;
        double m;

        public GIGLogDensity(double a, double b, double m) {
            this.a = a;
            this.b = b;
            this.m = m;
        }

        public double value(double x) {
            return -this.b / x - this.a * x + (this.m - 1.0) * Math.log(x);
        }
    }

    private class GIGDensity
    implements UnivariateRealFunction {
        double a;
        double b;
        double m;

        public GIGDensity(double a, double b, double m) {
            this.a = a;
            this.b = b;
            this.m = m;
        }

        public double value(double x) {
            return Math.exp(-this.b / x - this.a * x) * Math.pow(x, this.m - 1.0);
        }
    }
}

