/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.quantum;

import JSci.maths.Complex;
import JSci.maths.algebras.Module;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.MathVector;
import JSci.maths.vectors.VectorDimensionException;
import JSci.physics.quantum.BraVector;
import JSci.physics.quantum.Operator;

public final class KetVector
extends MathVector {
    private AbstractComplexVector representation;

    public KetVector(AbstractComplexVector abstractComplexVector) {
        super(abstractComplexVector.dimension());
        this.representation = abstractComplexVector;
    }

    public boolean equals(Object object) {
        return this.representation.equals(((KetVector)object).representation);
    }

    public String toString() {
        return this.representation.toString();
    }

    public int hashCode() {
        return this.representation.hashCode();
    }

    public BraVector toBraVector() {
        return new BraVector(this.representation.conjugate());
    }

    public AbstractComplexVector getRepresentation() {
        return this.representation;
    }

    public double norm() {
        return this.representation.norm();
    }

    public Object getSet() {
        return this.representation.getSet();
    }

    public AbelianGroup.Member negate() {
        return this.representation.negate();
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof KetVector) {
            return this.add((KetVector)member);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public KetVector add(KetVector ketVector) {
        return new KetVector(this.representation.add(ketVector.representation));
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof KetVector) {
            return this.subtract((KetVector)member);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public KetVector subtract(KetVector ketVector) {
        return new KetVector(this.representation.subtract(ketVector.representation));
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        return this.representation.scalarMultiply(member);
    }

    public Operator multiply(BraVector braVector) {
        int n = this.dimension();
        if (n == braVector.dimension()) {
            AbstractComplexVector abstractComplexVector = braVector.getRepresentation();
            Complex[][] complexArray = new Complex[n][n];
            for (int i = 0; i < n; ++i) {
                complexArray[i][0] = this.representation.getComponent(i).multiply(abstractComplexVector.getComponent(0));
                for (int j = 1; j < n; ++j) {
                    complexArray[i][j] = this.representation.getComponent(i).multiply(abstractComplexVector.getComponent(j));
                }
            }
            return new Operator(new ComplexSquareMatrix(complexArray));
        }
        throw new VectorDimensionException("Vectors have different dimensions.");
    }
}

