/*
 * Decompiled with CFR 0.152.
 */
package conifer.ml.extractors;

import conifer.ml.AnnotatedCharacter;
import conifer.ml.extractors.BivariateFeatureExtractor;
import conifer.ml.extractors.UnivariateFeatureExtractor;
import fig.basic.UnorderedPair;
import nuts.util.Counter;

public class CategoryCollapsedFeatureExtractor
implements UnivariateFeatureExtractor<AnnotatedCharacter>,
BivariateFeatureExtractor<AnnotatedCharacter> {
    private final boolean isFirstCategoryInvariant;

    public CategoryCollapsedFeatureExtractor(boolean isFirstCategoryInvariant) {
        this.isFirstCategoryInvariant = isFirstCategoryInvariant;
    }

    @Override
    public void extract(Counter counts, AnnotatedCharacter state) {
        counts.incrementCount(this.prefix() + state.observedChar, 1.0);
    }

    @Override
    public void extract(Counter counts, AnnotatedCharacter state1, AnnotatedCharacter state2) {
        int category = state1.category;
        if (this.isFirstCategoryInvariant && category == 0) {
            return;
        }
        counts.incrementCount(this.prefix() + new UnorderedPair<Character, Character>(Character.valueOf(state1.observedChar), Character.valueOf(state2.observedChar)), 1.0);
    }

    private String prefix() {
        return this.toString() + ":";
    }

    public String toString() {
        return "categoryCollapsed";
    }
}

