/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public abstract class KernelDensityEstimatorDistribution
implements Distribution {
    protected int N;
    protected double lowerBound;
    protected double upperBound;
    protected double bandWidth;
    protected double[] sample;

    public KernelDensityEstimatorDistribution(Double[] sample, Double lowerBound, Double upperBound, Double bandWidth) {
        this.sample = new double[sample.length];
        for (int i = 0; i < sample.length; ++i) {
            this.sample[i] = sample[i];
        }
        this.N = sample.length;
        this.processBounds(lowerBound, upperBound);
        this.setBandWidth(bandWidth);
    }

    protected abstract double evaluateKernel(double var1);

    protected abstract void processBounds(Double var1, Double var2);

    protected abstract void setBandWidth(Double var1);

    @Override
    public double pdf(double x) {
        return this.evaluateKernel(x);
    }

    @Override
    public double logPdf(double x) {
        return Math.log(this.pdf(x));
    }

    @Override
    public double cdf(double x) {
        throw new RuntimeException("Not Implemented.");
    }

    @Override
    public double quantile(double y) {
        throw new RuntimeException("Not Implemented.");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not Implemented.");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not Implemented.");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not Implemented.");
    }

    public double getBandWidth() {
        return this.bandWidth;
    }

    public static enum Type {
        GAUSSIAN("Gaussian"),
        GAMMA("Gamma"),
        LOGTRANSFORMEDGAUSSIAN("LogTransformedGaussian"),
        BETA("Beta");

        private final String text;

        private Type(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static Type parseFromString(String text) {
            for (Type format : Type.values()) {
                if (format.getText().compareToIgnoreCase(text) != 0) continue;
                return format;
            }
            return null;
        }
    }
}

