/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;

public class TruncatedDistribution
extends AbstractContinuousDistribution
implements Distribution {
    private UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double x) {
            return TruncatedDistribution.this.pdf(x);
        }

        @Override
        public final double getLowerBound() {
            return TruncatedDistribution.this.lower;
        }

        @Override
        public final double getUpperBound() {
            return TruncatedDistribution.this.upper;
        }
    };
    private final Distribution source;
    private final double lower;
    private final double upper;
    private final double normalization;
    private final double lowerCDF;

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public TruncatedDistribution(Distribution source, double lower, double upper) {
        this.source = source;
        if (lower == upper) {
            throw new IllegalArgumentException("upper equals lower");
        }
        if (source.getProbabilityDensityFunction().getLowerBound() > lower) {
            lower = source.getProbabilityDensityFunction().getLowerBound();
        }
        if (source.getProbabilityDensityFunction().getUpperBound() < upper) {
            upper = source.getProbabilityDensityFunction().getUpperBound();
        }
        this.lower = lower;
        this.upper = upper;
        this.lowerCDF = !Double.isInfinite(this.lower) ? source.cdf(lower) : 0.0;
        this.normalization = !Double.isInfinite(this.upper) ? source.cdf(upper) - this.lowerCDF : 1.0 - this.lowerCDF;
    }

    @Override
    public double pdf(double x) {
        if (x >= this.upper && x < this.lower) {
            return 0.0;
        }
        return this.source.pdf(x) / this.normalization;
    }

    @Override
    public double logPdf(double x) {
        return Math.log(this.pdf(x));
    }

    @Override
    public double cdf(double x) {
        double cdf = x < this.lower ? 0.0 : (x >= this.lower && x < this.upper ? (this.source.cdf(x) - this.lowerCDF) / this.normalization : 1.0);
        return cdf;
    }

    @Override
    public double quantile(double y) {
        if (y == 0.0) {
            return this.lower;
        }
        if (y == 1.0) {
            return this.upper;
        }
        if (Double.isInfinite(this.lower) && Double.isInfinite(this.upper)) {
            return this.source.quantile(y);
        }
        try {
            return super.inverseCumulativeProbability(y);
        }
        catch (MathException e) {
            return Double.NaN;
        }
    }

    @Override
    public double mean() {
        if (this.source != null) {
            return this.source.mean();
        }
        throw new IllegalArgumentException("Distribution is null");
    }

    @Override
    public double variance() {
        if (this.source != null) {
            return this.source.variance();
        }
        throw new IllegalArgumentException("Distribution is null");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    protected double getInitialDomain(double v) {
        if (!Double.isInfinite(this.lower) && !Double.isInfinite(this.upper)) {
            return (this.upper + this.lower) / 2.0;
        }
        if (!Double.isInfinite(this.upper)) {
            return this.upper / 2.0;
        }
        if (!Double.isInfinite(this.lower)) {
            return this.lower * 2.0;
        }
        return v;
    }

    protected double getDomainLowerBound(double v) {
        return this.lower;
    }

    protected double getDomainUpperBound(double v) {
        return this.upper;
    }

    public double cumulativeProbability(double v) throws MathException {
        return this.cdf(v);
    }
}

