/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.LUPDecomposition;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.NonSymmetricComponents;

public class SymmetricMatrix
extends Matrix {
    private static int lupCRLCriticalDimension = 36;

    public SymmetricMatrix(double[][] a) {
        super(a);
    }

    public SymmetricMatrix(int n) throws NegativeArraySizeException {
        super(n, n);
    }

    public SymmetricMatrix(int n, int m) throws NegativeArraySizeException {
        super(n, m);
    }

    public SymmetricMatrix add(SymmetricMatrix a) throws IllegalDimension {
        return new SymmetricMatrix(this.addComponents(a));
    }

    private SymmetricMatrix crlInverse() throws ArithmeticException {
        if (this.rows() == 1) {
            return this.inverse1By1();
        }
        if (this.rows() == 2) {
            return this.inverse2By2();
        }
        Matrix[] splitMatrices = this.split();
        SymmetricMatrix b1 = (SymmetricMatrix)splitMatrices[0].inverse();
        Matrix cb1 = splitMatrices[2].secureProduct(b1);
        SymmetricMatrix cb1cT = new SymmetricMatrix(cb1.productWithTransposedComponents(splitMatrices[2]));
        splitMatrices[1] = ((SymmetricMatrix)splitMatrices[1]).secureSubtract(cb1cT).inverse();
        splitMatrices[2] = splitMatrices[1].secureProduct(cb1);
        splitMatrices[0] = b1.secureAdd(new SymmetricMatrix(cb1.transposedProductComponents(splitMatrices[2])));
        return SymmetricMatrix.join(splitMatrices);
    }

    public static SymmetricMatrix fromComponents(double[][] comp) throws IllegalDimension, NonSymmetricComponents {
        if (comp.length != comp[0].length) {
            throw new IllegalDimension("Non symmetric components: a " + comp.length + " by " + comp[0].length + " matrix cannot be symmetric");
        }
        for (int i = 0; i < comp.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (comp[i][j] == comp[j][i]) continue;
                throw new NonSymmetricComponents("Non symmetric components: a[" + i + "][" + j + "]= " + comp[i][j] + ", a[" + j + "][" + i + "]= " + comp[j][i]);
            }
        }
        return new SymmetricMatrix(comp);
    }

    public static SymmetricMatrix identityMatrix(int n) {
        double[][] a = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                a[i][j] = 0.0;
            }
            a[i][i] = 1.0;
        }
        return new SymmetricMatrix(a);
    }

    @Override
    public Matrix inverse() throws ArithmeticException {
        return this.rows() < lupCRLCriticalDimension ? new SymmetricMatrix(new LUPDecomposition(this).inverseMatrixComponents()) : this.crlInverse();
    }

    private SymmetricMatrix inverse1By1() {
        double[][] newComponents = new double[1][1];
        newComponents[0][0] = 1.0 / this.components[0][0];
        return new SymmetricMatrix(newComponents);
    }

    private SymmetricMatrix inverse2By2() {
        double[][] newComponents = new double[2][2];
        double inverseDeterminant = 1.0 / (this.components[0][0] * this.components[1][1] - this.components[0][1] * this.components[1][0]);
        newComponents[0][0] = inverseDeterminant * this.components[1][1];
        newComponents[1][1] = inverseDeterminant * this.components[0][0];
        double d = -inverseDeterminant * this.components[1][0];
        newComponents[1][0] = d;
        newComponents[0][1] = d;
        return new SymmetricMatrix(newComponents);
    }

    private static SymmetricMatrix join(Matrix[] a) {
        int j;
        int i;
        int p = a[0].rows();
        int n = p + a[1].rows();
        double[][] newComponents = new double[n][n];
        for (i = 0; i < p; ++i) {
            for (j = 0; j < p; ++j) {
                newComponents[i][j] = a[0].components[i][j];
            }
            for (j = p; j < n; ++j) {
                double d = -a[2].components[j - p][i];
                newComponents[j][i] = d;
                newComponents[i][j] = d;
            }
        }
        for (i = p; i < n; ++i) {
            for (j = p; j < n; ++j) {
                newComponents[i][j] = a[1].components[i - p][j - p];
            }
        }
        return new SymmetricMatrix(newComponents);
    }

    private int largestPowerOf2SmallerThan(int n) {
        int m = 2;
        int m2;
        while ((m2 = 2 * m) < n) {
            m = m2;
        }
        return m;
    }

    @Override
    public Matrix product(double a) {
        return new SymmetricMatrix(this.productComponents(a));
    }

    public SymmetricMatrix product(SymmetricMatrix a) throws IllegalDimension {
        return new SymmetricMatrix(this.productComponents(a));
    }

    public SymmetricMatrix productWithTransposed(SymmetricMatrix a) throws IllegalDimension {
        if (a.columns() != this.columns()) {
            throw new IllegalDimension("Operation error: cannot multiply a " + this.rows() + " by " + this.columns() + " matrix with the transpose of a " + a.rows() + " by " + a.columns() + " matrix");
        }
        return new SymmetricMatrix(this.productWithTransposedComponents(a));
    }

    protected SymmetricMatrix secureAdd(SymmetricMatrix a) {
        return new SymmetricMatrix(this.addComponents(a));
    }

    protected SymmetricMatrix secureProduct(SymmetricMatrix a) {
        return new SymmetricMatrix(this.productComponents(a));
    }

    protected SymmetricMatrix secureSubtract(SymmetricMatrix a) {
        return new SymmetricMatrix(this.subtractComponents(a));
    }

    private Matrix[] split() {
        int j;
        int i;
        int n = this.rows();
        int p = this.largestPowerOf2SmallerThan(n);
        int q = n - p;
        double[][] a = new double[p][p];
        double[][] b = new double[q][q];
        double[][] c = new double[q][p];
        for (i = 0; i < p; ++i) {
            for (j = 0; j < p; ++j) {
                a[i][j] = this.components[i][j];
            }
            for (j = p; j < n; ++j) {
                c[j - p][i] = this.components[i][j];
            }
        }
        for (i = p; i < n; ++i) {
            for (j = p; j < n; ++j) {
                b[i - p][j - p] = this.components[i][j];
            }
        }
        Matrix[] answer = new Matrix[]{new SymmetricMatrix(a), new SymmetricMatrix(b), new Matrix(c)};
        return answer;
    }

    public SymmetricMatrix subtract(SymmetricMatrix a) throws IllegalDimension {
        return new SymmetricMatrix(this.subtractComponents(a));
    }

    @Override
    public Matrix transpose() {
        return this;
    }

    public SymmetricMatrix transposedProduct(SymmetricMatrix a) throws IllegalDimension {
        if (a.rows() != this.rows()) {
            throw new IllegalDimension("Operation error: cannot multiply a tranposed " + this.rows() + " by " + this.columns() + " matrix with a " + a.rows() + " by " + a.columns() + " matrix");
        }
        return new SymmetricMatrix(this.transposedProductComponents(a));
    }
}

