/*
 * Decompiled with CFR 0.152.
 */
package dr.stats;

import dr.stats.Variate;

public class Regression {
    private Variate.D xData = null;
    private Variate.D yData = null;
    private boolean forceOrigin = false;
    private boolean regressionKnown = false;
    private double gradient;
    private double intercept;
    private double covariance;
    private double sumResidualsSquared;
    private double residualMeanSquared;
    private double correlationCoefficient;

    public Regression() {
    }

    public Regression(Variate xData, Variate yData) {
        this.setData(xData, yData);
    }

    public Regression(double[] xData, double[] yData) {
        this.setData(xData, yData);
    }

    public Regression(Variate xData, Variate yData, boolean forceOrigin) {
        this.setData(xData, yData);
        this.setForceOrigin(forceOrigin);
    }

    public Regression(double[] xData, double[] yData, boolean forceOrigin) {
        this.setData(xData, yData);
        this.setForceOrigin(forceOrigin);
    }

    public void setData(double[] xData, double[] yData) {
        Variate.D xd = new Variate.D();
        Variate.D yd = new Variate.D();
        for (int i = 0; i < xData.length; ++i) {
            xd.add(xData[i]);
            yd.add(yData[i]);
        }
        this.xData = xd;
        this.yData = yd;
        this.regressionKnown = false;
    }

    public void setData(Variate xData, Variate yData) {
        this.xData = (Variate.D)xData;
        this.yData = (Variate.D)yData;
        this.regressionKnown = false;
    }

    public void setForceOrigin(boolean forceOrigin) {
        this.forceOrigin = forceOrigin;
        this.regressionKnown = false;
    }

    public double getGradient() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.gradient;
    }

    public double getIntercept() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.intercept;
    }

    public double getYIntercept() {
        return this.getIntercept();
    }

    public double getXIntercept() {
        return -this.getIntercept() / this.getGradient();
    }

    public double getCovariance() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.covariance;
    }

    public double getResidualMeanSquared() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.residualMeanSquared;
    }

    public double getSumResidualsSquared() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.sumResidualsSquared;
    }

    public double getCorrelationCoefficient() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.correlationCoefficient;
    }

    public double getRSquared() {
        if (!this.regressionKnown) {
            this.calculateRegression();
        }
        return this.correlationCoefficient * this.correlationCoefficient;
    }

    public double getResidual(double x, double y) {
        return y - (this.getGradient() * x + this.getIntercept());
    }

    public double getX(double y) {
        return (y - this.getIntercept()) / this.getGradient();
    }

    public double getY(double x) {
        return x * this.getGradient() + this.getIntercept();
    }

    public Variate.N getXData() {
        return this.xData;
    }

    public Variate.N getYData() {
        return this.yData;
    }

    public Variate getYResidualData() {
        Variate.D rd = new Variate.D();
        for (int i = 0; i < this.xData.getCount(); ++i) {
            rd.add(this.getResidual((Double)this.xData.get(i), (Double)this.yData.get(i)));
        }
        return rd;
    }

    private void calculateRegression() {
        int i;
        int n = this.xData.getCount();
        double meanX = 0.0;
        double meanY = 0.0;
        if (!this.forceOrigin) {
            meanX = this.xData.getMean();
            meanY = this.yData.getMean();
        }
        double sumProducts = 0.0;
        double sumSquareX = 0.0;
        double sumSquareY = 0.0;
        for (i = 0; i < n; ++i) {
            double x1 = (Double)this.xData.get(i) - meanX;
            double y1 = (Double)this.yData.get(i) - meanY;
            sumProducts += x1 * y1;
            sumSquareX += x1 * x1;
            sumSquareY += y1 * y1;
        }
        this.gradient = sumProducts / sumSquareX;
        this.intercept = meanY - this.gradient * meanX;
        this.covariance = sumProducts / (double)(n - 1);
        this.correlationCoefficient = sumProducts / Math.sqrt(sumSquareX * sumSquareY);
        this.sumResidualsSquared = 0.0;
        for (i = 0; i < n; ++i) {
            double residual = (Double)this.yData.get(i) - (this.gradient * (Double)this.xData.get(i) + this.intercept);
            this.sumResidualsSquared += residual * residual;
        }
        this.residualMeanSquared = this.sumResidualsSquared / (double)(n - 2);
        this.regressionKnown = true;
    }
}

