/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.ComparableDouble;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.Random;
import java.util.Vector;

public class HeapSort {
    public static void sort(AbstractList array, int[] indices) {
        int j;
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        int n = array.size();
        for (j = n / 2; j > 0; --j) {
            HeapSort.adjust(array, indices, j, n);
        }
        for (j = n - 1; j > 0; --j) {
            int temp = indices[0];
            indices[0] = indices[j];
            indices[j] = temp;
            HeapSort.adjust(array, indices, 1, j);
        }
    }

    public static void sort(AbstractList array) {
        int j;
        int n = array.size();
        for (j = n / 2; j > 0; --j) {
            HeapSort.adjust(array, j, n);
        }
        for (j = n - 1; j > 0; --j) {
            Object temp = array.get(0);
            array.set(0, array.get(j));
            array.set(j, temp);
            HeapSort.adjust(array, 1, j);
        }
    }

    public static void sort(Comparable[] array) {
        int j;
        int n = array.length;
        for (j = n / 2; j > 0; --j) {
            HeapSort.adjust(array, j, n);
        }
        for (j = n - 1; j > 0; --j) {
            Comparable temp = array[0];
            array[0] = array[j];
            array[j] = temp;
            HeapSort.adjust(array, 1, j);
        }
    }

    public static void sort(Object[] array, Comparator c) {
        int j;
        int n = array.length;
        for (j = n / 2; j > 0; --j) {
            HeapSort.adjust(array, c, j, n);
        }
        for (j = n - 1; j > 0; --j) {
            Object temp = array[0];
            array[0] = array[j];
            array[j] = temp;
            HeapSort.adjust(array, c, 1, j);
        }
    }

    public static void sort(double[] array) {
        int j;
        int n = array.length;
        for (j = n / 2; j > 0; --j) {
            HeapSort.adjust(array, j, n);
        }
        for (j = n - 1; j > 0; --j) {
            double temp = array[0];
            array[0] = array[j];
            array[j] = temp;
            HeapSort.adjust(array, 1, j);
        }
    }

    public static void sortAbs(double[] array) {
        int j;
        int n = array.length;
        for (j = n / 2; j > 0; --j) {
            HeapSort.adjustAbs(array, j, n);
        }
        for (j = n - 1; j > 0; --j) {
            double temp = array[0];
            array[0] = array[j];
            array[j] = temp;
            HeapSort.adjustAbs(array, 1, j);
        }
    }

    public static void sort(double[] array, int[] indices) {
        int j;
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        int n = indices.length;
        for (j = n / 2; j > 0; --j) {
            HeapSort.adjust(array, indices, j, n);
        }
        for (j = n - 1; j > 0; --j) {
            int temp = indices[0];
            indices[0] = indices[j];
            indices[j] = temp;
            HeapSort.adjust(array, indices, 1, j);
        }
    }

    public static void main(String[] args) {
        int i;
        int i2;
        int testSize = 100;
        Comparable[] test = new ComparableDouble[testSize];
        Random random = new Random();
        for (int i3 = 0; i3 < test.length; ++i3) {
            test[i3] = new ComparableDouble(random.nextInt(testSize * 10));
        }
        HeapSort.sort(test);
        for (Comparable aTest : test) {
            System.out.print(aTest + " ");
        }
        System.out.println();
        Vector<ComparableDouble> testv = new Vector<ComparableDouble>();
        int[] indices = new int[testSize];
        for (i2 = 0; i2 < testSize; ++i2) {
            testv.addElement(new ComparableDouble(random.nextInt(testSize * 10)));
        }
        HeapSort.sort(testv, indices);
        for (i2 = 0; i2 < test.length; ++i2) {
            System.out.print(testv.elementAt(indices[i2]) + " ");
        }
        System.out.println();
        double[] testd = new double[testSize];
        for (i = 0; i < testSize; ++i) {
            testd[i] = random.nextInt(testSize * 10);
        }
        HeapSort.sort(testd, indices);
        for (i = 0; i < test.length; ++i) {
            System.out.print(testd[indices[i]] + " ");
        }
        System.out.println();
    }

    private static void adjust(AbstractList<Comparable> array, int[] indices, int lower, int upper) {
        int j = lower;
        for (int k = lower * 2; k <= upper; k *= 2) {
            if (k < upper && array.get(indices[k - 1]).compareTo(array.get(indices[k])) < 0) {
                ++k;
            }
            if (array.get(indices[j - 1]).compareTo(array.get(indices[k - 1])) < 0) {
                int temp = indices[j - 1];
                indices[j - 1] = indices[k - 1];
                indices[k - 1] = temp;
            }
            j = k;
        }
    }

    private static void adjust(AbstractList array, int lower, int upper) {
        int j = lower;
        for (int k = lower * 2; k <= upper; k *= 2) {
            if (k < upper && ((Comparable)array.get(k - 1)).compareTo(array.get(k)) < 0) {
                ++k;
            }
            if (((Comparable)array.get(j - 1)).compareTo(array.get(k - 1)) < 0) {
                Object temp = array.get(j - 1);
                array.set(j - 1, array.get(k - 1));
                array.set(k - 1, temp);
            }
            j = k;
        }
    }

    private static void adjust(Comparable[] array, int lower, int upper) {
        int j = lower;
        for (int k = lower * 2; k <= upper; k *= 2) {
            if (k < upper && array[k - 1].compareTo(array[k]) < 0) {
                ++k;
            }
            if (array[j - 1].compareTo(array[k - 1]) < 0) {
                Comparable temp = array[j - 1];
                array[j - 1] = array[k - 1];
                array[k - 1] = temp;
            }
            j = k;
        }
    }

    private static void adjust(Object[] array, Comparator c, int lower, int upper) {
        int j = lower;
        for (int k = lower * 2; k <= upper; k *= 2) {
            if (k < upper && c.compare(array[k - 1], array[k]) < 0) {
                ++k;
            }
            if (c.compare(array[j - 1], array[k - 1]) < 0) {
                Object temp = array[j - 1];
                array[j - 1] = array[k - 1];
                array[k - 1] = temp;
            }
            j = k;
        }
    }

    private static void adjust(double[] array, int lower, int upper) {
        int j = lower;
        for (int k = lower * 2; k <= upper; k *= 2) {
            if (k < upper && array[k - 1] < array[k]) {
                ++k;
            }
            if (array[j - 1] < array[k - 1]) {
                double temp = array[j - 1];
                array[j - 1] = array[k - 1];
                array[k - 1] = temp;
            }
            j = k;
        }
    }

    private static void adjustAbs(double[] array, int lower, int upper) {
        int j = lower;
        for (int k = lower * 2; k <= upper; k *= 2) {
            if (k < upper && Math.abs(array[k - 1]) < Math.abs(array[k])) {
                ++k;
            }
            if (Math.abs(array[j - 1]) < Math.abs(array[k - 1])) {
                double temp = array[j - 1];
                array[j - 1] = array[k - 1];
                array[k - 1] = temp;
            }
            j = k;
        }
    }

    private static void adjust(double[] array, int[] indices, int lower, int upper) {
        int j = lower;
        for (int k = lower * 2; k <= upper; k *= 2) {
            if (k < upper && array[indices[k - 1]] < array[indices[k]]) {
                ++k;
            }
            if (array[indices[j - 1]] < array[indices[k - 1]]) {
                int temp = indices[j - 1];
                indices[j - 1] = indices[k - 1];
                indices[k - 1] = temp;
            }
            j = k;
        }
    }
}

