/*
 * Decompiled with CFR 0.152.
 */
package ev.poi;

import ev.multi.Segmenter;
import ev.poi.PoissonAlignerMain;
import ev.poi.PoissonModel;
import ev.poi.PoissonSampleProcessor;
import ev.poi.SampleContext;
import ev.poi.processors.ChainedProcessor;
import ev.poi.processors.CountEdgeProcessor;
import ev.poi.processors.TreeDistancesProcessor;
import ev.poi.processors.UnrootedCladesProcessor;
import ev.poi.proposals.MSAProposal;
import ev.poi.proposals.ParameterProposal;
import ev.poi.proposals.PoissonProposal;
import ev.poi.proposals.PoissonProposalOptions;
import ev.poi.proposals.RootingProposal;
import ev.poi.proposals.TreeProposal;
import fig.basic.LogInfo;
import fig.basic.UnorderedPair;
import goblin.CognateId;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ma.GreedyDecoder;
import ma.MSAPoset;
import nuts.math.Sampling;
import nuts.math.StatisticsMap;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import nuts.util.Counter;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import pty.UnrootedTree;
import pty.mcmc.ProposalDistribution;

public class PoissonModelSampler {
    public final PoissonModel model;
    public final Segmenter segmenter;
    private Random rand = null;
    public static PoissonProposalOptions poissonOptions = PoissonProposalOptions.instance;
    public ProposalDistribution.Options treeProposalOptions = PoissonAlignerMain.proposalOptions;
    public CountEdgeProcessor msaProcessor = new CountEdgeProcessor();
    public UnrootedCladesProcessor treeProcessor = new UnrootedCladesProcessor();
    public TreeDistancesProcessor distanceProcessor = new TreeDistancesProcessor();
    public StatisticsMap<String> acceptanceRates = new StatisticsMap();
    public SummaryStatistics topologyResamplingRate = new SummaryStatistics();
    private transient LinkedList<ProposalDistribution> proposalDistributions = new LinkedList();

    private Random rand() {
        if (this.rand == null) {
            this.rand = new Random(PoissonModelSampler.poissonOptions.rand);
        }
        return this.rand;
    }

    public void resetStats() {
        this.acceptanceRates = new StatisticsMap();
        this.topologyResamplingRate = new SummaryStatistics();
    }

    public PoissonModelSampler(PoissonModel model, Segmenter segmenter) {
        this.segmenter = segmenter;
        this.model = model;
    }

    public UnrootedTree getConsensusTopology(double threshold) {
        return this.treeProcessor.getConsensus(threshold);
    }

    public UnrootedTree getConsensusTopology() {
        return this.getConsensusTopology(0.5);
    }

    public UnrootedTree getConsensusTree() {
        return this.distanceProcessor.getConsensus();
    }

    public MSAPoset getConsensusMSA(double threshold) {
        try {
            if (threshold < 0.0 || threshold > 1.0) {
                throw new RuntimeException();
            }
            Counter<GreedyDecoder.Edge> desegmented = this.segmenter.desegment(this.msaProcessor.getEdgePosteriors());
            Counter<GreedyDecoder.Edge> filtered = new Counter<GreedyDecoder.Edge>();
            for (GreedyDecoder.Edge e : desegmented.keySet()) {
                if (!(desegmented.getCount(e) >= threshold)) continue;
                filtered.setCount(e, desegmented.getCount(e));
            }
            return MSAPoset.maxRecallMSA(this.segmenter.sequences(), filtered);
        }
        catch (Exception e) {
            LogInfo.error(e);
            e.printStackTrace();
            return new MSAPoset(this.segmenter.sequences());
        }
    }

    public MSAPoset getConsensusMSA() {
        return this.getConsensusMSA(0.5);
    }

    public MSAPoset getMaxRecallMSA() {
        return this.getConsensusMSA(0.0);
    }

    public void move() {
        this.move(poissonOptions, this.treeProposalOptions, this.msaProcessor, new ChainedProcessor(this.treeProcessor, this.distanceProcessor));
    }

    public void move(PoissonProposalOptions poissonOptions, ProposalDistribution.Options treeProposalOptions, PoissonSampleProcessor msaProcessor, PoissonSampleProcessor treeProcessor) {
        this.resampleInDelParams(poissonOptions);
        this.resampleTopology(poissonOptions, treeProposalOptions, treeProcessor);
        this.resampleRooting(poissonOptions);
        this.resampleMSA(poissonOptions, msaProcessor);
    }

    private void resampleMSA(PoissonProposalOptions poissonOptions, PoissonSampleProcessor processor) {
        Map clades = Arbre.debox(Arbre.leavesMap(this.model.currentRooted().topology()));
        ArrayList<Taxon> moveIndices = CollUtils.list(poissonOptions.useExtendedMSAMove ? this.model.currentRooted().topology().nodeContents() : this.model.currentRooted().topology().leaveContents());
        for (int i = 0; i < poissonOptions.nMSAResampling; ++i) {
            Collections.shuffle(moveIndices, this.rand());
            for (Taxon taxon : moveIndices) {
                Set<Taxon> taxaSet = clades.get(taxon);
                for (CognateId id : this.model.alignments.keySet()) {
                    MSAProposal proposal = new MSAProposal(this.model, id, taxaSet);
                    boolean accepted = this.move(proposal, this.rand(), poissonOptions.maximize);
                    processor.process(this.model, new SampleContext(proposal, accepted));
                }
            }
        }
    }

    private void resampleRooting(PoissonProposalOptions poissonOptions) {
        for (int i = 0; i < poissonOptions.nRerootingPerIterPerLang * this.model.currentUnrooted().leaves().size(); ++i) {
            this.move(new RootingProposal(this.model), this.rand(), poissonOptions.maximize);
        }
    }

    private void resampleTopology(PoissonProposalOptions poissonOptions, ProposalDistribution.Options treeProposalOptions, PoissonSampleProcessor treeProcessor) {
        for (int i = 0; i < poissonOptions.nTreeResamplePerIterPerLang * this.model.currentUnrooted().leaves().size(); ++i) {
            TreeProposal proposal = new TreeProposal(this.model, this.nextTreeResamplingProposal(treeProposalOptions, this.rand()));
            Set<UnorderedPair<Set<Taxon>, Set<Taxon>>> bipartitions = this.model.currentUnrooted().inducedBiPartitions2BranchMap().keySet();
            boolean accepted = this.move(proposal, this.rand(), poissonOptions.maximize);
            this.topologyResamplingRate.addValue(bipartitions.equals(this.model.currentUnrooted().inducedBiPartitions2BranchMap().keySet()) ? 0.0 : 1.0);
            treeProcessor.process(this.model, new SampleContext(proposal, accepted));
        }
    }

    private ProposalDistribution nextTreeResamplingProposal(ProposalDistribution.Options treeProposalOptions, Random rand) {
        UnrootedTree cur = this.model.currentUnrooted();
        if (this.proposalDistributions.isEmpty()) {
            this.proposalDistributions.addAll(ProposalDistribution.Util.proposalList(treeProposalOptions, cur, rand));
        }
        return this.proposalDistributions.poll();
    }

    private void resampleInDelParams(PoissonProposalOptions poissonOptions) {
        for (int iter = 0; iter < Math.max(poissonOptions.nResampleInsertParams, poissonOptions.nResampleDeleteParams); ++iter) {
            if (iter < poissonOptions.nResampleDeleteParams) {
                this.move(new ParameterProposal(this.model, poissonOptions.indelMultiplicativeProposalScaling, true), this.rand(), poissonOptions.maximize);
            }
            if (iter >= poissonOptions.nResampleInsertParams) continue;
            this.move(new ParameterProposal(this.model, poissonOptions.indelMultiplicativeProposalScaling, false), this.rand(), poissonOptions.maximize);
        }
    }

    public String parametersString() {
        double del = this.model.getCalculator().params.deleteRate;
        double ins = this.model.getCalculator().params.insertRate;
        return "DeletionRate\t" + del + "\nInsertionRate\t" + ins + "\nIntensityRate\t" + del * ins + "\nExpectedLength\t" + ins / del;
    }

    public String acceptString() {
        return "Topology change rate\t" + this.topologyResamplingRate.getMean() + "\n" + this.acceptanceRates;
    }

    public boolean move(PoissonProposal proposal, Random rand, boolean maximize) {
        boolean accept;
        double oldLL = this.model.jointLogProbability();
        double proposalLogRatio = proposal.doProposal(rand, maximize);
        double newLL = this.model.jointLogProbability();
        if (maximize) {
            accept = newLL > oldLL;
        } else {
            double logRatio = newLL - oldLL + proposalLogRatio;
            double acceptPr = Sampling.min1exp(logRatio);
            this.acceptanceRates.addValue(proposal.description(), acceptPr);
            boolean bl = accept = rand.nextDouble() < acceptPr;
        }
        if (!accept) {
            proposal.undo();
        }
        return accept;
    }
}

