/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import ev.io.TKFWeights;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import goblin.Taxon;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import ma.AffineGapAlignmentSampler;
import nuts.io.IO;
import nuts.util.Arbre;
import nuts.util.Counter;
import nuts.util.Tree;
import pepper.Encodings;
import pty.RootedTree;
import pty.UnrootedTree;

public class TreeEditor {
    public static Set<Taxon> keepOnlyFartherLeaves(UnrootedTree nct, Taxon heldoutLeaf, double reconHardnessIncreaseFactor) {
        Set<Taxon> current = nct.leavesSet();
        current.remove(heldoutLeaf);
        double mh = TreeEditor.maxHeight(nct);
        while (TreeEditor.height(nct, current, heldoutLeaf) < reconHardnessIncreaseFactor * mh) {
            current.remove(TreeEditor.closestLeaf(nct, current, heldoutLeaf));
        }
        return current;
    }

    public static double maxHeight(UnrootedTree nct) {
        double max = Double.NEGATIVE_INFINITY;
        for (Taxon node : nct.getTopology().vertexSet()) {
            double d;
            double cur = TreeEditor.height(nct, nct.leavesSet(), node);
            if (!(d > max)) continue;
            max = cur;
        }
        return max;
    }

    public static double height(UnrootedTree nct, Collection<Taxon> leavesSubset, Taxon root) {
        return TreeEditor._height(nct, leavesSubset, root).getFirst();
    }

    public static Taxon closestLeaf(UnrootedTree nct, Collection<Taxon> leavesSubset, Taxon root) {
        return TreeEditor._height(nct, leavesSubset, root).getSecond();
    }

    public static Pair<Double, Taxon> _height(UnrootedTree nct, Collection<Taxon> leavesSubset, Taxon root) {
        double min = Double.POSITIVE_INFINITY;
        Taxon argmin = null;
        for (Taxon lang : leavesSubset) {
            double d;
            double cur = nct.totalBranchLengthDistance(root, lang);
            if (!(d < min)) continue;
            min = cur;
            argmin = lang;
        }
        return Pair.makePair(min, argmin);
    }

    public static void main(String[] args) {
        IO.run(args, new TreeEditorMain());
    }

    public static class TreeEditorMain
    implements Runnable {
        @Option
        public String nonClockTree = "data/gutell/processed/vertebrata-mltree/tree.newick";
        @Option
        public String rootSpecies = "Homsapiens1";
        @Option
        public double addSmallDelta = 1.0E-4;
        @Option
        public double reconHardnessIncreaseFactor = 0.5;
        @Option
        public boolean flattenTree = true;

        @Override
        public void run() {
            File treeFile = new File(this.nonClockTree);
            Taxon root = new Taxon(this.rootSpecies);
            UnrootedTree nct = UnrootedTree.fromNewick(treeFile);
            Tree<Taxon> t = nct.toTree(root);
            if (t.getChildren().size() > 1) {
                throw new RuntimeException();
            }
            t = t.getChildren().get(0);
            t.setLabel(root);
            Set<Taxon> toRetain = TreeEditor.keepOnlyFartherLeaves(nct, root, this.reconHardnessIncreaseFactor);
            Taxon closest = null;
            double min = Double.POSITIVE_INFINITY;
            for (Taxon lang : toRetain) {
                double d;
                double cur = nct.totalBranchLengthDistance(root, lang);
                if (!(d < min)) continue;
                min = cur;
                closest = lang;
            }
            LogInfo.logsForce("Closest: " + closest);
            this.process(toRetain, t, nct);
        }

        public void process(Set<Taxon> toRetain, Tree<Taxon> t, UnrootedTree nct) {
            Taxon root = t.getLabel();
            t = t.deepCopy();
            LogInfo.logsForce("Leaves retained (not counting heldout):" + toRetain.size() + "/" + nct.leaves().size());
            LogInfo.logsForce("After reroot:\n" + Arbre.tree2Arbre(t).deepToString());
            t = RootedTree.Util.restrict(t, toRetain);
            while (t.getChildren().size() == 1) {
                t = t.getChildren().get(0);
            }
            t.setLabel(root);
            LogInfo.logsForce("After restrict:\n" + Arbre.tree2Arbre(t).deepToString());
            if (this.flattenTree) {
                t = this.flatten(t);
                LogInfo.logsForce("After flattening:\n" + Arbre.tree2Arbre(t).deepToString());
            } else {
                t = RootedTree.Util.removeUselessInternalNodes(t);
                LogInfo.logsForce("After remove useless internal:\n" + Arbre.tree2Arbre(t).deepToString());
            }
            LogInfo.logsForce("Creating rooted topology lisp file");
            IO.writeToDisk(new File(Execution.getFile("topo.lisp")), t.toString());
            LogInfo.logsForce("Creating init TKF91 weights");
            AffineGapAlignmentSampler.TKFParams params = new AffineGapAlignmentSampler.TKFParams(Encodings.EncodingType.RNA);
            Map<Taxon, AffineGapAlignmentSampler.CompiledTKFParams> compiled = TKFWeights.compiledTKFParams(params, nct, Arbre.tree2Arbre(t), this.addSmallDelta);
            Counter<String> w = TKFWeights.weights(compiled);
            PrintWriter out = IOUtils.openOutHard(Execution.getFile("tkf.weights"));
            for (String key : w) {
                out.println(key + "\t" + w.getCount(key));
            }
            out.close();
        }

        private Tree<Taxon> flatten(Tree<Taxon> t) {
            ArrayList children = new ArrayList();
            for (Taxon lang : t.getYield()) {
                children.add(new Tree<Taxon>(lang));
            }
            return new Tree<Taxon>(t.getLabel(), children);
        }
    }
}

