/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.remote;

import fig.basic.StrUtils;
import fig.basic.SysInfoUtils;
import fig.exec.remote.RemoteExecutorService;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RemoteExecutorServiceProxy
implements ExecutorService {
    private List<RemoteExecutorService> remoteExecutors;
    private Iterator<RemoteExecutorService> nextExecutor;
    private int maxNumHosts;
    private List<String> possibleHosts;
    private List<Integer> ports;

    RemoteExecutorServiceProxy(List<String> possibleHosts, int maxNumHosts, List<Integer> ports) {
        this.possibleHosts = possibleHosts;
        this.maxNumHosts = maxNumHosts;
        if (ports == null) {
            ports = new ArrayList<Integer>();
        }
        this.ports = ports;
    }

    @Override
    public boolean awaitTermination(long arg0, TimeUnit arg1) throws InterruptedException {
        try {
            boolean terminatedNormally = true;
            for (RemoteExecutorService exec : this.remoteExecutors) {
                terminatedNormally &= exec.remoteAwaitTermination(arg0, arg1);
            }
            return terminatedNormally;
        }
        catch (RemoteException e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0) throws InterruptedException {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
        for (Callable<T> callable : arg0) {
            futures.add(this.submit(callable));
        }
        return futures;
    }

    private RemoteExecutorService getNextExecutor() {
        if (!this.nextExecutor.hasNext()) {
            this.nextExecutor = this.remoteExecutors.iterator();
        }
        if (!this.nextExecutor.hasNext()) {
            return null;
        }
        RemoteExecutorService next = this.nextExecutor.next();
        return next;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> arg0) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        try {
            boolean isShutdown = true;
            for (RemoteExecutorService exec : this.remoteExecutors) {
                isShutdown &= exec.remoteIsShutdown();
            }
            return isShutdown;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isTerminated() {
        try {
            boolean isTerminated = true;
            for (RemoteExecutorService exec : this.remoteExecutors) {
                isTerminated &= exec.remoteIsTerminated();
            }
            return isTerminated;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        try {
            for (RemoteExecutorService exec : this.remoteExecutors) {
                exec.remoteShutdown();
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        try {
            ArrayList<Runnable> runnables = new ArrayList<Runnable>();
            for (RemoteExecutorService exec : this.remoteExecutors) {
                runnables.addAll(exec.remoteShutdownNow());
            }
            return runnables;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> arg0) {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final Callable<T> tmp = arg0;
        return exec.submit(new Callable<T>(){

            @Override
            public T call() {
                try {
                    return RemoteExecutorServiceProxy.this.getNextExecutor().remoteSubmit(tmp);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public int pollExecutors() {
        this.remoteExecutors = new ArrayList<RemoteExecutorService>();
        block3: for (String remoteHost : this.possibleHosts) {
            for (int port : this.ports) {
                try {
                    Registry registry = LocateRegistry.getRegistry(remoteHost, port);
                    RemoteExecutorService calc = (RemoteExecutorService)registry.lookup("RMI_WORKER");
                    String codebase = System.getProperty("java.class.path");
                    String[] split = codebase.split(":");
                    for (int i = 0; i < split.length; ++i) {
                        split[i] = "file://" + split[i];
                    }
                    codebase = StrUtils.join(split, " ");
                    if (codebase != "") {
                        codebase = codebase + " ";
                    }
                    if (calc.initialize(codebase = codebase + "file://" + SysInfoUtils.getcwd())) {
                        this.remoteExecutors.add(calc);
                    }
                    if (this.remoteExecutors.size() < this.maxNumHosts) continue;
                    break block3;
                }
                catch (RemoteException re) {
                    System.out.println(re.getMessage());
                    re.printStackTrace();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.nextExecutor = this.remoteExecutors.iterator();
        return this.remoteExecutors.size();
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(Executors.callable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.submit(Executors.callable(task, result));
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.getNextExecutor().remoteExecute(command);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}

