/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.IOUtils;
import fig.exec.servlet.DirSource;
import fig.exec.servlet.Field;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FieldsSpec;
import fig.exec.servlet.FileItem;
import fig.exec.servlet.FileView;
import fig.exec.servlet.Item;
import fig.exec.servlet.MapFileField;
import fig.exec.servlet.MapFileItem;
import fig.exec.servlet.MyException;
import fig.exec.servlet.OperationException;
import fig.exec.servlet.OperationRP;
import fig.exec.servlet.Permissions;
import fig.exec.servlet.ResponseObject;
import fig.exec.servlet.ResponseParams;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.Value;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class ExecItem
extends Item {
    private static final int runningTimeoutMs = 300000;
    private FieldsSpec fieldsSpec;
    private boolean isDead = false;
    private boolean hasUpdated = false;
    private boolean immutable = false;

    @Override
    public boolean isDead() {
        return this.isDead;
    }

    public boolean hasUpdated() {
        return this.hasUpdated;
    }

    public boolean immutable() {
        return this.immutable;
    }

    public ExecItem(Trail trail, DirSource source, FieldsSpec fieldsSpec) {
        this.trail = trail;
        this.source = source;
        this.fieldsSpec = fieldsSpec;
        if (!this.isDivider()) {
            this.clearMapFileItems();
        }
    }

    @Override
    protected Value getFieldValue(String name) throws MyException {
        if (name.equals("last")) {
            return this.getSinceLastModifiedTimeValue();
        }
        if (name.equals("host")) {
            String value = new MapFileField(null, null, (String)"info.map", (String)"Host", (FileView)this.source.getFileView()).getValue((Item)this).value;
            if (value == null) {
                return badValue;
            }
            int i = value.indexOf(46);
            if (i != -1) {
                value = value.substring(0, i);
            }
            return new Value(value);
        }
        return super.getFieldValue(name);
    }

    public Value getSinceLastModifiedTimeValue() throws MyException {
        FileItem item = (FileItem)this.source.getFileView().getItem(new File(this.getGroundedPath(), "output.map").toString());
        Value value = item.getSinceLastModifiedTimeValue();
        if (value == null) {
            return null;
        }
        if (this.isRunning() && item.getSinceLastModifiedTime() >= 300000L) {
            return new Value(value.value + "*", value.cmpKey);
        }
        return value;
    }

    public boolean isRunning() {
        String status = this.getStatus();
        return status == null || "running".equals(status);
    }

    public String getStatus() {
        try {
            Value value = this.getStatusField().getValue(this);
            return value == null ? null : value.value;
        }
        catch (MyException e) {
            return null;
        }
    }

    private Field getStatusField() {
        return new MapFileField("status", "Program status", "output.map", "exec.status", this.source.getFileView());
    }

    @Override
    protected FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap(this.source.getFileView());
        fields.add(new Field("host", "Host on which this execution happened"));
        fields.add(new MapFileField("date", "When the execution began", "info.map", "Date", Date.class, this.source.getFileView()));
        fields.add((Field)new Field((String)"last", (String)"Time since last modification")).numeric = true;
        (new Object[1])[0] = "output.map:exec.memory";
        fields.add((String)"mem", (String)"Memory usage", (Object[])new Object[1]).numeric = true;
        (new Object[1])[0] = "output.map:exec.time";
        fields.add((String)"time", (String)"Execution time", (Object[])new Object[1]).numeric = true;
        Object[] objectArray = new Object[]{"output.map:exec.errors", ",", "output.map:exec.warnings"};
        fields.add((String)"err", (String)"Number of LogInfo warnings/errors", (Object[])objectArray).numeric = true;
        fields.add(this.getStatusField());
        ExecItem.addFieldsFromSpec(this.fieldsSpec, fields);
        (new Object[1])[0] = "options.map:exec.miscOptions";
        fields.add((String)"opts", (String)"Miscellaneous options", (Object[])new Object[1]).mutable = true;
        (new Object[1])[0] = "options.map:log.note";
        fields.add((String)"note", (String)"Random comments", (Object[])new Object[1]).mutable = true;
        return fields;
    }

    private static void addFieldsFromSpec(FieldsSpec fieldsSpec, FieldListMap fields) {
        for (FieldsSpec.Info info : fieldsSpec) {
            Field field = fields.addWithObjs(info.getName(), info.getGloss(), info.getData() != null ? info.getData().split(" ") : null);
            if (info.getNumeric()) {
                field.numeric = true;
            }
            field.processor = info.getProcessor();
        }
    }

    public Set<MapFileItem> getUsedMapFileItems() {
        HashSet<MapFileItem> mapFileItems = new HashSet<MapFileItem>();
        for (Field field : this.getMetadataFields().values()) {
            if (!(field instanceof MapFileField)) continue;
            MapFileField mapFileField = (MapFileField)field;
            MapFileItem mapFileItem = mapFileField.getMapFileItemEasy(this);
            mapFileItems.add(mapFileItem);
        }
        return mapFileItems;
    }

    public void clearMapFileItems() {
        for (MapFileItem mapFileItem : this.getUsedMapFileItems()) {
            mapFileItem.clear();
        }
    }

    public void updateMapFileItems(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        for (MapFileItem mapFileItem : this.getUsedMapFileItems()) {
            spec.getQueue().enqueue(mapFileItem, priority);
        }
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        if (this.isDead) {
            return;
        }
        if (this.hasUpdated && this.immutable) {
            return;
        }
        this.updateMapFileItems(spec, priority);
        this.immutable = !this.isRunning();
        this.hasUpdated = true;
    }

    public void kill() throws MyException {
        try {
            File file = new File(this.source.getPath(), "kill");
            if (file.exists()) {
                return;
            }
            if (!file.createNewFile()) {
                throw new IOException("can't create new file");
            }
        }
        catch (IOException e) {
            throw new OperationException("Unable to kill " + this.trail.getName() + " by creating a kill file: " + e);
        }
    }

    public void purge() throws MyException {
        if (this.isDivider()) {
            throw new OperationException("Cannot purge dividers");
        }
        if (!IOUtils.purgePath(this.source.getPath())) {
            throw new OperationException("Unable to purge " + this.source.getPath());
        }
        this.clearMapFileItems();
        this.isDead = true;
    }

    @Override
    public ResponseObject handleOperation(OperationRP req, Permissions perm) throws MyException {
        String op = req.getOp();
        if (op.equals("kill")) {
            this.kill();
            return new ResponseParams("Killed " + this.trail.getName());
        }
        if (op.equals("reload")) {
            this.immutable = false;
            return new ResponseParams("Reloading " + this.trail.getName());
        }
        if (op.equals("purge")) {
            this.purge();
            return new ResponseParams("Purged " + this.trail.getName());
        }
        if (op.equals("getDirTable")) {
            String name = req.getReq("name");
            FileView fileView = ((DirSource)this.source).getFileView(this.source.getPath().toString());
            req = new OperationRP(req.getUpdateSpec());
            req.setOp("getItemsTable");
            req.put("name", name);
            return fileView.handleOperation(req, perm);
        }
        return super.handleOperation(req, perm);
    }
}

