/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.Fmt;
import fig.basic.ListUtils;
import fig.prob.GaussianSuffStats;
import fig.prob.SuffStats;

public class DiagMultGaussianSuffStats
implements SuffStats {
    private double[] sum;
    private double[] sumSq;
    private double n;

    public DiagMultGaussianSuffStats(int numDim) {
        this.sum = new double[numDim];
        this.sumSq = new double[numDim];
        this.n = 0.0;
    }

    public DiagMultGaussianSuffStats(double[] x) {
        this.sum = new double[x.length];
        this.sumSq = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            this.sum[i] = x[i];
            this.sumSq[i] = x[i] * x[i];
        }
        this.n = 1.0;
    }

    public DiagMultGaussianSuffStats(DiagMultGaussianSuffStats stats) {
        this.sum = (double[])stats.sum.clone();
        this.sumSq = (double[])stats.sumSq.clone();
        this.n = stats.n;
    }

    public DiagMultGaussianSuffStats(double[] sum, double[] sumSq, double n) {
        this.sum = sum;
        this.sumSq = sumSq;
        this.n = n;
    }

    public void add(double[] x) {
        for (int i = 0; i < this.sum.length; ++i) {
            int n = i;
            this.sum[n] = this.sum[n] + x[i];
            int n2 = i;
            this.sumSq[n2] = this.sumSq[n2] + x[i] * x[i];
        }
        this.n += 1.0;
    }

    @Override
    public void add(SuffStats _stats) {
        DiagMultGaussianSuffStats stats = (DiagMultGaussianSuffStats)_stats;
        for (int i = 0; i < this.sum.length; ++i) {
            int n = i;
            this.sum[n] = this.sum[n] + stats.sum[i];
            int n2 = i;
            this.sumSq[n2] = this.sumSq[n2] + stats.sumSq[i];
        }
        this.n += stats.n;
    }

    public void sub(double[] x) {
        for (int i = 0; i < this.sum.length; ++i) {
            int n = i;
            this.sum[n] = this.sum[n] - x[i];
            int n2 = i;
            this.sumSq[n2] = this.sumSq[n2] - x[i] * x[i];
        }
        this.n -= 1.0;
    }

    @Override
    public void sub(SuffStats _stats) {
        DiagMultGaussianSuffStats stats = (DiagMultGaussianSuffStats)_stats;
        for (int i = 0; i < this.sum.length; ++i) {
            int n = i;
            this.sum[n] = this.sum[n] - stats.sum[i];
            int n2 = i;
            this.sumSq[n2] = this.sumSq[n2] - stats.sumSq[i];
        }
        this.n -= stats.n;
    }

    public SuffStats reweight(double scale) {
        return new DiagMultGaussianSuffStats(ListUtils.mult(scale, this.sum), ListUtils.mult(scale, this.sumSq), scale * this.n);
    }

    public double[] getMean() {
        double[] x = new double[this.sum.length];
        for (int i = 0; i < this.sum.length; ++i) {
            x[i] = this.sum[i] / this.n;
        }
        return x;
    }

    public GaussianSuffStats getComponent(int i) {
        return new GaussianSuffStats(this.sum[i], this.sumSq[i], this.n);
    }

    public double[] getSum() {
        return this.sum;
    }

    public double[] getSumSq() {
        return this.sumSq;
    }

    public double getSum(int i) {
        return this.sum[i];
    }

    public double getSumSq(int i) {
        return this.sumSq[i];
    }

    public double numPoints() {
        return this.n;
    }

    public int dim() {
        return this.sum.length;
    }

    public String toString() {
        return String.format("sum(%s),sumSq(%s),n(%.1f)", Fmt.D(this.sum), Fmt.D(this.sumSq), this.n);
    }
}

