/*
 * Decompiled with CFR 0.152.
 */
package ma;

import goblin.CognateId;
import goblin.Taxon;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ma.MSAPoset;
import ma.MultiAlignment;
import ma.SequenceType;
import nuts.util.Tree;

public abstract class BioCorpus
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<CognateId, MultiAlignment> multiAlignments = new HashMap<CognateId, MultiAlignment>();
    protected Map<CognateId, Tree<String>> topologies = new HashMap<CognateId, Tree<String>>();
    protected Map<CognateId, Map<Taxon, Double>> branchLengths = new HashMap<CognateId, Map<Taxon, Double>>();
    protected final SequenceType type;
    public static final double BINARIZATION_BRANCH_LENGTH = 0.01;

    public SequenceType getType() {
        return this.type;
    }

    public BioCorpus(SequenceType type) {
        this.type = type;
    }

    public Set<CognateId> intersectedIds() {
        HashSet<CognateId> result = new HashSet<CognateId>();
        result.addAll(this.multiAlignments.keySet());
        result.retainAll(this.topologies.keySet());
        result.retainAll(this.branchLengths.keySet());
        return result;
    }

    public Map<CognateId, MultiAlignment> getMultiAlignments() {
        return Collections.unmodifiableMap(this.multiAlignments);
    }

    public MultiAlignment getMultiAlignment(CognateId id) {
        return this.multiAlignments.get(id);
    }

    public MSAPoset getMSAPoset(CognateId id) {
        return MSAPoset.coreBlocksFromMultiAlignmentObject(this.multiAlignments.get(id));
    }

    public void restricMultiAlignment(CognateId id, Collection<Taxon> langs) {
        this.multiAlignments.put(id, MultiAlignment.restrict(this.multiAlignments.get(id), langs));
    }

    public Tree<String> getTopology(CognateId id) {
        return this.topologies.get(id).deepCopy();
    }

    public Map<Taxon, Double> getBranchLengths(CognateId id) {
        return new HashMap<Taxon, Double>(this.branchLengths.get(id));
    }

    public void binarize() {
        for (CognateId id : this.intersectedIds()) {
            this.binarize(id);
        }
    }

    private void binarize(CognateId id) {
        Map<Taxon, Double> lengths = this.branchLengths.get(id);
        Tree<String> tree = this.topologies.get(id);
        this.topologies.put(id, this.binarize(tree, lengths));
    }

    private Tree<String> binarize(Tree<String> tree, Map<Taxon, Double> lengths) {
        List<Tree<String>> children = tree.getChildren();
        LinkedList modifiedChildren = new LinkedList();
        for (Tree<String> child : children) {
            modifiedChildren.add(this.binarize(child, lengths));
        }
        while (modifiedChildren.size() > 2) {
            int lastIndex = modifiedChildren.size() - 1;
            int secondToLastIndex = modifiedChildren.size() - 2;
            Tree childtree0 = (Tree)modifiedChildren.get(secondToLastIndex);
            Tree childtree1 = (Tree)modifiedChildren.get(lastIndex);
            modifiedChildren.remove(lastIndex);
            modifiedChildren.remove(secondToLastIndex);
            List mergedL = Arrays.asList(childtree0, childtree1);
            String label = (String)childtree0.getLabel() + "_" + (String)childtree1.getLabel();
            modifiedChildren.add(new Tree<String>(label, mergedL));
            Taxon lang = new Taxon(label);
            lengths.put(lang, 0.01);
        }
        return new Tree<String>(tree.getLabel(), modifiedChildren);
    }
}

